/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tGty
 */

package
{
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;

    public class Main extends Sprite
    {
        public function Main()
        {
            addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        }
        
        public function addedToStage($e:*) :void
        {
            removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
            
            addChild(new Quasi3D);
            
            init();
        }
    
        public function init() :void
        {
            graphics.clear();
            graphics.lineStyle(1);
            graphics.drawRect(0, 0, 464, 464);
        }
    }
}

import flash.display.*;
import flash.events.*;
import flash.geom.*;
import flash.text.*;

class Quasi3D extends Sprite
{
    private var _output :Output;
    
    protected var _face1 :Sprite;
    protected var _face2 :Sprite;
    protected var _face3 :Sprite;
    
    public function Quasi3D()
    {
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        _output = new Output("");
        _face1 = new Sprite();
        _face2 = new Sprite();
        _face3 = new Sprite();
    }
    
    public function addedToStage($e:*) :void
    {
        removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
       
        addChild(_output);
        
        addChild(_face2);
        //addChild(_face3);
        addChild(_face1);
       
        init();

        stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
    }
    
    public function init() :void
    {
        _face3.x = _face3.y = _face2.x = _face2.y = _face1.x = _face1.y = 183;
        _face3.x = 100;
    
        _face1.graphics.clear();
        _face1.graphics.beginFill(0xCCCCCC);
        _face1.graphics.drawRect(0, 0, 100, 100);
        _face1.graphics.endFill();
        
        _face2.graphics.clear();
        _face2.graphics.beginFill(0x666666);
        _face2.graphics.drawRect(0, 0, 100, 100);
        _face2.graphics.endFill();
        
        _face2.rotationY=(-90);

        _face3.graphics.clear();
        _face3.graphics.beginFill(0x999999);
        _face3.graphics.drawRect(0, 0, 100, 100);
        _face3.graphics.endFill();
        
        _face3.rotationY=(-180);
    }
    
    public function onMouseMove($e:MouseEvent) :void
    {
        _face2.x = _face1.x = $e.stageX;
        _face3.x = _face1.x + _face1.width;
        _face3.z = _face1.width;
        _face1.rotationY=$e.stageX;
        _face2.rotationY=((-90)+$e.stageX);
        _face3.rotationY=((-90)+$e.stageX);
        _face1.rotationZ=$e.stageX;
        _face2.rotationZ=$e.stageX;

        _output.content = "rotationX: " + _face1.rotationX + "\nrotationY: " + _face1.rotationY + "\nrotationZ: " + _face1.rotationZ;
    }
}

class Output extends TextField
{
    private var textFormat :TextFormat;
        
    protected var _x :Number;
    protected var _y :Number;
    protected var _font :String;
    protected var _content :String;
        
    public function Output($content:String, $x:Number = 1, $y:Number = 0, $font:String = "Helvetica")
    {
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
            
        _x = $x;
        _y = $y;
        _font = $font;
        _content = $content;
            
        multiline = true;
        autoSize = "left";
        selectable = mouseEnabled = false;
        antiAliasType = AntiAliasType.ADVANCED;
    }
        
    public function _init() :void
    {
        x = _x;
        y = _y;
        text = _content;
            
        textFormat = new TextFormat(_font);
        setTextFormat(textFormat);
    }
        
    public function addedToStage($e:Event) :void
    {
        removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
            
        _init(); 
    }
        
    public function get font() :String
    { return _font }
    public function get nWidth() :Number
    { return width }
        
    public function set font($:String) :void
    { _font = $; _init() }
    public function set content($:String) :void
    { _content = $; _init() }
}