/**
 * Copyright mousepancyo ( http://wonderfl.net/user/mousepancyo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tGXi
 */

/*
「ただの回転運動」に多少実装を加えて太陽系にしてみた。
次の課題はそれぞれの惑星に「引力」を持たせることだけど、
出来るのか？できません。
でもまぁ、頑張ってはみますがどうやって実装したらいいものか…
*/
package{
    import flash.display.Sprite
    import flash.events.Event;
    import flash.geom.Point;
    
    [SWF(width=465, height=465, backgroundColor=0,frameRate=30)]
    
    public class Main extends Sprite{
        
        private var _circleList:Vector.<Circle> = new Vector.<Circle>()
        private var _motionList:Vector.<CircleMotion> = new Vector.<CircleMotion>()
        //
        private const _sizeList:Vector.<int> = Vector.<int>([3, 4, 6, 4, 16, 18, 12, 10])
        private const _speedList:Vector.<Number> = Vector.<Number>([4.166,1.64,1,0.53,0.084,0.034,0.012,0.0061])
        private const _radList:Vector.<int> = Vector.<int>([5, 16, 35, 60, 90, 130, 180,220])
        private const _circleColorList:Vector.<int> = Vector.<int>([0xB3B0B8, 0xADA224, 0x2DD0AB, 0xB34D0C, 0x907853, 0xA08B14, 0x83AAD7, 0x2D7DB8])
        private const _deceleration:Number = 0.2
        
        public function Main(){
            var base:Base = new Base(0, stage.stageWidth, stage.stageHeight)
            addChild(base)
            for(var i:int=0; i<_sizeList.length; i++){
                var col:int = 0x303030
                createPlanet(_circleColorList[i], _sizeList[i], _speedList[i]*_deceleration, _radList[i])
                _circleList[i].addEventListener(Event.ENTER_FRAME, update)
                base.graphics.lineStyle(1, col, 1, true, "normal",null, null, 1)
                base.graphics.drawCircle(stage.stageWidth/2, stage.stageHeight/2, _radList[i])    
            }
            createMoon()
            createRing()
        }
        
        private function createPlanet(color:int, size:int, speed:Number, rad:Number):void{
            var circle:Circle = new Circle(color, size, speed, rad)
            _circleList.push(circle)
            circle.x = stage.stageWidth/2
            circle.y = stage.stageHeight/2
            circle.pos = new Point(circle.x, circle.y)
            addChild(circle)
        }
        
        private function createMoon():void{
            var moon:Circle = new Circle(0xB9D7EC, 2, 13.18*_deceleration, 9)
            moon.x = 0
            moon.y = 0
            moon.pos = new Point(moon.x, moon.y)
            _circleList[2].addChild(moon)
            moon.addEventListener(Event.ENTER_FRAME, update)
        }
        
        private function createRing():void{
            _circleList[5].graphics.lineStyle(1,0xFFE7BE, 0.5)
            _circleList[5].graphics.drawCircle(0,0,20)
            _circleList[5].graphics.lineStyle(2,0xFFE7BE, 0.2)
            _circleList[5].graphics.drawCircle(0,0,22)
            _circleList[5].graphics.lineStyle(1,0xFFE7BE, 0.3)
            _circleList[5].graphics.drawCircle(0,0,23)
        }
        
        private function update(e:Event):void{
            e.target.x = e.target.motion.setPos(e.target.pos).x
            e.target.y = e.target.motion.setPos(e.target.pos).y
        }
    }
}

//class Circle
import flash.display.Sprite;
import flash.display.BitmapData;
import flash.display.Bitmap;
import flash.geom.Point;

class Circle extends Sprite{
    private var _pos:Point = new Point()
    private var _speed:Number
    private var _radius:Number
    private var _motion:CircleMotion;
    
    public function Circle(color:int,r:int, speed:Number, rad:Number):void{
        _speed = speed
        _radius = rad
        //
        var colors:Array = [color, 0]
        var alphas:Array = [1, 1]
        var ratios:Array = [0, 50]
        graphics.beginGradientFill("radial", colors, alphas, ratios)
        graphics.drawCircle(0,0,r)
        graphics.endFill()
        //
        _motion = new CircleMotion(_speed, _radius)
    }
    
    public function get motion():CircleMotion{
        return _motion
    }
    public function set pos(p:Point):void{
        _pos = p
    }
    public function get pos():Point{
        return _pos
    }
    public function set speed(s:Number):void{
        _speed = s
    }
    public function get speed():Number{
        return _speed
    }
    public function set radius(r:Number):void{
        _radius = r
    }
    public function get radius():Number{
        return _radius
    }
}

//class CircreMotion
import flash.geom.Point;

class CircleMotion{
   private var _angle:Number;
   private var _speed:Number;
   private var _radius:Number;
   private var _point:Point = new Point()
   
   public function CircleMotion(speed:Number, rad:Number){
       _speed = speed
       _radius = rad
       _angle = (Math.floor(Math.random()*18))*10
   }
    
    public function setPos(pos:Point):Point{
        var radian:Number = _angle * Math.PI / 90;
        _point.x = pos.x + _radius * Math.cos(radian);
        _point.y = pos.y + _radius * Math.sin(radian);
        _angle += _speed;
        return _point
    }
    
    public function set speed(speed:Number):void{
        _speed = speed;
    }
    public function get speed():Number{
        return _speed;
    }
    public function set radius(rad:Number):void{
        _radius = rad;
    }
    public function get radius():Number{
        return _radius;
    }
}

//class Base
import flash.display.Sprite
class Base extends Sprite{
    public function Base(color:int,w:int,h:int):void{
        graphics.beginFill(color, 1)
        graphics.drawRect(0,0,w,h)
        graphics.endFill()
    }
}