/**
 * Copyright Mohammad.Jafari ( http://wonderfl.net/user/Mohammad.Jafari )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tGQ5
 */

// forked from christian's flash on 2013-2-21
package 
{
    import flash.geom.*;
    import flash.display.*;

    public class FlashTest extends Sprite
    {
        private var w : uint = 465, h : uint = 465, n : uint = 720, b : BitmapData;
        private var matrix : Matrix = new Matrix ();
        private var r : Number = Math.PI / 180;
        private var p : Point = new Point ();

        private var stack : Vector.<PIECE> = new Vector.<PIECE>(n, true);
        private var piece : PIECE;

        private var t : int = 1 + Math.random () * 5;
        private var angle : Number = 360 / n;


        public function FlashTest ()
        {
            t = Math.random () < 0.5 ? t : -t;

            addChild (new Bitmap (b = new BitmapData (w, h)));

            for (var i : int = 0; i < n; i++)
            {
                stack[i] = piece = new PIECE (0x202020, 75, 2.5, 5);

                matrix.identity ();
                matrix.rotate (angle * i * r * t);
                matrix.translate
                (
                    (w >> 1) + Math.cos (angle * i * r) * 109,
                    (h >> 1) + Math.sin (angle * i * r) * 109
                );
                
                b.draw (piece, matrix, null, null, null, true);
            }
        }
    }
}

import flash.geom.*;
import flash.display.*;

final class PIECE extends BitmapData
{
    public function PIECE (color : uint = 0, size : uint = 100, vari : uint = 15, step : uint = 5)
    {
        super (size + vari * 2, size + vari * 2, true, 0)

        var t : Shape = new Shape ();
        var g : Graphics = t.graphics;

        g.lineStyle (1, color, Math.random () * 0.5);
        g.beginFill (0xFFFFFF, 0);
        g.moveTo (0, 0);

        for (var i : int = 0; i <= size; i+= step)
        g.lineTo (i, i == size ? 0 : -vari + Math.random () * vari * 2);

        for (i = 0; i <= size; i+= step)
        g.lineTo (i == size ? size : size + (-vari + Math.random () * vari * 2), i);

        for (i = size; i >= 0; i-= step)
        g.lineTo (i, i == size ? size : size + (-vari + Math.random () * vari * 2));     

        for (i = size; i >= 0; i-= step)
        g.lineTo (i == size ? 0 : -vari + Math.random () * vari * 2, i);   

        draw (t, new Matrix (1, 0, 0, 1, vari, vari));
    }
}