/**
 * Copyright romatica ( http://wonderfl.net/user/romatica )
 * GNU General Public License, v3 ( http://www.gnu.org/licenses/quick-guide-gplv3.html )
 * Downloaded from: http://wonderfl.net/c/tG45
 */

// forked from romatica's FLARToolkit 2値化された解析画像を表示確認（thresholded BitmapData of source image）
// forked from tarotarorg's FLARToolKit Multi Marker Sample(FLAR, Hiro)
/*
 *　「閾値の値をスライダーにより調整できるサンプル」
 * 　 Threshold Change Slider
 *  
 * 　 ２値化するために使用している閾値をスライダで調整。
 *  　デフォルトは80。
 * 　 範囲は0~255(だとおもうが,0に設定したときに真っ黒にならないなぁ)
 * 
  * ┏━━━━━┓
  * ┃┏━━━┓┃
  * ┃┃ F L ┃┃ www.romatica.com/dev/resource/flarlogo-marker.pdf
  * ┃┃ A R ┃┃
  * ┃┗━━━┛┃
  * ┗━━━━━┛
  * ┏━━━━━━┓
  * ┃┏━━━━┓┃
  * ┃┃      ┃┃ www.romatica.com/dev/resource/hiro-marker.pdf
  * ┃┃ Hiro ┃┃
  * ┃┗━━━━┛┃
  * ┗━━━━━━┛
  * 
 */

package {
	import com.bit101.components.HUISlider;

	import org.libspark.flartoolkit.core.FLARCode;
	import org.libspark.flartoolkit.core.param.FLARParam;
	import org.libspark.flartoolkit.core.raster.rgb.FLARRgbRaster_BitmapData;
	import org.libspark.flartoolkit.core.transmat.FLARTransMatResult;
	import org.libspark.flartoolkit.detector.FLARMultiMarkerDetector;
	import org.libspark.flartoolkit.support.pv3d.*;
	import org.papervision3d.lights.PointLight3D;
	import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
	import org.papervision3d.materials.utils.MaterialsList;
	import org.papervision3d.objects.primitives.*;
	import org.papervision3d.render.LazyRenderEngine;
	import org.papervision3d.scenes.Scene3D;
	import org.papervision3d.view.Viewport3D;

	import flash.display.*;
	import flash.events.*;
	import flash.media.*;
	import flash.net.URLLoader;
	import flash.net.URLLoaderDataFormat;
	import flash.net.URLRequest;

	public class MultiMarker_ThersholdChanger extends Sprite {
		protected var _param : FLARParam;
		protected var _code : FLARCode;
		protected var _raster : FLARRgbRaster_BitmapData;
		protected var _detector : FLARMultiMarkerDetector;

		protected var _webcam : Camera;
		protected var _video : Video;
		protected var _capture : Bitmap;
		protected var _base : Sprite;
		protected var _viewport : Viewport3D;
		protected var _camera3d : FLARCamera3D;
		protected var _scene : Scene3D;
		protected var _renderer : LazyRenderEngine;
		protected var _markerNodes : Array;

		protected var _resultMat : FLARTransMatResult = new FLARTransMatResult();
		protected var _detectedResults : Array;
		protected var therBMD : Bitmap;
		private var _patternCodeURLArr : Array;
		private var _patterLoadCount : int = 0
		private var markerPatternCodeArr : Array;
		private var slider_thershod : HUISlider;
		private var _threshold : int = 80;

		
		public function MultiMarker_ThersholdChanger() {
			_param = new FLARParam();
			_param.changeScreenSize(320, 240);
			
			//パターンファイルURL
			_patternCodeURLArr = []
			_patternCodeURLArr.push("http://assets.wonderfl.net/static/flar/flarlogo.pat")
			_patternCodeURLArr.push("http://www.romatica.com/dev/resource/hiro.pat")
			
			markerPatternCodeArr = [];
			// マーカーパターンファイルの読込み
			for (var i : int = 0;i < _patternCodeURLArr.length;i++) {
				var urlLoader : URLLoader = new URLLoader();
				urlLoader.dataFormat = URLLoaderDataFormat.TEXT;
				urlLoader.addEventListener(Event.COMPLETE, this.onLoadCheckCodes);
				urlLoader.load(new URLRequest(_patternCodeURLArr[i]));
			}
		}

		//パターンファイルロードカウントチェック
		private function onLoadCheckCodes(event : Event) : void {
			markerPatternCodeArr[_patterLoadCount] = new FLARCode(16, 16, 50, 50);
			markerPatternCodeArr[_patterLoadCount].loadARPatt(event.target.data);
			_patterLoadCount++;
			
			if(_patterLoadCount >= _patternCodeURLArr.length) {
				trace("ALL PATTERN LOADED");
				_initCamera_FLAR();
				_initPV3D();
			}
		}

		//カメラとFLARセット
		private function _initCamera_FLAR() : void {
			// setup webcam
			_webcam = Camera.getCamera();
			if (!_webcam) {
				throw new Error('No webcam!!!!');
			}
			_webcam.setMode(320, 240, 30);
			_video = new Video(320, 240);
			_video.attachCamera(_webcam);
			_capture = new Bitmap(new BitmapData(320, 240, false, 0), PixelSnapping.AUTO, true);
			
			// setup ARToolkit
			_raster = new FLARRgbRaster_BitmapData(_capture.bitmapData);
			_detector = new FLARMultiMarkerDetector(_param, markerPatternCodeArr, [80, 80], 2);
			_detector.setContinueMode(true);
		}

		//PV3Dセット
		private function _initPV3D() : void {
			_base = addChild(new Sprite()) as Sprite;
			_base.addChild(_capture);
			_viewport = _base.addChild(new Viewport3D(320, 240)) as Viewport3D;
			_viewport.x = -4; // 4pix ???
			_camera3d = new FLARCamera3D(_param);
			_scene = new Scene3D();
			
			_markerNodes = new Array();
			_markerNodes[0] = _scene.addChild(new FLARBaseNode()) as FLARBaseNode;
			_markerNodes[1] = _scene.addChild(new FLARBaseNode()) as FLARBaseNode;

			// マーカー上に表示するものを定義
			var light : PointLight3D = new PointLight3D();
			light.x = 0;
			light.y = 1000;
			light.z = -1000;

			var flarFmat : FlatShadeMaterial = new FlatShadeMaterial(light, 0xFF0000, 0x660000);
			var flarCube : Cube = new Cube(new MaterialsList({ all:flarFmat }), 40, 40, 40);
			flarCube.z = 20;
			_markerNodes[0].addChild(flarCube);

			var hiroFmat : FlatShadeMaterial = new FlatShadeMaterial(light, 0x00FF00, 0x006600);
			var hiroCube : Cube = new Cube(new MaterialsList({ all:hiroFmat }), 40, 40, 40);
			hiroCube.z = 20;
			_markerNodes[1].addChild(hiroCube);
			
			_renderer = new LazyRenderEngine(_scene, _camera3d, _viewport);
			
			this._detectedResults = new Array();
			for (var j : int = 0;j < _markerNodes.length;j++) {
				this._detectedResults[j] = { confidence:0, index:0 };
			}
			//2値化画像と、しきい値変更UIをセット
			setVisibleThersholdeImage();

			addEventListener(Event.ENTER_FRAME, _onEnterFrame);
			//Wonderfl.capture_delay(20);
			
		}

		//2値化画像と、スライダー作成
		private function setVisibleThersholdeImage() : void {
			
			therBMD = addChild(new Bitmap(_detector.thresholdedBitmapData)) as Bitmap;
			therBMD.y = stage.stageHeight - therBMD.height;
			slider_thershod = new HUISlider(this, 10, 30, "Thershold", function(e : Event):void {
				_threshold = int(e.currentTarget.value);
			});
			slider_thershod.y = 250;
			slider_thershod.minimum = 0;
			slider_thershod.maximum = 255;
			slider_thershod.value = 80;
			addChild(slider_thershod)
		}

		private function _onEnterFrame(e : Event = null) : void {
			_capture.bitmapData.draw(_video);
			
			var detectedMarkers : int;
			
			try {
				detectedMarkers = _detector.detectMarkerLite(_raster, _threshold);
			} catch (e : Error) {
			}
			for (var i : int = 0;i < detectedMarkers;i++) {
				var confidence : Number = _detector.getConfidence(i);
				var codeIndex : int = _detector.getARCodeIndex(i);
				if (this._detectedResults[codeIndex].confidence < confidence) {
					this._detectedResults[codeIndex].confidence = confidence;
					this._detectedResults[codeIndex].index = i;
				}
			}
			for (var k : int = 0;k < this._detectedResults.length;k++) {
				var node : FLARBaseNode = _markerNodes[k] as FLARBaseNode;
				if (this._detectedResults[k].confidence > 0.5) {
					_detector.getTransmationMatrix(this._detectedResults[k].index, _resultMat);
					node.setTransformMatrix(_resultMat);
					node.visible = true;
				} else {
					node.visible = false;
				}
				this._detectedResults[k].index = 0;
				this._detectedResults[k].confidence = 0;
			}
			_renderer.render();
		}
	}
}