/**
 * Copyright hacker_yk666qry ( http://wonderfl.net/user/hacker_yk666qry )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tFop
 */

package {
	import flash.events.MouseEvent;
	import flash.text.TextField;
    import flash.display.Sprite;
    public class PagerSample extends Sprite {
    	
    		private var _pager:Pager;
    		private var _numField:TextField;
    		
    		//コンストラクタ
        public function PagerSample() {
        		
        		_pager = new Pager();
        		
        		_numField = new TextField();
        		_numField.width = 60;
        		_numField.height = 24;
        		addChild(_numField);
        		
        		var btnPrev:Sprite = new PageButton("PREV");
        		var btnNext:Sprite = new PageButton("NEXT");
        		
        		btnPrev.x = 70;
        		btnNext.x = 110;
        		
        		addChild(btnPrev);
        		addChild(btnNext);
        		
        		btnPrev.addEventListener( MouseEvent.CLICK, prevPage);
        		btnNext.addEventListener( MouseEvent.CLICK, nextPage );
        		
        		updatePager();
        }
        
        //max, minの説明
        //http://www.openspc2.org/reibun/FlashMX2004/ActionScript/Math/009/index.html
        private function prevPage(e:MouseEvent):void { 
        		_pager.prev();
        		
        		updatePager();
        }
        
        private function nextPage(e:MouseEvent):void {
        		_pager.next();
        		
        		updatePager();
        }
        
        private function updatePager():void {
        		_numField.text = String(_pager.getCurrentPage() + 1 ) + "/" + _pager.getTotalPages() + " Page";
        }
    }
}


import flash.display.Sprite;
import flash.text.TextField;

class PageButton extends Sprite {
	
	//コンストラクタ
	public function PageButton(label:String) {
		var textField:TextField = new TextField();
		textField.width = 36;
		textField.height = 24;
		textField.text = label;
		addChild(textField);
		buttonMode = true;
		mouseChildren = false;
	}
}


class Pager {
	private var _currentPage:int;
	private var _totalPages:int;
	private var _numField:TextField;
	
	public function Pager() {
		_currentPage = 0;
		_totalPages = 10;
	}
	
	public function prev():void {
		_currentPage = Math.max ( 0, _currentPage - 1);
	}
	
	public function next():void {
		_currentPage = Math.min ( _totalPages - 1, _currentPage + 1 );
	}

	public function getCurrentPage():int {
		return _currentPage;
	}
	
	public function getTotalPages():int {
		return _totalPages;
	}
}

