/**
 * Copyright hoooooonda ( http://wonderfl.net/user/hoooooonda )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tF5i
 */

// forked from hoooooonda's BitmapとhitTest
// forked from hoooooonda's パーティクルと当たり判定
package {
    import flash.geom.Rectangle;
    import flash.geom.Matrix;
    import flash.net.URLRequest;
    import flash.utils.Proxy;
    import flash.geom.Point;
    import flash.ui.Mouse;
    import flash.events.*;
    import flash.display.*;
    import flash.system.*;
    public class FlashTest extends Sprite {
        public var loader1:Loader;
        public var loader2:Loader;    
        public var bmp1:Bitmap;
        public var bmp2:Bitmap;
        public var rota:Number = 0;
        public var item:Sprite;
        public var rotaBmd:BitmapData;
        public var line:Sprite = new Sprite();
        
        public function FlashTest() {
           Security.loadPolicyFile("http://hr-portfolio.main.jp/crossdomain.xml"); 
                      
           loader1 = new Loader();
           loader1.load(new URLRequest("http://hr-portfolio.main.jp/test.png"));
           loader1.contentLoaderInfo.addEventListener(Event.COMPLETE, loaded);

           loader2 = new Loader();
           loader2.load(new URLRequest("http://hr-portfolio.main.jp/test2.png"));
           loader2.contentLoaderInfo.addEventListener(Event.COMPLETE, loaded);
                      
           bmp1 = new Bitmap();
           addChild(bmp1);           
           bmp2 = new Bitmap();           
           addChild(bmp2);
           addEventListener(Event.ENTER_FRAME, loop);
        }
        
        public function loaded(e:Event):void
        {
           if(e.target.loader == loader1)
           {
               var holder:Sprite = new Sprite();
               holder.addChild(e.target.loader);
               
               var bmpd:BitmapData = new BitmapData(holder.width, holder.height, true, 0x00000000);           
               bmpd.draw(holder);
               bmp1.bitmapData = bmpd;
               
               bmp1.x = stage.stageWidth/2 - bmp1.width/2;
               bmp1.y = stage.stageHeight/2 - bmp1.height/2; 
           }else
           {
               item = new Sprite();
               item.addChild(e.target.loader);
               //矩形の境界線↓
               line.graphics.lineStyle(1, 0x000000, 0.5);
               line.graphics.drawRect(item.x, item.y, item.width, item.height);
               line.graphics.endFill(); 
               item.addChild(line);
           }
        }
        
        public function rotateItem(rNum:Number):void
        {
            var rota2:int = 180 - (90 + rNum);
            //ピタゴラスの定理↓
            var x1:Number = item.width * Math.cos(rNum * Math.PI/180);
            var x2:Number = item.height * Math.cos(rota2 * Math.PI/180);
            var y1:Number = item.width * Math.sin(rNum * Math.PI/180);
            var y2:Number = item.height * Math.sin(rota2 * Math.PI/180);
            
            if(rNum > 90 && rNum <= 180)
            {
                x1 *= -1;
                y2 *= -1;
            }else if(rNum > 180 && rNum < 270)
            {
                x1 *= -1;
                x2 *= -1;
                y1 *= -1;
                y2 *= -1;
            }else if(rNum >= 270)
            {
                x2 *= -1;
                y1 *= -1;
            }
            
            if(rotaBmd != null)rotaBmd.dispose();
            rotaBmd = new BitmapData(x1 + x2, y1 + y2, true, 0x0f000000);            
            var mt:Matrix = new Matrix();
            mt.rotate(rNum * Math.PI/180); 
            /*--角度ごとのマトリックス移動--*/
            if(rNum <= 90)
            {
                mt.tx = x2;
                mt.ty = 0;
            }
            if(rNum > 90 && rNum <= 180)
            {
                mt.tx = x1 + x2;
                mt.ty = y2;    
            }else if(rNum > 180 && rNum < 270)
            {
                mt.tx = x1;
                mt.ty = y1 + y2;        
            }else if(rNum >= 270)
            {
                mt.tx = 0;
                mt.ty = y1;    
            }
            rotaBmd.lock();
            rotaBmd.draw(item, mt);
            rotaBmd.unlock();
            bmp2.bitmapData = rotaBmd;
            
            /*--角度ごとの移動--*/
            if(rNum <= 90)
            {
                bmp2.x = stage.stageWidth/2 - x2;
                bmp2.y = stage.stageHeight/2;
            }
            else if(rNum > 90 && rNum <= 180)
            {
                bmp2.x = stage.stageWidth/2 - (x1 + x2);
                bmp2.y = stage.stageHeight/2 - y2;
            }else if(rNum > 180 && rNum < 270)
            {
                bmp2.x = stage.stageWidth/2 - x1;
                bmp2.y = stage.stageHeight/2 - (y1 + y2);
            }else if(rNum >= 270)
            {
                bmp2.x = stage.stageWidth/2;
                bmp2.y = stage.stageHeight/2 - y1;
            }
        }        
        public function loop(e:Event):void
        {
            bmp1.x = mouseX - bmp1.width/2;
            bmp1.y = mouseY - bmp1.height/2;
            
            rota += 2;
            if(rota >= 360)rota = 0;
            rotateItem(rota);
            
            if(bmp1.bitmapData.hitTest(new Point(bmp1.x, bmp1.y), 255, bmp2.bitmapData, new Point(bmp2.x, bmp2.y), 255))
            {
                bmp1.alpha = 0.5;
            }else
            {
                bmp1.alpha = 1;
            }
        }
    }
}