/**
 * Copyright termat ( http://wonderfl.net/user/termat )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tEkN
 */

// forked from termat's Swing of the pendulum
package  
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import frocessing.color.ColorHSV;

    [SWF(width="480", height="480", backgroundColor="0xffffff", frameRate="60")];
    public class Practice86 extends Sprite{
        private var plates:Vector.<Plate>;
        private var col:ColorHSV = new ColorHSV();
        private var isRun:Boolean = true;
        
        public function Practice86() {
            plates = new Vector.<Plate>();
            ceratePlates(36, 240, 240, 20, 200, 170);
            ceratePlates(36, 240, 240, 20, 200, -170);
            addEventListener(Event.ENTER_FRAME, update);
            stage.addEventListener(MouseEvent.CLICK,function(e:MouseEvent):void{isRun=!isRun});
            Wonderfl.capture_delay(60);
        }
        
        public function update(e:Event):void {
            if(isRun)for each(var p:Plate in plates)p.update(0.1);    
        }
        
        private function ceratePlates(n:int, xx:Number, yy:Number, ww:Number, hh:Number, deg:Number):void {
            col.s = 1.0;
            col.v = 1.0;
            for (var i:int = 0; i < n; i++) {
                col.h = (360 / n) * i;
                var w:Number = ww;
                var h:Number = hh-i*0.2;
                var p:Plate = new Plate(xx, yy, w, h, 0.5, 0.05,col.value);
                addChild(p);
                p.deg = deg;
                plates.push(p);
            }
        }
        
    }
}
import flash.display.MovieClip;
import flash.geom.Point;
class Plate extends MovieClip {
    private static const G:Number = 9.8;
    public var px:Number;
    public var py:Number;
    public var tx:Number;
    public var ty:Number;
    public var w:Number;
    public var h:Number;
    public var deg:Number = 0;
    public var cx:Number;
    public var cy:Number;
    public var len:Number;
    public var adeg:Number = 0;
    public var color:uint;
    
    public function Plate(_x:Number, _y:Number, _w:Number, _h:Number, _rx:Number, _ry:Number,c:uint):void {
        this.px = _w * _rx;
        this.py = _h * _ry;
        this.x = _x + px;
        this.y = _y + py;
        this.w = Math.min(_w,_h);
        this.h = Math.max(_w, _h);
        this.cx = w-px;
        this.cy = h;
        this.len = Math.sqrt((px - cx) * (px - cx) + (py - cy) * (py - cy));
        color = c;
    }
    
    private function draw():void {
        graphics.clear();
        var rad:Number = deg / 180.0 * Math.PI;
        var xx:Number = 5*Math.sin(rad);
        var yy:Number = 5 * Math.cos(rad);
        var hh:Number = Math.min(h, 800);
        graphics.beginFill(0x222222,0.5);
        graphics.moveTo( -px + xx, -py + yy);
        graphics.lineTo( -px + w + xx, -py + yy);
        graphics.lineTo( -px + w + xx, -py + hh + yy);
        graphics.lineTo( -px + xx, -py + hh + yy);
        graphics.endFill();
        graphics.beginFill(color);
        graphics.moveTo( -px, -py);
        graphics.lineTo( -px + w, -py);
        graphics.lineTo( -px + w, -py + hh);
        graphics.lineTo( -px, -py + hh);
        graphics.endFill();
        graphics.beginFill(0x555555);
        graphics.drawCircle(0, 0, 3);
        graphics.endFill();
    }
    
    private function physics(dt:Number):void {
        var a:Number = -(G / len) * Math.sin(deg / 180.0 * Math.PI)*dt;
        adeg += (a / Math.PI) * 180.0;
    }
    
    public function update(dt:Number):void {
        physics(dt);
        deg = (deg + adeg) % 360;
        draw();
        this.rotationZ = deg;
    }
}