/**
 * Copyright naoto5959 ( http://wonderfl.net/user/naoto5959 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tEgh
 */

package  
{
  import com.bit101.components.Text;
  import com.bit101.components.PushButton;
  import flash.display.Loader;
  import flash.display.Sprite;
  import flash.display.StageQuality;
  import flash.events.Event;
  import flash.events.MouseEvent;
  import flash.net.URLRequest;
  import flash.system.Security;
  import org.libspark.betweenas3.BetweenAS3;
  [SWF(width=465,height=465,backgroundColor=0xFFFFFF)]
  /**
   * http://fla.la/archives/576
   * LoaderにMouseEvent.CLICKを設定しても反応しないことがあります。
   * これはクロススクリプティングにおける、ロード元swfファイルの
   * DisplayObjectツリーとロードしたswfファイルのDisplayObjectツリー間
   * のイベント伝達フローに当てはまるケースとなります。
   * イベント伝達には、各swf内部でお互いのドメインを引数にした
   * Security.domain()を実行する必要があります。
   * @author naoto koshikawa
   */
  public class Hoge1 extends Sprite
  {
    private static const AVATAR_BODY_URL:String 
            = "http://asmple.com/work/avatar3.swf";
      
    public function Hoge1() 
    {
      stage.quality = StageQuality.BEST;
      var txt:Text = new Text(this, 0, 20, "click the avatar\n\n");
      txt.width = stage.stageWidth;
      txt.height = stage.stageHeight - 20;
      txt.mouseChildren = false;
      
      var btn:PushButton = new PushButton(this, 0, 0, "Security.allowDomain()", function(event:MouseEvent):void {
        Security.allowDomain("asmple.com");
      });
      
      stage.addEventListener(MouseEvent.CLICK, function(event:MouseEvent):void {
        txt.text += "Capture Phase\n";
      }, true);
      
      stage.addEventListener(MouseEvent.CLICK, function(event:MouseEvent):void {
        txt.text += "Bubbling Phase\n";
      });
      
      var loader:Loader = new Loader();
      addChild(loader);
      
      loader.contentLoaderInfo.addEventListener(Event.INIT, function(event:Event):void {
        loader.x = stage.stageWidth / 2 * Math.random() + stage.stageWidth / 4;
        loader.y = stage.stageHeight / 2 * Math.random() + stage.stageHeight / 4;
        loader.addEventListener(MouseEvent.CLICK, function(e:MouseEvent):void {
          txt.text += "Target Phase\n";
          var avatar:* = loader.content;
          if (e.localX < loader.width / 2) {
            avatar.left();
            BetweenAS3.tween(avatar, { x: avatar.x + 20 }, { x:avatar.x }, 0.5).play();
          } else if (loader.width / 2 <= e.localX) {
            avatar.right();
            BetweenAS3.tween(avatar, { x: avatar.x - 20 }, { x:avatar.x }, 0.5).play();
          }
          avatar.play();
        });
      });
      
      loader.load(new URLRequest(AVATAR_BODY_URL));
    }
  }
}