/**
 * Copyright Fumio ( http://wonderfl.net/user/Fumio )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tECo
 */

package {
	import flash.display.Sprite;
	import flash.utils.getTimer;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFormat;
	import flash.text.TextFormatAlign;
	[SWF(width = "240",height = "180")]
	public class GettingOddAndEvenNumbers extends Sprite {
		private const COUNT:uint = 5000000;
		private const AMOUNT:uint = COUNT * 2;
		private var my_txt:TextField = new TextField();
		private var label_txt:TextField = new TextField();
		private var my_fmt:TextFormat = new TextFormat();
		public function GettingOddAndEvenNumbers() {
			// Creating a TextField for display
			createTextField();
			// createNumbers();
			warmingUp();
			// Starting Test
			testStandard();
			testMix();
			testBitwise();
		}
		private function testStandard():void {
			var odd:Vector.<uint> = new Vector.<uint>(COUNT);
			var even:Vector.<uint> = new Vector.<uint>(COUNT);
			var nAmount:uint = AMOUNT;
			var started:int = getTimer();
			for (var i:uint = 0; i < nAmount; i++) {
				if (i % 2 == 0) {
					even[uint(i / 2)] = i;
				} else {
					odd[uint(i / 2)] = i;
				}
			}
			xTrace("standard (% and uint())", getTimer() - started);
		}
		private function testMix():void {
			var odd:Vector.<uint> = new Vector.<uint>(COUNT);
			var even:Vector.<uint> = new Vector.<uint>(COUNT);
			var nAmount:uint = AMOUNT;
			var started:int = getTimer();
			for (var i:uint = 0; i < nAmount; i++) {
				if (i % 2 == 0) {
					even[i >> 1] = i;
				} else {
					odd[i >> 1] = i;
				}
			}
			xTrace("mix (% and >>)", getTimer() - started);
		}
		private function testBitwise():void {
			var odd:Vector.<uint> = new Vector.<uint>(COUNT);
			var even:Vector.<uint> = new Vector.<uint>(COUNT);
			var nAmount:uint = AMOUNT;
			var started:int = getTimer();
			for (var i:uint = 0; i < nAmount; i++) {
				if (i & 1 == 1) {
					odd[i >> 1] = i;
				} else {
					even[i >> 1] = i;
				}
			}
			xTrace("bitwise (& and >>)", getTimer() - started);
		}
		private function warmingUp():void {
			var nAmount:uint = AMOUNT;
			var started:int = getTimer();
			for (var i:uint = 0; i < nAmount; i++) {
				var n:uint = i;
			}
			var temp:uint = getTimer() - started;
		}
		private function createTextField():void {
			addChild(my_txt);
			addChild(label_txt);
			my_fmt.align = TextFormatAlign.RIGHT;
			my_txt.x +=  50;
			my_txt.defaultTextFormat = my_fmt;
			my_txt.autoSize = TextFieldAutoSize.RIGHT;
			label_txt.autoSize = TextFieldAutoSize.LEFT;
		}
		private function xTrace(_str:String,n:int):void {
			my_txt.appendText(String(n) + "\n");
			label_txt.appendText(_str + ":" + "\n");
		}
	}
}