/**
 * Copyright kazuyuki ( http://wonderfl.net/user/kazuyuki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tDoA
 */

// forked from kazuyuki's forked from: イージングなう
// forked from kazuyuki's イージングなう
package {
    import flash.display.Sprite;
    import flash.filters.GlowFilter;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.utils.Proxy;
    import flash.geom.Point;
    
    [SWF(width="465", height="465", backgroundColor="0x000000",frameRate="30")]
    public class animation extends Sprite {
    		
    		private var _ball:Sprite;
    		private var _timegage:Sprite;
    		private var _locus:Sprite;
    		
    		private var _startX:Number = 0;
    		private var _startY:Number = 0;
    		private var _endX:Number = stage.stageWidth;
    		private var _framecount:Number = 0;
    		private var _framecountLimit:Number = 150;
    		private var _animationframes:Array;
    		
        public function animation() {
            init()
        }
        
        public function init():void{
        		_animationframes = generate_animationFrames();
        		
        		_ball = new Sprite();
        		_ball.graphics.lineStyle(1,0x00ffff);
        		_ball.graphics.beginFill(0x00ffff,0.2);
        		_ball.graphics.drawCircle(0,0,5);
        		_ball.graphics.endFill();
        		//GlowFilter(color:uint = 0xFF0000, alpha:Number = 1.0, blurX:Number = 6.0, blurY:Number = 6.0, strength:Number = 2, quality:int = 1, inner:Boolean = false, knockout:Boolean = false)
        		_ball.filters = [new GlowFilter(0x00ffff,1,10,10,5,1)];
        		        		
        		_timegage = new Sprite();
        		_timegage.graphics.beginFill(0xff0000,1);        		        			
			//drawRect(x:Number, y:Number, width:Number, height:Number):void 
        		_timegage.graphics.drawRect(0,0,stage.stageWidth,3);
        		_timegage.graphics.endFill();
        		_timegage.y = stage.stageHeight-3;
        		
        		_locus = new Sprite();
        		

        		addChild(_ball);
        		addChild(_timegage);
        		addChild(_locus);
        		
			stage.addEventListener(MouseEvent.MOUSE_DOWN,startRec);
			stage.addEventListener(MouseEvent.MOUSE_UP,stopRec);
        		
        		updateLocus();
        		
        		start();
        }
        private function generate_animationFrames():Array{
        		var tmp:Array = new Array();
        		var easeRatio:Number = 0.2;
        		var tmpX:int = mouseX;
        		var tmpY:int = mouseY;
        		for(var i:int = 0;i<_framecountLimit; i++){
        			tmp.push(new Point(tmpX,tmpY));
        		}
        		return tmp;
        }
        	
        	private function render(e:Event):void{
        		if(_framecount < _framecountLimit){
        			_ball.x += (_animationframes[_framecount].x - _ball.x)/4;
        			_ball.y += (_animationframes[_framecount].y - _ball.y)/4;
        		}else{
        			_framecount = 0;
        		}
        		_timegage.width=(_framecount/_framecountLimit)*stage.stageHeight;
        		_framecount++;
        	}
        	
        	private function start():void{
        		addEventListener(Event.ENTER_FRAME,render);
        		}
        	private function stop():void{
        		removeEventListener(Event.ENTER_FRAME,render);
        		}
        	private function startRec(e:Event):void{
        		addEventListener(Event.ENTER_FRAME,recMouse);
        	};
        	private function stopRec(e:Event):void{
        		removeEventListener(Event.ENTER_FRAME,recMouse);
        	};
        	private function recMouse(e:Event):void{
        		if(_framecount < _framecountLimit){
        			_animationframes[_framecount].x = mouseX;
        			_animationframes[_framecount].y = mouseY;
        		}
        		updateLocus();
        	}
        private function updateLocus():void{//フレーム毎に記録されている座標から軌跡を描画するメソッド
			_locus.graphics.clear();
			_locus.graphics.lineStyle(1,0xFFFFFF,0.2);
			for(var i:uint=0;i<_framecountLimit;i++){
				_locus.graphics.drawCircle(_animationframes[i].x,_animationframes[i].y,2);
			}
		}
    }
}