/**
 * Copyright coppieee ( http://wonderfl.net/user/coppieee )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tDXR
 */

//Matrixの練習がてらに。
//なんかもっとシェイクしたい。
package 
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.ColorTransform;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import net.hires.debug.Stats;
	
	public class Main extends Sprite 
	{
		private static const CANVAS_WIDTH:Number = 200;
		private static const CANVAS_HEIGHT:Number = 200;
		private static const PARTICLE_COUNT:int = 30000;
		private var _canvas:BitmapData;
		private var _canvasBitmap:Bitmap;
		private var _canvasContainer:Sprite;
		private var _particles:Vector.<Particle>;
		private var _oldMatrix:Matrix;
		
		public function Main():void 
		{
			_canvas = new BitmapData(CANVAS_WIDTH, CANVAS_HEIGHT, false, 0x000000);
			_canvasBitmap = new Bitmap(_canvas);
			_canvasBitmap.x = -_canvasBitmap.width / 2;
			_canvasBitmap.y = -_canvasBitmap.height / 2;
			_canvasContainer = new Sprite();
			_canvasContainer.x = -_canvasBitmap.x;
			_canvasContainer.y = -_canvasBitmap.y;
			_canvasContainer.addChild(_canvasBitmap);
			addChild(_canvasContainer);
			
			_particles = new Vector.<Particle>();
			for (var i:int = 0; i < PARTICLE_COUNT; i++ )
			{
				_particles.push(new Particle(Math.random() * _canvas.width, Math.random() * _canvas.height));
			}
			
			_oldMatrix = _canvasBitmap.transform.matrix.clone();
			_oldMatrix.concat(_canvasContainer.transform.matrix);
			
			addEventListener(Event.ENTER_FRAME, update);
			
			addChild(new Stats());
		}
		
		private function update(e:Event):void
		{
			_canvasContainer.x += -(_canvasContainer.x - stage.mouseX) * 0.5;
			_canvasContainer.y += -(_canvasContainer.y - stage.mouseY) * 0.5;
			_canvasContainer.rotation += -(_canvasContainer.x - stage.mouseX);
			
			//マトリックスとベクトルを使いこなせ！
			var newMatrix:Matrix = _canvasBitmap.transform.matrix.clone();
			newMatrix.concat(_canvasContainer.transform.matrix);
			var trans:Matrix = _oldMatrix.clone();
			var newMatrixInvert:Matrix = newMatrix.clone();
			newMatrixInvert.invert();
			trans.concat(newMatrixInvert);
			_oldMatrix = newMatrix;
			
			_canvas.lock();
			_canvas.colorTransform(_canvas.rect, new ColorTransform (0.8, 0.8, 0.9));
			var point:Point = new Point();
			for each(var p:Particle in _particles)
			{
				var oldX:Number = p.x;
				var oldY:Number = p.y;
				point.x = p.x;
				point.y = p.y;
				//オブジェクトの生成が一番のボトルネック
				point = trans.transformPoint(point);
				p.x = point.x;
				p.y = point.y;
				
				var speed:Number = Math.sqrt(p.vx * p.vx + p.vy * p.vy);
				point.x = p.vx;
				point.y = p.vy;
				//ここもボトルネック
				point = trans.deltaTransformPoint(point);
				p.vx = point.x *(0.9 +Math.random()/10);
				p.vy = point.y*(0.9 + Math.random()/10);
				p.x += p.vx;
				p.y += p.vy;
				
				if (p.x < 0 || p.x >= _canvas.width || p.y <0 || p.y >= _canvas.height)
				{
					p.vx += (oldX -p.x);
					p.vy += (oldY -p.y);
					if (p.x < 0 && p.vx > 0)
					{
						p.vx +=3;
						p.x = 0;
					}
					if (p.x >= _canvas.width && p.vx < 0)
					{
						p.vx -=3;
						p.x = _canvas.width -1;
					}
					if (p.y < 0)
					{
						p.vy +=3;
						p.y = 0;
					}
					if (p.y >= _canvas.height)
					{
						p.vy -=3;
						p.y = _canvas.height -1;
					}
				}
				
				_canvas.setPixel(p.x, p.y, 0xFFFFFFF);
			}
			_canvas.unlock();
		}
	}
}
class Particle
{
	public var x:Number;
	public var y:Number;
	public var vx:Number = 0;
	public var vy:Number = 0;
	public function Particle(x:Number,y:Number)
	{
		this.x = x;
		this.y = y;
	}
}