/**
 * Copyright s8t1h12akj ( http://wonderfl.net/user/s8t1h12akj )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tC4x
 */

// forked from Leewelo's Analog clock (rotating hands)
// forked from Leewelo's Analog clock (transparent frame for dark backgrounds)
// forked from Leewelo's clock trial
//removing shadows due to pinbox (mini pc media player) seemingly not supporting them
//switching from drawing lines to rotating rectangles for the same reason
package {
    import flash.text.*;
    import flash.geom.Rectangle
    import flash.display.Shape;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.display.MovieClip;
    import flash.events.Event;
    import flash.filters.DropShadowFilter;
    [SWF(frameRate="1")]
    public class Aclock extends Sprite {
        private var square:Number = 500 //canvas size
        private var r:Number = square/2*0.8;
        private var cx:int = int(square/2);
        private var cy:Number = int(square/2);
        private var txth:Number = 34;
        private var fontsize:Number = 30;
        private var canvas:MovieClip = new MovieClip();
        private var fg:MovieClip = new MovieClip();
        private var dayNames:Array = new Array("AKIJII");
        private var TB1:TextField = new TextField();
        private var TB2:TextField = new TextField();
        private var TB3:TextField = new TextField();
        private var rr:MovieClip = new MovieClip();          
        private var perimeter:Shape = new Shape;
                                 
        //alternate rotating hands for trial & filled area issues on old systems
        private var hourHand:Shape = new Shape;
        private var minHand:Shape = new Shape;
        private var secHand:Shape = new Shape;                             
        private var CenterDisc:Shape = new Shape;    
        private var CenterDisc2:Shape = new Shape;    
                                 
                                 
        public function Aclock() {
            //black canvas for trials
            //graphics.beginFill(0x000000,1);
            //graphics.lineStyle(1, 0x000000);
            //graphics.drawRect(0, 0,square,square);
            //graphics.endFill();

            //graphics.beginFill(0xFFFFFF,0);
            //graphics.lineStyle(1, 0xFFFFFF);
            //graphics.drawCircle(cx,cy,r);
            //graphics.endFill();

            
            rr.filters = [new DropShadowFilter()];   // droping shadow to enable visibility on white/transparent bg
            rr.graphics.beginFill(0xFFFFFF,0);
            rr.graphics.lineStyle(2, 0xFFFFFF);
            rr.graphics.drawRoundRect(square*1/5-2, (square-txth)/2+2,fontsize*3+4, txth, txth*4/5, txth-1);
            rr.graphics.endFill();
            rr.graphics.beginFill(0xFFFFFF,0);
            rr.graphics.lineStyle(2, 0xFFFFFF);
            rr.graphics.drawRoundRect(square*0.65-2, (square-txth)/2+2,fontsize*2+4, txth, txth*4/5, txth-1);
            rr.graphics.endFill();
            addChild(rr);
            
            var TxtFormat:TextFormat = new TextFormat('Arial');
            TxtFormat.size = fontsize;
            TxtFormat.bold=true;
            TxtFormat.align = TextFormatAlign.CENTER;
            
            
            TB1.filters = [new DropShadowFilter()];// droping shadow to enable visibility on white/transparent bg
            TB2.filters = [new DropShadowFilter()];// droping shadow to enable visibility on white/transparent bg
            TB3.filters = [new DropShadowFilter()];// droping shadow to enable visibility on white/transparent bg
            
            TB1.defaultTextFormat = TxtFormat;
            TB1.width = fontsize*3;
            TB1.height = txth;
            TB1.x = square*1/5;
            TB1.y = (square-txth)/2;
            TB1.border = false;
            //TB1.borderColor = 0x000000;
            TB1.background = false;
            TB1.textColor = 0xFFFFFF
            TB1.type = TextFieldType.DYNAMIC;
            TB1.text = "00/00";
            //
            TB2.defaultTextFormat = TxtFormat;
            TB2.width = fontsize*2;
            TB2.height = txth;
            TB2.x = square*0.65;
            TB2.y = (square-txth)/2;
            TB2.border = false;
            //TB2.borderColor = 0x000000;
            TB2.background = false;
            TB2.textColor = 0xFFFFFF
            TB2.type = TextFieldType.DYNAMIC;
            TB2.text = "24";
            //
            TB3.defaultTextFormat = TxtFormat;
            TB3.width = square;
            TB3.height = txth;
            TB3.x = 0;
            TB3.y = square*3/4-txth;
            TB3.border = false;
            //TB3.borderColor = 0x000000;
            TB3.background = false;
            TB3.textColor = 0xFFFFFF
            TB3.type = TextFieldType.DYNAMIC;
            TB3.text = "AKIJII";
            addChild(TB1);
            addChild(TB2);
            addChild(TB3);
            
            
            hourHand.filters = [new DropShadowFilter()];// droping shadow to enable visibility on white/transparent bg
            minHand.filters = [new DropShadowFilter()];// droping shadow to enable visibility on white/transparent bg
            secHand.filters = [new DropShadowFilter()];// droping shadow to enable visibility on white/transparent bg
            CenterDisc.filters = [new DropShadowFilter()];// droping shadow to enable visibility on white/transparent bg
            hourHand.x=cx;
            hourHand.y=cy;
            minHand.x=cx;
            minHand.y=cy;
            secHand.x=cx;
            secHand.y=cy;
            hourHand.graphics.beginFill(0xFFFFFF);
            hourHand.graphics.lineStyle(0,0x000000);
            hourHand.graphics.drawRoundRect(-5, -5, 10, r*0.65,8,8);
            hourHand.graphics.endFill();
            minHand.graphics.beginFill(0xFFFFFF);
            minHand.graphics.lineStyle(0,0x000000);
            minHand.graphics.drawRoundRect(-4, -4, 8, r*0.85,6,6);
            minHand.graphics.endFill();
            secHand.graphics.beginFill(0xFF0000);
            secHand.graphics.drawRoundRect(-1, -1, 2, r*0.9,4,4);
            secHand.graphics.drawRoundRect(-2, -2, 4, -r*0.1, 2,2);
            secHand.graphics.endFill();
            CenterDisc.graphics.beginFill(0xFFFFFF);
            CenterDisc.graphics.drawCircle(cx, cy, 9);
            CenterDisc.graphics.endFill();
            CenterDisc2.graphics.beginFill(0xFF0000);
            CenterDisc2.graphics.drawCircle(cx, cy, 6);
            CenterDisc2.graphics.endFill();
            addChild(hourHand);
            addChild(minHand);
            addChild(CenterDisc);
            addChild(secHand);
            addChild(CenterDisc2);

            perimeter.filters = [new DropShadowFilter()];
            for (var i:int = 0; i < 12; ++i) {
                var t:Number = i / 6 * Math.PI;
                perimeter.graphics.beginFill(0x000000,0);
                if (i % 3 === 0) {
                    perimeter.graphics.lineStyle(3,0xFFFFFF),
                    perimeter.graphics.drawCircle(cx + r*Math.cos(t), cy + r*Math.sin(t), 8);
                }
                else {
                    perimeter.graphics.lineStyle(2,0xFFFFFF),
                    perimeter.graphics.drawCircle(cx + r*Math.cos(t), cy + r*Math.sin(t), 5);
                }
                perimeter.graphics.endFill();
            }
            addChild(perimeter);
            //fg.filters = [new DropShadowFilter()];
            //addChild(fg);
            addEventListener(Event.ENTER_FRAME, repaint);
        }

        private function repaint(e:Event):void {
            var d:Date = new Date();
            var sd:String =  (d.date<=9?"0":"") + d.date + "/" + (d.month<9?"0":"") + (d.month+1);
            var AMPM:String = d.hours<12?"AM":"PM";
            var h:Number = (d.hours + d.minutes/60-3) / 6 * Math.PI;
            var m:Number = (d.minutes + d.seconds/60-15) / 30 * Math.PI;
            var s:Number = (d.seconds-15) / 30 * Math.PI;

            if (TB1.text!=sd) {TB1.text = sd;}
            if (TB2.text!=AMPM) {TB2.text = AMPM;}
            if (TB3.text!=dayNames[d.getDay()]) {TB3.text = dayNames[d.getDay()];}
            //fg.graphics.clear();
            hourHand.rotation = 180 + (d.hours * 360 / 12) + (d.minutes * 360 / 12 / 60);
            minHand.rotation = 180 + (d.minutes * 360 / 60) + (d.seconds * 360 / 60 / 60);
            secHand.rotation = 180 + (d.seconds * 360 / 60);
            //for each (var o:Object in [{w:8, c:0xFFFFFF, x:(r*0.6)*Math.cos(h), y:(r*0.6)*Math.sin(h)},
            //                           {w:6, c:0xFFFFFF, x:(r*0.8)*Math.cos(m), y:(r*0.8)*Math.sin(m)},
            //                           {w:2, c:0xFF0000, x:(r*0.9)*Math.cos(s), y:(r*0.9)*Math.sin(s)},
            //                           {w:4, c:0xFF0000, x:-(r*0.1)*Math.cos(s), y:-(r*0.1)*Math.sin(s)}]) {
            //    fg.graphics.lineStyle(o.w, o.c);
            //    fg.graphics.moveTo(cx, cy);
            //    fg.graphics.lineTo(cx + o.x, cy + o.y);
            //    fg.graphics.beginFill(o.c,1);
            //    fg.graphics.drawCircle(cx, cy, int(3 + o.w / 4));
            //    fg.graphics.endFill();
            //}
        }
    }
}