/**
 * Copyright FTMSuperfly ( http://wonderfl.net/user/FTMSuperfly )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tBV5
 */

// forked from tenasaku's 電気仕掛けのアラベスク (第1番)
/*	------------------------------------------------------------------------
	2010年4月5日
	適当に作ったら思いのほか綺麗だったのでポストします.  
	LineScaleMode.NONE のおかげで CPU の負担がかなり減りました (^^)
	それでもまだ少々重いですね.  一分経過するころから特に...
	------------------------------------------------------------------------
	理屈では, 将来のある時点ですべての動点が再び(ほぼ)一箇所に集まるのですが, 
	まあ, いつのことやら.
	------------------------------------------------------------------------
*/

package {

	import flash.display.*;
	import flash.events.*;

	public class Main extends Sprite {

		private var r:Ring;

		private function drawHorizon():void {
			this.graphics.clear();
			this.graphics.beginFill(0x000000);
			this.graphics.drawRect(0,0,stage.stageWidth,stage.stageHeight);
			this.graphics.endFill();
		}

		private function atEveryFrame(e:Event):void {
			r.move();
		}

		private function onResize(e:Event):void {
			stage.removeEventListener(Event.ENTER_FRAME,atEveryFrame);
			drawHorizon();
			r.restart();
			stage.addEventListener(Event.ENTER_FRAME,atEveryFrame);
		}

		private function initialize(e:Event):void {
			this.removeEventListener(Event.ADDED_TO_STAGE, initialize);
			stage.align = StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			drawHorizon();
			r = new Ring();
			this.addChild(r);
			r.restart();
			stage.frameRate = 24;
			stage.addEventListener(Event.ENTER_FRAME, atEveryFrame);
			stage.addEventListener(Event.RESIZE, onResize);
		}
		public function Main():void {
			if ( stage != null ) {
				initialize(null);
			} else {
				this.addEventListener(Event.ADDED_TO_STAGE, initialize);
			}
		}

	} // end of class Main
} // end of package

import flash.display.*;

// Bulletオブジェクトを数珠つなぎにしたもの
class Ring extends Sprite {
	private static const NUM_BEADS:int = 1000;
	private var bead:Array;
	private var thread:Array;
	public function restart():void {
		var i:int;
		for ( i = 0 ; i < bead.length ; ++i ) {
			bead[i].restart(i/NUM_BEADS*Math.PI*2);
			thread[i].connect(bead[i],bead[(i+1)%NUM_BEADS]);
		}
	}
	public function move():void {
		var i:int;
		for ( i = 0 ; i < thread.length ; ++i ) {
			bead[i].move();
		}
		for ( i = 0 ; i < thread.length ; ++i ) {
			thread[i].connect(bead[i],bead[(i+1)%NUM_BEADS]);
		}
	}
	public function Ring() {
		bead = new Array;
		thread = new Array;
		while ( thread.length < NUM_BEADS ) {
			thread.push(new Edge());
			bead.push(new Bullet());
		}
		var a:Edge;
		for each (a in thread) {
			this.addChild(a);
		}
		var b:Bullet;
		for each (b in bead) {
			this.addChild(b);
		}
	}
}

// ふたつのBulletオブジェクトをつなぐ糸
class Edge extends Shape {
	private static const SIZE:Number = 2;
	public function connect(b0:Bullet,b1:Bullet):void {
		this.x = b0.x;
		this.y = b0.y;
		this.scaleX = (b1.x-b0.x)/SIZE;
		this.scaleY = (b1.y-b0.y)/SIZE;
	}
	public function Edge() {
		this.graphics.clear();
		this.graphics.lineStyle(1.41,0x495CAF,1.0,false,LineScaleMode.NONE);
		this.graphics.moveTo(0,0);
		this.graphics.lineTo(SIZE,SIZE);
	}
}

// 自律運動する小さなマル
class Bullet extends Shape {
  public static const RADIUS:Number = 2;
  public static const MASS:Number = 1.0;
  private var qX:Number,qY:Number;
  private var vX:Number,vY:Number;
  public function locate():void {
    this.x = qX;
    this.y = qY;
  }
  public function restart(theta:Number):void {
    qX = stage.stageWidth/2;
    qY = stage.stageHeight/2;
    vX = 4.0*Math.cos(theta);
    vY = 4.0*Math.sin(theta);
    
    locate();
  }
  public function move():void {
    if ( qX <= RADIUS ) {
      qX = RADIUS*2 - qX;
      vX = Math.abs(vX);
    }
    if ( qY <= RADIUS ) {
      qY = RADIUS*2 - qY;
      vY = Math.abs(vY);
    }
    if ( stage.stageWidth - qX <= RADIUS ) {
      qX = (stage.stageWidth - RADIUS)*2 - qX;
      vX = -Math.abs(vX);
    }
    if ( stage.stageHeight - qY <= RADIUS ) {
      qY = (stage.stageHeight - RADIUS)*2 - qY;
      vY = -Math.abs(vY);
    }
    qX += vX/stage.frameRate*30;
    qY += vY/stage.frameRate*30;
    this.locate();
  }
  public function Bullet() {
    this.graphics.clear();
    this.graphics.beginFill(0x0066ff);
    this.graphics.drawCircle(0,0,RADIUS);
    this.graphics.endFill();
    qX = 0;
    qY = 0;
    vX = 0;
    vY = 0;
  }
}
