/**
 * Copyright Tamanegi_kenshi ( http://wonderfl.net/user/Tamanegi_kenshi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tBQF
 */

/*
Flash cs5で以下のasファイルを作ったのですが、
flaファイルにimportして動作させようとすると、出力で

NFO: DisplayObject3D: ParticleField0 
TypeError: Error #1009: null のオブジェクト参照のプロパティまたはメソッドにアクセスすることはできません。
    at test3D/init()
    at test3D()
    at test3D::as/frame1()
    
という表示がされて動きませんでした。

wnderflに同じコードをコピベしたら動きました。

stage.addEventListener〜の部分がおかしいいと思うのですが、解決できませんでした。

初歩的な質問で申し訳ありません。
ご存知の方がいらっしゃいましたら、よろしくお願いします。

動作環境はmac10.6.4, Flash cs5(体験版)です。


*/
package  {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.view.Viewport3D;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.materials.BitmapFileMaterial;
    import org.papervision3d.objects.special.ParticleField;
    import org.papervision3d.materials.special.ParticleMaterial;
    
    
    public class test3D extends Sprite{
        
        private var camera:Camera3D;
        private var view:Viewport3D;
        private var scene:Scene3D;
        private var renderer:BasicRenderEngine;
        
        //private var plane:Plane;
        private var cube:Cube;
        
        private var rot:Number = 0;
        
        private var isMouseDown:Boolean = false;
        
        private var oldX:Number = 0;
        private var targetRot:Number = 0; 

        public function test3D() {
            init();
        }//test3D
        
        
        private function init():void{
            camera = new Camera3D();
            view = new Viewport3D(465, 465);
            scene = new Scene3D();
            renderer = new BasicRenderEngine();
            
            addChild(view);
            
            /*var material:ColorMaterial = new ColorMaterial(0x333333);
            material.doubleSided = true;
            plane = new Plane(material, 150, 150);
            scene.addChild(plane);*/
            var materials:MaterialsList = new MaterialsList({
                                                            front:      new BitmapFileMaterial("images/01.jpg", true),
                                                            back:      new BitmapFileMaterial("images/02.jpg", true),
                                                            right:       new BitmapFileMaterial("images/03.jpg", true),
                                                            left:         new BitmapFileMaterial("images/04.jpg", true),
                                                            top:         new BitmapFileMaterial("images/05.jpg", true),
                                                            bottom: new BitmapFileMaterial("images/06.jpg", true)
                                                            });
            cube = new Cube(materials, 500, 500, 500);
            scene.addChild(cube);
            
            var particleMat:ParticleMaterial = new ParticleMaterial(0x666666, 1);
            var particles:ParticleField = new ParticleField(particleMat, 1000, 4, 2000, 2000, 2000);
            scene.addChild(particles);
            
            
            //ここを付け加えたら動作しなくなりました。
            stage.addEventListener(MouseEvent.MOUSE_DOWN, downHandler);
            stage.addEventListener(MouseEvent.MOUSE_UP, upHandler);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, moveHandler);
            
            addEventListener(Event.ENTER_FRAME, loop);

        }
        private function downHandler(e:MouseEvent):void{
            isMouseDown = true;
            oldX = mouseX;
        }
        private function upHandler(e:MouseEvent):void{
            isMouseDown = false;
        }
        private function moveHandler(e:MouseEvent):void{
            if(isMouseDown){
                var dy:Number = e.stageX - oldX;
                targetRot += dy * 0.25;
                oldX = e.stageX;
            }
        }
        
        private function loop(e:Event):void{

            //var targetRo:Number = (mouseX /stage.stageWidth) * 360;
            //rot += (targetRo - rot) * 0.02;
            rot += (targetRot - rot) * 0.02;
            
            camera.x = 1000 * Math.sin(rot * Math.PI / 180);
            camera.z = 1000 * Math.cos(rot *Math.PI / 180);
            
            var tx:Number = (0 - camera.x);
            var tz:Number = (0 - camera.z);
            var ang:Number = Math.atan2(tx, tz);
            camera.rotationY = ang * 180 / Math.PI;
            
            renderer.renderScene(scene, camera, view);
        }

    }//class
    
}//package
