/**
 * Copyright chiqui ( http://wonderfl.net/user/chiqui )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tAvb
 */

package 
{
    import com.greensock.TweenMax;
    import flash.display.Bitmap;

    import flash.display.BitmapData;
    import flash.display.CapsStyle;
    import flash.display.Sprite;

    import flash.events.Event;
    import flash.filters.DropShadowFilter;

    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Point;
    
    public class Main extends Sprite 

    {
        
        private var holder:Sprite;
        private var iteration:int;
        private var holds:Vector.<Sprite>;
        private var bmp:Bitmap;
        

        public function Main():void {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        

        private function init(e:Event = null):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            holds = new Vector.<Sprite>();
            holder = new Sprite();

            this.addChild(holder);
            holder.x = this.stage.stageWidth / 2;
            holder.y = this.stage.stageHeight / 2;

            // entry point
            iteration = 1;
            lines(50, 2, 10, 0);

            this.addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(e:Event):void {
            for (var i:int = 0; i < holds.length; i++) {
                holds[i].rotation += .05 * i;
                holds[i].scaleX = holds[i].scaleY = Math.cos((holds[i].rotation/100));
                for (var j:int = 0; j < 50; j++) {
                    holds[i].getChildAt(j).scaleX = holds[i].getChildAt(j).scaleX = Math.sin((holds[i].rotation)/100);
                }
            }
        }
        
        private function lines(cant:int, len:int, offs:int, delt:Number):void {
            var setA:Array = getPointsAroundCircumference(0, 0, offs, cant);
            var setB:Array = getPointsAroundCircumference(0, 0, offs + len, cant);

            var hold:Sprite = new Sprite();
            for (var i:int = 0; i < setA.length; i++) {
                var sp:Sprite = new Sprite();
                hold.addChild(sp);
                sp.graphics.lineStyle(3, blend(0xFFF93E, 0xFF3D74, iteration/10), (iteration/5)+.5,false,"normal", CapsStyle.ROUND);
                sp.graphics.moveTo(setA[i].x, setA[i].y);
                sp.graphics.lineTo(setB[i].x, setB[i].y);
                var del:Number = delt + i * .08;
                TweenMax.from(sp, .4, { scaleX:0, scaleY:0, delay:del});
            }
            holder.addChild(hold);
            hold.filters = [new DropShadowFilter(1, 45, 0, 1, 4, 4, 5)];
            holds.push(hold);
            iteration++;
            if (iteration < 20) {
                lines(cant, len + Math.random() * 3, offs + len + 3 + Math.random() * 2, del * .98);
            }
        }
        
        public static function getPointsAroundCircumference(centerx:Number, centery:Number, circleradius:Number, totalpoints:int, startangle:Number = 0): Array{
            var arc:Number = 360;
            var mpi : Number = Math.PI / 180;
            var startRadians : Number = startangle * mpi;
            var incrementAngle : Number = arc / totalpoints;
            var incrementRadians : Number = incrementAngle * mpi;
            var pts : Array = [];
            while(totalpoints--){
                var xp : Number = centerx + Math.sin(startRadians) * circleradius;
                var yp : Number = centery + Math.cos(startRadians) * circleradius;
                var pt : Object = new Object();
                pt.x = xp;
                pt.y = yp;
                pt.angle = startRadians;
                pts.push(pt);
                startRadians -= incrementRadians;
            }
            return pts;
        }
        public static function blend(first:uint, second:uint, percent:Number):uint {
            var r:int = ((first & 0xff0000) >> 16) * (1 - percent) + ((second & 0xff0000) >> 16) * percent;
            var g:int = ((first & 0x00ff00) >>  8) * (1 - percent) + ((second & 0x00ff00) >>  8) * percent;
            var b:int = ((first & 0x0000ff)      ) * (1 - percent) + ((second & 0x0000ff)      ) * percent;
            return r << 16 | g << 8 | b;
        }
    }
}