/**
 * Copyright shaktool ( http://wonderfl.net/user/shaktool )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tAva
 */

package {
	import flash.display.Sprite;
	import flash.events.*;
	import flash.geom.*;
	import flash.events.KeyboardEvent;
	import flash.ui.Keyboard;
	public class FlashTest extends Sprite {
		
		private const historyLength: int = 20;
		private var leftHeld: Array  = [false, false];
		private var rightHeld: Array = [false, false];
		private var upHeld: Array    = [false, false];
		private var downHeld: Array  = [false, false];
		private var localPos: Array       = [new Point(), new Point()];
		private var localVel: Array       = [new Point(), new Point()];
		private var localRes: Array       = [false, false];
		private var remotePos: Array  = [new Point(), new Point()];
		private var remoteVel: Array  = [new Point(), new Point()];
		private var receivedPos: Array  = [new Point(), new Point()];
		private var receivedVel: Array  = [new Point(), new Point()];
		private var receivedRes: Array  = [0.0, 0.0];
		private var interpolatedPos: Array  = [new Point(), new Point()];
		private var interpolatedVel: Array  = [new Point(), new Point()];
		private var oldPos: Array = [[], []];
		private var oldVel: Array = [[], []];
		private var oldRes: Array = [[], []];
		private var timer: int = 0;
		
		
		public function FlashTest() {
			for (var i: int = 0; i < historyLength * 2; i++) {
				oldPos[0].push(new Point());
				oldPos[1].push(new Point());
				oldVel[0].push(new Point());
				oldVel[1].push(new Point());
				oldRes[0].push(0.0);
				oldRes[1].push(0.0);
			}
			
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
			stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyPressed);
			stage.addEventListener(KeyboardEvent.KEY_UP, onKeyReleased);
		}
		
		private function onKeyPressed(event: KeyboardEvent): void {
			switch (event.keyCode) {
				case Keyboard.LEFT :
					leftHeld[0] = true;
					break;
				case Keyboard.RIGHT :
					rightHeld[0] = true;
					break;
				case Keyboard.UP :
					upHeld[0] = true;
					break;
				case Keyboard.DOWN :
					downHeld[0] = true;
					break;
				case Keyboard.A :
					leftHeld[1] = true;
					break;
				case Keyboard.S :
					downHeld[1] = true;
					break;
				case Keyboard.D :
					rightHeld[1] = true;
					break;
				case Keyboard.W :
					upHeld[1] = true;
					break;
			}
		}
		
		private function onKeyReleased(event: KeyboardEvent): void {
			switch (event.keyCode) {
				case Keyboard.LEFT :
					leftHeld[0] = false;
					break;
				case Keyboard.RIGHT :
					rightHeld[0] = false;
					break;
				case Keyboard.UP :
					upHeld[0] = false;
					break;
				case Keyboard.DOWN :
					downHeld[0] = false;
					break;
				case Keyboard.A :
					leftHeld[1] = false;
					break;
				case Keyboard.S :
					downHeld[1] = false;
					break;
				case Keyboard.D :
					rightHeld[1] = false;
					break;
				case Keyboard.W :
					upHeld[1] = false;
					break;
			}
		}
		
		private function onEnterFrame(event: Event): void {
			var dt: Number = 1.0 / 30.0;
			
			graphics.clear();
			
			for (var i: int = 0; i < 2; i++) {
				if (timer == 0) {
					receivedPos[i] = oldPos[1-i][historyLength];
					receivedVel[i] = oldVel[1-i][historyLength];
					receivedRes[i] = oldRes[1-i][historyLength];
					receivedRes[i] -= historyLength / 50.0;
					var leadRatio: Number = Math.min(1.0, localRes[i]) * 0.5 + Math.max(0.0, 1.0 - receivedRes[i]) * 0.5;
					receivedPos[i].x += (receivedVel[i].x * (1.0 - leadRatio) + oldVel[i][0].x * leadRatio) * dt * historyLength;
					receivedPos[i].y += (receivedVel[i].y * (1.0 - leadRatio) + oldVel[i][0].y * leadRatio) * dt * historyLength;
					//receivedPos[i].x += (receivedVel[i].x + oldVel[i][0].x) * 0.5 * dt * historyLength;
					//receivedPos[i].y += (receivedVel[i].y + oldVel[i][0].y) * 0.5 * dt * historyLength;
					//receivedPos[i].x += receivedVel[i].x * dt * historyLength;
					//receivedPos[i].y += receivedVel[i].y * dt * historyLength;
				}
				
				if (leftHeld[i])  localVel[i].x -= dt * 10.0;
				if (rightHeld[i]) localVel[i].x += dt * 10.0;
				if (upHeld[i])    localVel[i].y -= dt * 10.0;
				if (downHeld[i])  localVel[i].y += dt * 10.0;
				if (leftHeld[i] || rightHeld[i] || upHeld[i] || downHeld[i]) localRes[i] = 2.0;
				localRes[i] -= 1.0/50.0;
				receivedRes[i] -= 1.0/50.0;
				if (localRes[i] < 0.0) localRes[i] = 0.0;
				if (receivedRes[i] < 0.0) receivedRes[i] = 0.0;
				
				if (localVel[i].length > 5.0) localVel[i].normalize(5.0);
				
				var leadRatio: Number = Math.min(1.0, localRes[i]) * 0.5 + Math.max(0.0, 1.0 - receivedRes[i]) * 0.5;
				
				var tempLocalVel: Point = new Point(oldVel[i][historyLength].x, oldVel[i][historyLength].y);
				var tempRemoteVel: Point = new Point(interpolatedVel[i].x, interpolatedVel[i].y);
				localVel[i].x += (tempRemoteVel.x - localVel[i].x) * dt * 2.0 * (1.0 - leadRatio);
				localVel[i].y += (tempRemoteVel.y - localVel[i].y) * dt * 2.0 * (1.0 - leadRatio);
				remoteVel[i].x += (tempLocalVel.x - remoteVel[i].x) * dt * 2.0 * leadRatio;
				remoteVel[i].y += (tempLocalVel.y - remoteVel[i].y) * dt * 2.0 * leadRatio;
				interpolatedVel[i].x += (tempLocalVel.x - interpolatedVel[i].x) * dt * 2.0 * leadRatio;
				interpolatedVel[i].y += (tempLocalVel.y - interpolatedVel[i].y) * dt * 2.0 * leadRatio;
				receivedVel[i].x += (tempLocalVel.x - receivedVel[i].x) * dt * 2.0 * leadRatio;
				receivedVel[i].y += (tempLocalVel.y - receivedVel[i].y) * dt * 2.0 * leadRatio;
				
				localPos[i].x += localVel[i].x * dt;
				localPos[i].y += localVel[i].y * dt;
				remotePos[i].x += remoteVel[i].x * dt;
				remotePos[i].y += remoteVel[i].y * dt;
				
				interpolatedPos[i].x += (interpolatedVel[i].x * (1.0 - leadRatio) + oldVel[i][historyLength].x * leadRatio) * dt;
				interpolatedPos[i].y += (interpolatedVel[i].y * (1.0 - leadRatio) + oldVel[i][historyLength].y * leadRatio) * dt;
				receivedPos[i].x += (receivedVel[i].x * (1.0 - leadRatio) + oldVel[i][historyLength].x * leadRatio) * dt;
				receivedPos[i].y += (receivedVel[i].y * (1.0 - leadRatio) + oldVel[i][historyLength].y * leadRatio) * dt;
				
				interpolatedPos[i].x += (receivedPos[i].x - interpolatedPos[i].x) * dt * 3.0;
				interpolatedPos[i].y += (receivedPos[i].y - interpolatedPos[i].y) * dt * 3.0;
				interpolatedVel[i].x += (receivedVel[i].x - interpolatedVel[i].x) * dt * 5.0;
				interpolatedVel[i].y += (receivedVel[i].y - interpolatedVel[i].y) * dt * 5.0;
				remotePos[i].x += (interpolatedPos[i].x - remotePos[i].x) * dt * 3.0;
				remotePos[i].y += (interpolatedPos[i].y - remotePos[i].y) * dt * 3.0;
				remoteVel[i].x += (interpolatedVel[i].x - remoteVel[i].x) * dt * 5.0;
				remoteVel[i].y += (interpolatedVel[i].y - remoteVel[i].y) * dt * 5.0;
				
				
				var armLength: Number = 2.0;
				var distance: Point = new Point();
				distance.x = remotePos[i].x - localPos[i].x;
				distance.y = remotePos[i].y - localPos[i].y;
				var length: Number = distance.length;
				var extra: Number = length > armLength ? length - armLength : 0.0;
				if (extra != 0.0) {
					localPos[i].x += distance.x * (extra / length) * (1.0 - leadRatio);
					localPos[i].y += distance.y * (extra / length) * (1.0 - leadRatio);
					remotePos[i].x -= distance.x * (extra / length) * leadRatio;
					remotePos[i].y -= distance.y * (extra / length) * leadRatio;
				}
				
				oldPos[i].push(new Point(localPos[i].x, localPos[i].y));
				oldPos[i].shift();
				oldVel[i].push(new Point(localVel[i].x, localVel[i].y));
				oldVel[i].shift();
				oldRes[i].push(localRes[i]);
				oldRes[i].shift();
				
				//if (i == 0) continue;
				
				graphics.beginFill(0x00, leadRatio);
				graphics.drawCircle(10 + i * 20, 10, 10);
				graphics.endFill();

				graphics.beginFill([0xff0000, 0x00aa00][i]);
				graphics.drawCircle(localPos[i].x * 10.0 + 200.0, localPos[i].y * 10.0 + 200.0, 5.0);
				graphics.endFill();
				graphics.lineStyle(1, [0xff0000, 0x00aa00][i]);
				graphics.moveTo(localPos[i].x * 10.0 + 200.0, localPos[i].y * 10.0 + 200.0);
				graphics.lineTo(localPos[i].x * 10.0 + 200.0 + localVel[i].x * 2.0, localPos[i].y * 10.0 + 200.0 + localVel[i].y * 5.0);
				graphics.lineStyle();
				
				graphics.beginFill([0xff0000, 0x00aa00][1-i]);
				graphics.drawCircle(remotePos[i].x * 10.0 + 200.0, remotePos[i].y * 10.0 + 200.0, 3.0);
				graphics.endFill();
				graphics.lineStyle(1, [0xff0000, 0x00aa00][1-i]);
				graphics.moveTo(remotePos[i].x * 10.0 + 200.0, remotePos[i].y * 10.0 + 200.0);
				graphics.lineTo(remotePos[i].x * 10.0 + 200.0 + remoteVel[i].x * 2.0, remotePos[i].y * 10.0 + 200.0 + remoteVel[i].y * 5.0);
				/*
				graphics.lineStyle();
				graphics.lineStyle(1, [0xff0000, 0x00aa00][1-i]);
				graphics.drawCircle(receivedPos[i].x * 10.0 + 200.0, receivedPos[i].y * 10.0 + 200.0, 4.0);
				graphics.moveTo(receivedPos[i].x * 10.0 + 200.0, receivedPos[i].y * 10.0 + 200.0);
				graphics.lineTo(receivedPos[i].x * 10.0 + 200.0 + receivedVel[i].x * 2.0, receivedPos[i].y * 10.0 + 200.0 + receivedVel[i].y * 5.0);
				graphics.lineStyle();
				*/
			}
			
			if (timer == 0) {
				timer += historyLength;
			}
			timer--;
		}
	}
}
