/**
 * Copyright Yaski_ ( http://wonderfl.net/user/Yaski_ )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tAJO
 */

package {
    import flash.system.LoaderContext;
    import flash.display.Bitmap;
    import flash.net.URLRequest;
    import flash.display.Loader;
    import flash.display.BitmapData;

    import alternativ7.engine3d.containers.DistanceSortContainer;
    import alternativ7.engine3d.containers.LODContainer;
    import alternativ7.engine3d.controllers.SimpleObjectController;
    import alternativ7.engine3d.core.Camera3D;
    import alternativ7.engine3d.core.Debug;
    import alternativ7.engine3d.core.MipMapping;
    import alternativ7.engine3d.core.Object3D;
    import alternativ7.engine3d.core.Object3DContainer;
    import alternativ7.engine3d.core.View;
    import alternativ7.engine3d.loaders.Parser3DS;
    import alternativ7.engine3d.materials.TextureMaterial;
    import alternativ7.engine3d.objects.Mesh;
    import alternativ7.engine3d.primitives.Sphere;
    
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageQuality;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.geom.Matrix3D;
    import flash.ui.Keyboard;

    [SWF (backgroundColor=0, frameRate=30)]
    public class Alternativa3DEarth extends Sprite {

        private var rootContainer:Object3DContainer = new DistanceSortContainer();
        
        private var camera:Camera3D;
        private var controller:SimpleObjectController;
        
        private var material:TextureMaterial;
        
        public function Alternativa3DEarth() {
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            //stage.quality = StageQuality.LOW;
            
            // Создание камеры и вьюпорта
            camera = new Camera3D();
            camera.view = new View(stage.stageWidth, stage.stageHeight);
            addChild(camera.view);
            addChild(camera.diagram);
            
            // Установка начального положения камеры
            camera.rotationX = -130*Math.PI/180;
            camera.y = -400;
            camera.z = 350;
            controller = new SimpleObjectController(stage, camera, 200);
            rootContainer.addChild(camera);
        
            material = new TextureMaterial(new BitmapData(4,4, false, 0x7F7F7F), true, true);
            
            var objects:Vector.<Object3D> = Vector.<Object3D>([new Sphere(100, 300, 150, false, material), new Sphere(100, 100, 50, false, material), new Sphere(100, 50, 25, false, material), new Sphere(100, 26, 13, false, material), new Sphere(100, 20, 10, false, material), new Sphere(100, 14, 7, false, material)]);
            
            // Установка текстуры
            material.mipMapping = MipMapping.PER_PIXEL;
            material.resolution = (objects[0] as Mesh).calculateResolution(material.texture.width, material.texture.height);
            loadTexture();
            // Создание LOD
            var lod:LODContainer = new LODContainer();
            for (var i:int = 0; i < objects.length; i++) {
                var mesh:Mesh = objects[i] as Mesh;
                mesh.matrix = new Matrix3D();
                lod.addChild(mesh);
            }
            lod.calculateBounds();
            
            lod.setChildDistance(lod.getChildAt(0), 110);
            lod.setChildDistance(lod.getChildAt(1), 150);
            lod.setChildDistance(lod.getChildAt(2), 400);
            lod.setChildDistance(lod.getChildAt(3), 700);
            lod.setChildDistance(lod.getChildAt(4), 1200);
            lod.setChildDistance(lod.getChildAt(5), 1000000);
            rootContainer.addChild(lod);
            
            // Режим отладки
            camera.debug = true;
            camera.addToDebug(Debug.EDGES, Object3D);
            
            // Подписка на события
            stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
            stage.addEventListener(Event.RESIZE, onResize);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
        }

        private var loader:Loader;
        
        private function loadTexture():void {
            loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onLoad);
            loader.load(new URLRequest("http://assets.wonderfl.net/images/related_images/1/17/1729/1729b26cc2e27ed55efaee55b59701092e11772d"), new LoaderContext(true));
        }
        
        private function onLoad(e:Event):void {
            material.texture = Bitmap(loader.content).bitmapData;
            loader = null;
        }
 
        private function onEnterFrame(e:Event):void {
            controller.update();
            camera.render();
        }
        
        private function onResize(e:Event = null):void {
            camera.view.width = stage.stageWidth;
            camera.view.height = stage.stageHeight;
        }
        
        private function onKeyDown(e:KeyboardEvent):void {
            if (e.keyCode == Keyboard.TAB) {
                camera.debug = !camera.debug;
            }
            if (e.keyCode == 81) { // Q
                if (stage.quality == "HIGH") {
                    stage.quality = "LOW";
                } else {
                    stage.quality = "HIGH";
                }
            }
        }
    }
}
