/**
 * Copyright IStillLikeFlash ( http://wonderfl.net/user/IStillLikeFlash )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/t9yG
 */

package {
    import flash.display.StageScaleMode;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.TimerEvent;
    import flash.filters.BlurFilter;
    import flash.filters.GlowFilter;
    import flash.geom.Point;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.utils.Timer;

    [SWF(width="270", height="90", backgroundColor="0x00000000", frameRate="24")]
    public class DotClock extends Sprite
    {
        private static var WIDTH:int = 270;
        private static var HEIGHT:int = 90;
        private static const MAX_DOTS:int = 256 * 16;
        private static const ZERO_POINT:Point = new Point(0, 0);
        
        private var bitmapData:BitmapData;
        private var bitmap:Bitmap;
        
        private var blur:BlurFilter;
        private var glow:GlowFilter;
        
        private var textBitmapData:BitmapData;
        private var textPos:Point;
        
        private var xPos:int = 0;
        private var yPos:int = 0;
        
        private var dots:Array;
        private var text:TextField;
        
        private var timer:Timer = new Timer(1000);
        
        private var count:int = 0;
        
        public function DotClock()
        {
            this.addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(event:Event):void
        {
            this.removeEventListener(Event.ADDED_TO_STAGE, init);
            
            //this.scaleX = 0.5;
            //this.scaleY = 0.5;
            
            //WIDTH = stage.width;
            //HEIGHT = stage.height;
            
            stage.scaleMode = StageScaleMode.NO_SCALE;
            blur = new BlurFilter(2, 2, 1);
            glow = new GlowFilter(0xff0000, 1, 16, 16, 3);
            
            //var backgroundBD:BitmapData = new BitmapData(WIDTH, HEIGHT, false, 0x000000);
            //var background:Bitmap = new Bitmap(backgroundBD);
            //backgroundBD.fillRect(backgroundBD.rect, 0x000000);
            //addChild(background);
            
            bitmapData = new BitmapData(WIDTH, HEIGHT, true, 0x00000000);
            bitmap = new Bitmap(bitmapData);
            
            addChild(bitmap);
            
            dots = [];
            for (var i:int = 0; i < MAX_DOTS; i++)
            {
                var dot:Object = {x:Math.random() * WIDTH, y:Math.random() * HEIGHT, color:0xffff0000, dx:0, dy:0.5 + Math.random() * 3};
                dots.push(dot);
            }
            
            text = new TextField();
            text.x = 10;
            text.y = 3;
            
            var format:TextFormat = new TextFormat();
            //format.font = "Verdana";
            format.color = 0xFFFFFF;
            format.size = 70;
            
            text.width = WIDTH;
            text.height = HEIGHT;
            text.defaultTextFormat = format;
            text.setTextFormat(format);
            text.background = false;
            //text.alpha = 0;

            //addChild(text);
            
            textPos = new Point(text.x, text.y);
            
            this.addEventListener(Event.ENTER_FRAME, firstTime);
            timer.addEventListener(TimerEvent.TIMER, timerHandler);
            timer.start();
        }
        
        private function timerHandler(event:TimerEvent):void
        {
            count++;
            
            var currentTime:Date = new Date();     
            var minutes:Number = currentTime.getMinutes();
            var seconds:Number = currentTime.getSeconds();
            var hours:Number = currentTime.getHours();
            
            text.text = "";
            if (hours < 10)
            {
                text.appendText("0");
                text.appendText(hours.toString());
            }
            else
            {
                text.appendText(hours.toString());
            }
            
            text.appendText(":");
            if (minutes < 10)
            {
                text.appendText("0");
                text.appendText(minutes.toString());
            }
            else
            {
                text.appendText(minutes.toString());
            }
            text.appendText(":");
            if (seconds < 10)
            {
                text.appendText("0");
                text.appendText(seconds.toString());
            }
            else
            {
                text.appendText(seconds.toString());
            }
            textBitmapData.fillRect(textBitmapData.rect, 0x00000000);
            textBitmapData.draw(text);
        }
        
        private function firstTime(event:Event):void
        {
            this.removeEventListener(Event.ENTER_FRAME, firstTime);
            textBitmapData = new BitmapData(500, text.height, true, 0x00000000);
            textBitmapData.draw(text);
            
            this.addEventListener(Event.ENTER_FRAME, enterFrameHandler);
        }
        
        private function enterFrameHandler(event:Event):void
        {    
            bitmapData.lock();
            //bitmapData.applyFilter(bitmapData, bitmapData.rect, ZERO_POINT, glow);
            bitmapData.fillRect(bitmapData.rect, 0x00000000);
            
            var mousePoint:Point = new Point(stage.mouseX, stage.mouseY);
            var dotPoint:Point = new Point(0, 0);
            for each (var dot:Object in dots)
            {
                dotPoint.x = dot.x;
                dotPoint.y = dot.y;
                
                dot.y += dot.dy;
                if (Math.random() < 0.006)
                    dot.color = 0xFFFFFFFF;
                else
                    dot.color = 0x66FF0000;
                
                if (textBitmapData.hitTest(textPos, 1, dotPoint))
                {
                    dot.color = 0xFFFF0000;
                    //bitmapData.setPixel32(dot.x, dot.y, 0xFF0000FF);
                    //dot.y += 0.7;
                    bitmapData.setPixel32(dot.x-0.5, dot.y, dot.color);
                    bitmapData.setPixel32(dot.x, dot.y, dot.color);
                    bitmapData.setPixel32(dot.x+0.5, dot.y, dot.color);
                    bitmapData.setPixel32(dot.x, dot.y-0.5, dot.color);
                    //bitmapData.setPixel32(dot.x, dot.y, dot.color);
                    bitmapData.setPixel32(dot.x, dot.y+0.5, dot.color);
                }
                else
                {
                    bitmapData.setPixel32(dot.x, dot.y, dot.color);
                }
                        
                //bitmapData.setPixel32(dot.x, dot.y, dot.color);

                
                
                if (dot.y < 0 || dot.y > HEIGHT)
                {
                    dot.y = 0;
                    dot.x = Math.random() * WIDTH;
                    dot.dy = Math.random() * 3;
                }
            }
            bitmapData.applyFilter(bitmapData, bitmapData.rect, ZERO_POINT, glow);
            //bitmapData.applyFilter(bitmapData, bitmapData.rect, ZERO_POINT, blur);
            bitmapData.unlock();
        }
        
        private function distance(point1:Point, point2:Point):Number
        {
            var dx:Number = point2.x - point1.x;
            var dy:Number = point2.y - point1.y;
            var distance:Number = Math.sqrt(dx*dx + dy*dy);
            return distance;
        }
    }
}
