/**
 * Copyright monodreamer ( http://wonderfl.net/user/monodreamer )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/t9N8
 */

// forked from civet's Ink and Melody
// forked from Kwoon's ActionPainting
package
{
    import flash.geom.Matrix;
    import net.hires.debug.Stats;
    
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.BlurFilter;
    import flash.filters.DisplacementMapFilter;
    import flash.filters.DisplacementMapFilterMode;
    import flash.geom.Point;
    import flash.geom.Rectangle;

    [SWF(backgroundColor=0xffffff, width=465, height=465, frameRate=60)]
    
    public class Ink extends Sprite
    {
        private function render($e:Event):void
        {
            _canvas.lock();
            var p:Brush;
            var n:int = NUM_OF_BRUSH;
            while(--n>-1) {
                p = _brushes[n];
                p.process();
                _canvas.copyPixels(p, p.rect, p.pos, null, null, true);
                //_canvas.draw(p, new Matrix(1,0,0,1,p.pos.x, p.pos.y), null, 'darken');
            }
            _canvas.scroll(0, -1);
            _canvas.applyFilter(_canvas, _rect, _ep, _blur);
            _canvas.unlock();
        }
        
        private function mouseClick($e:MouseEvent):void
        {
            var n:int = NUM_OF_BRUSH;
            while(--n>-1) {
                _brushes[n].stopFlag = false;
                _brushes[n].tx = $e.stageX;
                _brushes[n].ty = $e.stageY;
            }
        }
        
        //----------------------------------------------------------------
        // Properties
        //----------------------------------------------------------------
        
        //----------------------------------------------------------------
        // Getter/Setter Method
        //----------------------------------------------------------------
        
        //----------------------------------------------------------------
        // Public method
        //----------------------------------------------------------------
        
        //----------------------------------------------------------------
        // Protected Method
        //----------------------------------------------------------------
        
        //----------------------------------------------------------------
        // Constructor
        //----------------------------------------------------------------
        public function Ink()
        {
            _sw = stage.stageWidth;
            _sh = stage.stageHeight;
            
            init();
        }
        
        //----------------------------------------------------------------
        // Private Method
        //----------------------------------------------------------------
        private function init():void
        {
            initBrushes();
            
            _blur = new BlurFilter(4, 4, 1);
            _ep = new Point();
            
            _canvas = new BitmapData(_sw, _sh, true, 0x0);
            _rect = _canvas.rect;
            
            var map:BitmapData = new BitmapData(_sw, _sh);
            map.perlinNoise(84, 84, 5, Math.random()*100, false, true, 1, true);
            
            var bmp:Bitmap = new Bitmap(_canvas);
            bmp.filters = [new DisplacementMapFilter(map, _ep, 1, 1, 64, 64, DisplacementMapFilterMode.CLAMP)];
            addChild(bmp);
            
            addChild(new Stats);
            
            addEventListener(Event.ENTER_FRAME, render);
            stage.addEventListener(MouseEvent.CLICK, mouseClick);
        }
        
        private function initBrushes():void
        {
            _brushes = new Vector.<Brush>(NUM_OF_BRUSH, true);
            var n:int = NUM_OF_BRUSH;
            var p:Brush;
            while(--n>-1) {
                p = _brushes[n] = new Brush(12 + Math.random()*14);
                p.pos.x = int(Math.random()*_sw);
                p.pos.y = int(Math.random()*_sh);
            }
        }
        
        private const NUM_OF_BRUSH:int = 8;
        
        private var _brushes:Vector.<Brush>;
        private var _canvas:BitmapData;
        private var _blur:BlurFilter;
        private var _rect:Rectangle;
        private var _ep:Point;
        private var _sw:int;
        private var _sh:int;
    }
}
import flash.geom.ColorTransform;

import flash.display.BitmapData;
import flash.display.Shape;
import flash.events.Event;
import flash.geom.Point;

class Brush extends BitmapData
{
    public var stopFlag:Boolean;
    public var tx:Number=0;
    public var ty:Number=0;
    public var pos:Point;
    
    public function Brush($radius:Number, $color:uint=0x0)
    {
        super($radius, $radius, true, 0);
        _radius = $radius;
        _color = $color;
        pos = new Point(-$radius, -$radius);
        reset();
    }
    
    public function process():void
    {
        if (stopFlag) {
            if(Math.random()<.1) reset();
        }
        else {
            move();
        }
    }
    
    private function reset():void
    {
        tx += Math.random() * 200;
        ty += Math.random() * 200;
        tx %= 465;
        ty %= 465;
        _easing = 0.02 + Math.random() * 0.03;
        draw(new SBrush(_radius * Math.random() + _radius, _color));
        _ct.alphaMultiplier = Math.random()*.5 + .5;
        colorTransform(rect, _ct);
        stopFlag = false;
    }
    
    private function move():void
    {
        pos.x += _vx = (tx - pos.x) * _easing;
        pos.y += _vy = (ty - pos.y) * _easing;
        stopFlag = _vx*_vy < .1;
    }
    
    private var _radius:Number;
    private var _vx:Number;
    private var _vy:Number;
    private var _easing:Number;
    private var _color:uint;
    private var _ct:ColorTransform = new ColorTransform();
}


class SBrush extends Shape
{
    public function SBrush($radius:Number, $color:uint=0x0)
    {
        graphics.beginFill($color);
        graphics.drawCircle($radius, $radius, $radius);
        graphics.endFill();
    }
}