/**
 * Copyright melfuad ( http://wonderfl.net/user/melfuad )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/t8is
 */

// forked from makc3d's forked from: Nonsense Clocks
// forked from shapevent's Nonsense Clocks
package {

    import flash.display.*;
    import flash.events.*;


    [SWF(width = 465, height=465, backgroundColor=0x000000)]

       public class NonsenseClocks extends MovieClip {
        private var clockNum:int;
        private var clocks:Vector.<Function>;
        private var clockContainer:Sprite;


               public function NonsenseClocks(){
                  // init
            clockNum = 100;
            clocks = new Vector.<Function>(clockNum, true);
            clockContainer = Sprite(addChild(new Sprite()));
            clockContainer.x = stage.stageWidth / 2;
            clockContainer.y = stage.stageHeight / 2;
            buildClocks();
            runClocks();
            

                       
               }
               // private methods

        private function buildClocks():void{
            for (var i:int = 0; i<clockNum; i++){
                var theta:Number = Math.random() * Math.PI * 2;
                var radius:Number = 100 + Math.random() * 100;
                var xp:Number = radius * Math.cos(theta);
                var yp:Number = radius * Math.sin(theta);
                clocks[i] = makeClock(xp,yp,Math.random() * Math.PI * 2);
            }
        }
        private function runClocks():void{
            addEventListener(Event.ENTER_FRAME, onRunClocks);
        }
        private function onRunClocks(evt:Event):void{
            for (var i:int = 0; i<clockNum; i++){
                clocks[i]();
            }
            clockContainer.rotationX = +180 * (mouseY / 465 - 0.5);
            clockContainer.rotationY = -180 * (mouseX / 465 - 0.5);
        }
        private function makeClock(x:Number, y:Number, time:Number = 0):Function {
            var i:int;
            var dt:Number = 0.3 * Math.random ();
            var radius:Number = Math.random() * 10 + 5;
            var border:Number = radius * 0.2;
            var smallRadius:Number = radius - radius * 0.3;
            var clockNode:Sprite = Sprite(clockContainer.addChild(new Sprite()));
            var clock:Sprite = Sprite(clockNode.addChild(new Sprite()));
            clock.x = x;
            clock.y = y;
            clock.z = 100 - Math.random() * 200;
            clockNode.rotationX = Math.random() * 180 - 90;
            clockNode.rotationY = Math.random() * 180 - 90;
            clockNode.rotationZ = Math.random() * 360;

            return function():void{
                with (clock.graphics){
                    clear();
                    for (i = 1; i < radius / 3; i++) {
                        lineStyle(1,0xFFFFFF * dt / 0.3, 1.0 / i);
                        drawCircle(0, 0, radius + i*border);
                    }
                    lineStyle(1,0xFFFFFF);
                    x = smallRadius * Math.cos(time/12);
                    y = smallRadius * Math.sin(time/12);
                    moveTo(0,0);
                    lineTo(x, y);
                    x = radius * Math.cos(time);
                    y = radius * Math.sin(time);
                    moveTo(0,0);
                    lineTo(x, y);
                }
                time += dt;
                clockNode.rotationZ += dt * 2 - 0.3;
            }
        }
        

       }

}