/**
 * Copyright Syukou ( http://wonderfl.net/user/Syukou )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/t8an
 */

package {
    import flash.display.*;
    import flash.events.*;

    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.materials.*;
    import org.papervision3d.objects.*;
    import org.papervision3d.objects.primitives.Cube;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.view.Viewport3D;

    public class PV3D_01 extends Sprite {
        private var camera    :Camera3D;
        private var scene     :Scene3D;
        private var viewport  :Viewport3D;
        private var renderer  :BasicRenderEngine;

        private var cube      :Cube;

        public function PV3D_01() {
            camera   = new Camera3D();
            scene    = new Scene3D();
            viewport = new Viewport3D( stage.stageWidth, stage.stageHeight );
            renderer = new BasicRenderEngine();
            addChild( viewport );

            var materials :MaterialsList = new MaterialsList( { all : new ColorMaterial(0xD7261C) } );
            cube = new Cube( materials );
            scene.addChild( cube );

            addEventListener( Event.ENTER_FRAME, onEnterFrame );
        }

        public function onEnterFrame(e:Event): void {
            cube.rotationX += ( mouseX - stage.stageWidth /2 ) / 200;
            cube.rotationY += ( mouseY - stage.stageHeight/2 ) / 200;

            renderer.renderScene( scene, camera, viewport );
        }
    }
}
