/**
 * Copyright civet ( http://wonderfl.net/user/civet )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/t8aI
 */

// 2011-07-21 19:53:45
package
{
    import flash.display.*;
    import flash.events.*;
    
    [SWF(width="465", height="465", frameRate="60")]
    
    public class PointInPolygon extends Sprite
    {
        private var star:Star;
        
        public function PointInPolygon()
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            
            init();
        }
        
        private function init():void
        {
            var pattern:Shape = new Shape();
            pattern.graphics.beginFill(0xffffff);
            pattern.graphics.drawRect(0, 0, 8, 8);
            pattern.graphics.endFill();
            pattern.graphics.beginFill(0xdfdfdf);
            pattern.graphics.drawRect(8, 0, 8, 8);
            pattern.graphics.endFill();
            pattern.graphics.beginFill(0xdfdfdf);
            pattern.graphics.drawRect(0, 8, 8, 8);
            pattern.graphics.endFill();
            pattern.graphics.beginFill(0xffffff);
            pattern.graphics.drawRect(8, 8, 8, 8);
            pattern.graphics.endFill();
            
            var texture:BitmapData = new BitmapData(16, 16, false, 0x0);
            texture.draw(pattern);
            
            this.graphics.beginBitmapFill(texture);
            this.graphics.drawRect(0, 0, 465, 465);
            this.graphics.endFill();
            
            star = new Star(160, 80);
            this.addChild(star);
            star.update(230, 230, 0);
            
            stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(e:Event=null):void
        {
            var inside:Boolean = pointInPolygon(stage.mouseX, stage.mouseY, star.poly);
            star.draw(inside? 0xf9c330 : 0x000000);
        }
        
        //  http://alienryderflex.com/polygon/
        //
        //  Globals which should be set before calling this function:
        //
        //  int    polySides  =  how many corners the polygon has
        //  float  polyX[]    =  horizontal coordinates of corners
        //  float  polyY[]    =  vertical coordinates of corners
        //  float  x, y       =  point to be tested
        //
        //  (Globals are used in this example for purposes of speed.  Change as
        //  desired.)
        //
        //  The function will return YES if the point x,y is inside the polygon, or
        //  NO if it is not.  If the point is exactly on the edge of the polygon,
        //  then the function may return YES or NO.
        //
        //  Note that division by zero is avoided because the division is protected
        //  by the "if" clause which surrounds it.
        /*
        bool pointInPolygon() {
            
            int      i, j=polySides-1 ;
            boolean  oddNodes=NO      ;
            
            for (i=0; i<polySides; i++) {
                if (polyY[i]<y && polyY[j]>=y
                    ||  polyY[j]<y && polyY[i]>=y) {
                    if (polyX[i]+(y-polyY[i])/(polyY[j]-polyY[i])*(polyX[j]-polyX[i])<x) {
                        oddNodes=!oddNodes; }}
                j=i; }
            
            return oddNodes; }
        */
        
        public function pointInPolygon(x:Number, y:Number, poly:Array):Boolean
        {
            var oddNodes:Boolean = false;
            var sides:int = poly.length;
            var i:int;
            var j:int = sides - 1;
            var xi:Number, xj:Number, yi:Number, yj:Number;
            for(i = 0; i < sides; i++) {
                xi = poly[i].x;
                yi = poly[i].y;
                xj = poly[j].x;
                yj = poly[j].y;
                if(yi < y && yj >= y || yj < y && yi >= y) {
                    if(xi + (y - yi) / (yj- yi) * (xj - xi) < x ) {
                        oddNodes = !oddNodes;
                    }
                }
                j = i;
            }
            return oddNodes;
        }
    }
}


import flash.display.Shape;

class Star extends Shape
{
    private var OUTER_RADIUS:Number = 20;
    private var INNER_RADIUS:Number = 12;
    
    public var poly:Array;
    
    public function Star(outerRadius:Number, innerRadius:Number)
    {
        this.OUTER_RADIUS = outerRadius;
        this.INNER_RADIUS = innerRadius;
        
        this.poly = [];
        for(var i:int=0; i < 12; i++) {
            poly[i] = {x:0, y:0};
        }
        
        update();
        draw();
    }
    
    public function update(offsetX:Number=0, offsetY:Number=0, rotation:Number=0):void
    {
        var r:Number = Math.PI/180 * rotation;
        
        for (var i:int = 0; i <= 11; i++) {
            var radius:Number = (i & 1)? (INNER_RADIUS) : (OUTER_RADIUS);
            var theta:Number = 0.2 * Math.PI * i;
            poly[i].x = radius * Math.sin(theta + r) + offsetX;
            poly[i].y = radius * -Math.cos(theta + r) + offsetY;
        }
    }
    
    public function draw(color:uint=0x0):void
    {
        graphics.clear();
        //graphics.beginFill(color);
        graphics.lineStyle(2, color);
        
        var node:Object = poly[0];
        graphics.moveTo(node.x, node.y);
        
        var numNodes:int = poly.length;
        for(var i:int = 0; i < numNodes; i++) {
            node = poly[i];
            graphics.lineTo(node.x, node.y);
        }
        
        //graphics.endFill();
    }
    
}