/**
 * Copyright kazy ( http://wonderfl.net/user/kazy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/t8Vu
 */

package {
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	import flash.geom.Point;
	/**
	 * Main.
	 * DRAWING STRAIGHT LINE
	 * AS3の描画の勉強 線を描く　
	 * @since 2009/05/20 9:39
	 */
	public class Main extends Sprite {
		private var _currentShape:Shape;
		private var _color:uint;
		private var _startPosition:Point;
		/**
		 * constructor.
		 */
		public function Main() {
			//マウスダウンのイベントを登録
			stage.addEventListener(MouseEvent.MOUSE_DOWN, onStageMouseDown);
			//マウスアップのイベントを登録
			stage.addEventListener(MouseEvent.MOUSE_UP, onStageMouseUp);
		}
		/**
		 * drawLine.
		 * 直線を描く
		 */
		private function drawLine():void {
			//初期化
			_currentShape.graphics.clear();
			//lineStyleの設定
			_currentShape.graphics.lineStyle(3, _color);
			//Shapeをスタート位置へ
			_currentShape.graphics.moveTo(_startPosition.x, _startPosition.y);
			//マウスカーソル位置まで線を描く
			_currentShape.graphics.lineTo(stage.mouseX, stage.mouseY);
		}
		/**
		 * onStageMouseDown.
		 * マウスダウンした時の処理
		 * @param event マウスイベント
		 */
		private function onStageMouseDown(event:MouseEvent):void {
			//直線の色を決める
			_color = Math.random() * 0xFFFFFF;
			//Shapeをnewする
			_currentShape = new Shape();
			//ステージに配置
			addChild(_currentShape);
			//直線のスタート位置を決める
			_startPosition = new Point(stage.mouseX, stage.mouseY);
			//マウス動作時のイベントを追加
			stage.addEventListener(MouseEvent.MOUSE_MOVE, onStageMouseMove);
		}
		/**
		 * onStageMouseUp.
		 * マウスアップした時の処理
		 * @param event マウスイベント
		 */
		private function onStageMouseUp(event:MouseEvent):void {
			//マウス動作時のイベントを削除
			stage.removeEventListener(MouseEvent.MOUSE_MOVE, onStageMouseMove);
		}
		/**
		 * onStageMouseMove.
		 * @param event マウスイベント
		 */
		private function onStageMouseMove(event:MouseEvent):void {
			//drawLineを実行
			drawLine();
			//イベント発生ごとに更新
			event.updateAfterEvent();
		}
	}
}