/**
 * Copyright rainafter ( http://wonderfl.net/user/rainafter )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/t8Sv
 */

// forked from bgarraud's flash on 2010-3-12
//
//  Coding Sample
//
//  By Ben Garraud
//

 
package {
    
    import flash.display.Sprite;
       
    
    [SWF(width="465", height="465", backgroundColor="0x000000", frameRate="30")]
    
    public class LastFmLikeDislike extends Sprite {
        
            private var $view:View;
            private var $model:Model;
            private var $controller:Controller;
        
        public function LastFmLikeDislike() {
            $model = new Model();
            $controller = new Controller($model);
            $view = new View($model,$controller);
            this.addChild($view);
            
        }
    }
    
}


//
//
//
// Model
//

import org.papervision3d.view.BasicView;
     
class View extends BasicView {
    import flash.display.Bitmap;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.filters.GlowFilter;

    import org.papervision3d.objects.primitives.Cube;
    import org.papervision3d.materials.WireframeMaterial;
    import org.papervision3d.materials.BitmapMaterial;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.core.math.Number3D;
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.events.InteractiveScene3DEvent;
    
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.tweens.ITween;
    import org.libspark.betweenas3.easing.*;

     private var $model:Model;
     private var $controller:Controller;
     
     private var $artistObject:Cube;
     private var $materialList:MaterialsList;
     private var $thumbsUp:Plane;
     private var $thumbsDown:Plane;
     private var $cubeSides:CubeSides = new CubeSides();
     private var $title:TextField;
     private var $mainTitle:TextField;
     
     private var $heart:Bitmap;
     private var $cross:Bitmap;
     
     private var $tweenHeart:ITween;
     private var $tweenCross:ITween;
     
     public function View(model:Model,controller:Controller):void {
           super(465, 465,false,true);
           $model = model;
           $controller = controller;
           $controller.setView(this);  
           
           viewport.filters = [new GlowFilter(0xFFFFFF, .3, 20, 20, 1)];     
     }
     
     public function createArtistObject():void
     {
            
            $materialList = new MaterialsList();
            $materialList.addMaterial(new ColorMaterial(0x000000), "back");
           $materialList.addMaterial(new ColorMaterial(0x000000), "bottom");
           $materialList.addMaterial(new ColorMaterial(0x000000), "front");
           $materialList.addMaterial(new ColorMaterial(0x000000), "left");
           $materialList.addMaterial(new ColorMaterial(0x000000), "right");
           $materialList.addMaterial(new ColorMaterial(0x000000), "top");

            $artistObject = new Cube($materialList, 200,200,200,10,10,10);
           scene.addChild($artistObject); 
         
     }
     
     public function createUI(assets:Array):void
     {
             var bmp:Bitmap = assets[0].content;
             var bmpMat:BitmapMaterial = new BitmapMaterial(bmp.bitmapData);
             bmpMat.doubleSided = true;
             bmpMat.smooth = true;
             bmpMat.interactive = true;
             $thumbsUp = new Plane(bmpMat,bmp.width,bmp.height);
             $thumbsUp.name = "up";
             $thumbsUp.x = -155;
             $thumbsUp.y = 18;
             $thumbsDown = new Plane(bmpMat,bmp.width,bmp.height);
             $thumbsDown.name = "down";
             $thumbsDown.x = 155;
             $thumbsDown.y = -18;
             $thumbsDown.rotationX = 180;
             $thumbsDown.rotationY = 180;

             scene.addChild($thumbsUp);
             scene.addChild($thumbsDown);
             
             $title = new TextField();
             $title.y= 65;
             $title.width = stage.stageWidth;
             var format:TextFormat = new TextFormat();
            format.font = "Verdana";
            format.color = 0xFFFFFF;
            format.size = 20;
            format.align = "center";
            

            $title.defaultTextFormat = format;
            this.addChild($title);
            
            $mainTitle = new TextField();
             $mainTitle.y= 20;
             $mainTitle.width = stage.stageWidth;
             format = new TextFormat();
            format.font = "Verdana";
            format.color = 0x666666;
            format.size = 30;
            format.align = "center";
            

            $mainTitle.defaultTextFormat = format;
            this.addChild($mainTitle);
            $mainTitle.text = "What do you think of?"
            
            $heart = assets[1].content;
            $heart.x = (stage.stageWidth-$heart.width)*.5;
            $heart.y = (stage.stageHeight-$heart.height)*.5;
            $heart.alpha = 0;
            $cross = assets[2].content;
            $cross.x = (stage.stageWidth-$cross.width)*.5;
            $cross.y = (stage.stageHeight-$cross.height)*.5;
            $cross.alpha = 0;
            $cross.scaleX
            this.addChild($cross);
            this.addChild($heart);
            
            $tweenHeart = BetweenAS3.serial(
                                BetweenAS3.tween($heart, {alpha:1,y:(stage.stageHeight-$heart.height)*.5, scaleX:1, scaleY:1, x:(stage.stageWidth-($cross.width))*.5},{alpha:0,y:stage.stageHeight, scaleX:0.2, scaleY:0.2, x:(stage.stageWidth-($cross.width*0.2))*.5}, 0.4),
                                BetweenAS3.to($heart, {alpha:  0, scaleX:0.8, scaleY:0.8, x:(stage.stageWidth-($cross.width*0.8))*.5}, 0.3)
                            )
            
            $tweenCross = BetweenAS3.serial(
                                BetweenAS3.tween($cross, {alpha:1,y:(stage.stageHeight-$cross.height)*.5, scaleX:1, scaleY:1, x:(stage.stageWidth-($cross.width))*.5},{alpha:0,y:stage.stageHeight, scaleX:0.2, scaleY:0.2, x:(stage.stageWidth-($cross.width*0.2))*.5}, 0.4),
                                BetweenAS3.to($cross, {alpha:  0, scaleX:0.8, scaleY:0.8, x:(stage.stageWidth-($cross.width*0.8))*.5}, 0.3)
                            )
             
     }
     public function removeThumbListeners():void
     {
             $thumbsUp.removeEventListener(InteractiveScene3DEvent.OBJECT_OVER,thumbOver);
             $thumbsDown.removeEventListener(InteractiveScene3DEvent.OBJECT_OVER,thumbOver);
             $thumbsUp.removeEventListener(InteractiveScene3DEvent.OBJECT_OUT,thumbOut);
             $thumbsDown.removeEventListener(InteractiveScene3DEvent.OBJECT_OUT,thumbOut);
             $thumbsUp.removeEventListener(InteractiveScene3DEvent.OBJECT_CLICK,thumbClick);
             $thumbsDown.removeEventListener(InteractiveScene3DEvent.OBJECT_CLICK,thumbClick);
     }
     public function addThumbListeners():void
     {
             
             $thumbsUp.addEventListener(InteractiveScene3DEvent.OBJECT_OVER,thumbOver,false,0,true);
             $thumbsDown.addEventListener(InteractiveScene3DEvent.OBJECT_OVER,thumbOver,false,0,true);             
             $thumbsUp.addEventListener(InteractiveScene3DEvent.OBJECT_OUT,thumbOut,false,0,true);
             $thumbsDown.addEventListener(InteractiveScene3DEvent.OBJECT_OUT,thumbOut,false,0,true);
             $thumbsUp.addEventListener(InteractiveScene3DEvent.OBJECT_CLICK,thumbClick,false,0,true);
             $thumbsDown.addEventListener(InteractiveScene3DEvent.OBJECT_CLICK,thumbClick,false,0,true);
     }
     private function thumbOver(e:InteractiveScene3DEvent):void
     {
         var shake:Array = [-20,20,-20,20,0];

         var serial:ITween = BetweenAS3.serial(
                    BetweenAS3.to(e.target, {rotationZ: shake[0]}, 0.1),
                    BetweenAS3.to(e.target, {rotationZ:  shake[1]}, 0.2),
                    BetweenAS3.to(e.target, {rotationZ:  shake[2]}, 0.2),
                    BetweenAS3.to(e.target, {rotationZ:  shake[3]}, 0.2),
                    BetweenAS3.to(e.target, {rotationZ:  shake[4]}, 0.1)
        )
         serial.play();
         
         viewport.buttonMode = true;
         
     }
     private function thumbOut(e:InteractiveScene3DEvent):void
     {
         viewport.buttonMode = false;
         
     }
     private function thumbClick(e:InteractiveScene3DEvent):void
     {
         removeThumbListeners();
         
         
         $controller.loadNextArtist();
         
         if (e.target.name == "up") {
             $tweenHeart.gotoAndPlay(0);
         } else {
            $tweenCross.gotoAndPlay(0);
         }
         $controller.addToList($title.text,e.target.name)
     }
     
     public function setupPV3D():void
     {
         camera.focus = 100
        camera.zoom = 10;
         this.startRendering(); 
     }
     
     public function updateMaterial(asset:Object):void
     {
         $title.text =  asset.artist;
         
         var newSide:Array = $cubeSides.nextSide();
         
         $artistObject.replaceMaterialByName(new BitmapMaterial(Bitmap(asset.content).bitmapData),newSide[0]);
         
         var tween:ITween = BetweenAS3.to($artistObject, Object(newSide[1]), 1.2,Back.easeInOut)
         tween.play();
     }
     
      
        
}

//
//
//
// Model
//

import flash.events.EventDispatcher;

internal class Model extends EventDispatcher {
        import flash.net.URLLoader;
        import flash.net.URLRequest;
        import flash.events.Event;
        import flash.events.IOErrorEvent;
        import flash.display.Loader;
        import flash.utils.Dictionary;
        
        private var $xmlURL:String = "http://ws.audioscrobbler.com/2.0/?method=tag.gettopartists&tag=alternative&api_key=b25b959554ed76058ac220b7b2e0a026";
        private var $xmlLoader:URLLoader = new URLLoader();
        private var $xmlData:XML;
         
        private var $assetLoader:Loader = new Loader();
        private var $loaderContext:LoaderContext = new LoaderContext ();

        private var $assetLoading:Boolean = false;
        private var $assetLoaderQue:Array = [];
        private var $assetLibrary:Dictionary = new Dictionary();
        private var $uiAssets:Array = [];
        
        private var $aristLikes:Array = [];
        private var $aristDislikes:Array = [];
        
        // events
        private var $modelEvent:AppEvent;
        
        // data
        private var $index:int = -1;
        
        // datatypes
        public static const USER_INTERFACE:String = 'userinterface';
        public static const ARTIST:String = 'artist';
        
        public function Model():void {
            $loaderContext.checkPolicyFile = true;
            
            $xmlLoader.addEventListener(Event.COMPLETE, xmlLoaded);
            $assetLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, assetLoaded);
            $assetLoader.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, error);
        }
         
        public function loadData():void
        {
             $xmlLoader.load(new URLRequest($xmlURL));     
        }
        private function xmlLoaded(e:Event):void
        {
             $xmlData = new XML(e.target.data);
               $modelEvent = new AppEvent(AppEvent.DATA_READY);
               $modelEvent.data = $xmlData;
               dispatchEvent($modelEvent);
        }
        
        public function loadAsset(url:String,type:String):void
        {
            
            if ($assetLoading) {
                $assetLoaderQue.push({url:url, type:type})    
            } else {
                
                $assetLoading = true;
                if ($assetLoaderQue.length>0) {
                    
                    if (url!==$assetLoaderQue[0].url) {
                        $assetLoaderQue.push({url:url, type:type})
                    }
                } else {
                        $assetLoaderQue.push({url:url, type:type})
                }
                $assetLoader.load(new URLRequest(url),$loaderContext);
                if (type==Model.USER_INTERFACE) {
                     $uiAssets.push(url);
                 }
                 
            }
            
        }
        
        private function assetLoaded(e:Event):void
        {
             $assetLoading = false;
            
             $assetLibrary[String($assetLoaderQue[0].url)] = $assetLoader.content;
         
             $modelEvent = new AppEvent(AppEvent.ASSET_READY);
               $modelEvent.data = {content:$assetLoader.content, url:String($assetLoaderQue[0].url), type:String($assetLoaderQue[0].type)};
             $assetLoaderQue.shift();

               if ($assetLoaderQue.length > 0) {
                   loadAsset($assetLoaderQue[0].url, $assetLoaderQue[0].type)
               }
               
               dispatchEvent($modelEvent);
        }
        
        private function error(e:IOErrorEvent):void
        {
            trace("ioErrorHandler: " + e);

        }
        
        // data access
        public function get data():XML
        {
             return $xmlData
        }
        
        public function get index():int
        {
            return $index
        }
        public function set index(i:int):void
        {
            $index = i;
        }         
        public function asset(ast:String):Object
        {
            var asset:Object = $assetLibrary[ast];
            
            return asset;
        }
        public function UIAssetsloaded():Boolean
        {
            if (this.asset($uiAssets[$uiAssets.length-1])!==null) {
               return true
            }
            
            return false
        }
        public function getUIAssets():Array
        {
            var arr:Array = [];
            for each (var id:String in $uiAssets) {
                arr.push({content:this.asset(id)});
            }
            return arr
        }
        
        public function addAristToList(artist:String,type:String):void
        {
            
            if (type=="up") {
                $aristLikes.push(artist)
                
                trace("I do like "+$aristLikes.join(", "))
                
            } else {
                $aristDislikes.push(artist)
                
                trace("I dont't like "+$aristDislikes.join(", "))
            }
        }
        
        
}
    
//
//
//
// Controller
//
class Controller {
        import flash.events.Event;
        
        private var $model:Model;
        private var $view:View;
        private var $waitingForData:Boolean=false;
        private var $firstLoad:Boolean=true;
         
        public function Controller(model:Model):void {
            $model = model;
            initModelEventListeners();
            
            $model.loadData();
            
            $model.loadAsset("http://www.bengarraud.co.uk/Thumbs-up-icon.png",Model.USER_INTERFACE);
            $model.loadAsset("http://www.bengarraud.co.uk/heart.png",Model.USER_INTERFACE);
            $model.loadAsset("http://www.bengarraud.co.uk/delete.png",Model.USER_INTERFACE);
        }
         
        private function initModelEventListeners():void
        {
            $model.addEventListener(AppEvent.DATA_READY, handleData);
            $model.addEventListener(AppEvent.ASSET_READY, handleAsset);
        }
        
        private function handleAsset(e:AppEvent):void
        {
            
            if (e.data.type == Model.USER_INTERFACE) {
              
              
              if ($model.UIAssetsloaded()) {

                  $view.createUI($model.getUIAssets());
                  loadNextArtist();
              }
              
              
              
            } else {
               if ($firstLoad) {
                  $firstLoad = false;
                  
                  $view.createArtistObject();
                  
                  $view.setupPV3D();
               }
               var artistNode:XML = $model.data..artist[$model.index];
               e.data.artist = String(artistNode.name);
               
               $view.updateMaterial(e.data);
               $view.addThumbListeners();
              
            }
        }
        
        
        public function loadNextArtist():void
        {
            
            if ($model.data == null) {
               $waitingForData = true;
            
            } else {
                $model.index ++;
                if ($model.index>= $model.data..artist.length()) $model.index = 0;
                
                
                var artistNode:XML = $model.data..artist[$model.index];
                $model.loadAsset(artistNode.image.(@size == "extralarge"), Model.ARTIST);
                
            }
            
            
        }
         public function addToList(artist:String,type:String):void
        {
            $model.addAristToList(artist,type);    
        }
       
        private function handleData(e:AppEvent):void
        {
            if ($waitingForData) {
                $waitingForData = false;
                loadNextArtist();
            }
        }
        public function setView (view:View):void 
        { 
            $view = view; 
        } 
        
        
        
}

import flash.events.Event;
import flash.display.Sprite;
import flash.system.LoaderContext;

class AppEvent extends Event {
    public static const DATA_READY:String = 'dataready';
    public static const ASSET_READY:String = 'assetready';
    
    public var data:Object;
    
    public function AppEvent(eventType:String):void
    {
        super(eventType);
    }
    
}

//
//
// cobe rotation store
//

class CubeSides {
   import org.papervision3d.objects.DisplayObject3D;
   import flash.utils.Dictionary;
    
   private var index:Number = -1;
   private var sides:Dictionary = new Dictionary();
   private var sidesIndex:Array = ["left","bottom","top","front","right","back"];
   
   
   
   public function CubeSides() {
   
           this.setSide("front", new DisplayObject3D())
           this.getSide("front").rotationX = 180;
           this.getSide("front").rotationZ = 180;
           this.setSide("left", new DisplayObject3D())
           this.getSide("left").rotationY = -90;
           this.setSide("bottom", new DisplayObject3D())
           this.getSide("bottom").rotationX = 90;
           this.getSide("bottom").rotationZ = 180;
           this.setSide("top", new DisplayObject3D())
           this.getSide("top").rotationX = -90;
           this.setSide("right", new DisplayObject3D())
           this.getSide("right").rotationY = -90;
           this.setSide("back", new DisplayObject3D())
           
   }
   public function setSide(side:String,do3D:DisplayObject3D):void
   {
          do3D.name = side;
          sides[side] = do3D;
   }  
   public function getSide(side:String):DisplayObject3D
   {
          return sides[side]
   }
   
   public function nextSide():Array
   {
           index++;
           if (index>=sidesIndex.length) {
               index = 0;
           }
           var side:DisplayObject3D = sides[String(sidesIndex[index])];
           
           return [sidesIndex[index],{rotationY:side.rotationY, rotationX:side.rotationX, rotationZ:side.rotationZ}]
           
   }


}
   
