/**
 * Copyright kousho ( http://wonderfl.net/user/kousho )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/t8RB
 */

package {

    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.display.Graphics;
    import flash.geom.Point
    import flash.events.Event;

    [SWF(width="500",height="500",backgroundColor="0x000000",frameRate="30")];

    public class MyGraph extends Sprite
    {
        public var step:Number;
        public var dist:Number;
        public var scale:Number;
        public var r1:Number;
        public var r2:Number;
        public var freq:Number;
        public var phase:Number;
        public var graph:Shape;
        
        public function MyGraph()
        {
            freq = 1;
            phase = 0;
            r1 = 0;
            r2 = 0;
            step = 15;
            dist = 40;
            scale = 12;

            graph = new Shape();
            stage.addChild(graph);

            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
        }
   
        public function drawGraph():void
        {
            var _obj1:Object;
            var _obj2:Object;
            var _p1:Point;
            var _p2:Point;
            var dx:Number;
            var dy:Number;

            var g:Graphics = graph.graphics;
            g.clear();
            g.lineStyle(1, 0xCCCCCC, 1.0);
            
            for(dx = -step; dx <= step; dx++)
            {
                _obj1 = rotate3dPoint(dx,-step,dz(dx,-step),r1,r2);
                _p1 = get2dPoint(_obj1[0], _obj1[1], _obj1[2]);
                g.moveTo(_p1.x, _p1.y);
               
                for(dy = 1 - step; dy <= step; dy++)
                {
                    _obj2 = rotate3dPoint(dx,dy,dz(dx,dy),r1,r2)
                    _p2 = get2dPoint(_obj2[0], _obj2[1], _obj2[2]);
                    g.lineTo(_p2.x, _p2.y);
                }
            }

            for(dy = -step; dy <= step; dy++)
            {
                _obj1 = rotate3dPoint(-step, dy, dz(-step, dy),r1,r2)
                _p1 = get2dPoint(_obj1[0], _obj1[1], _obj1[2]);
                g.moveTo(_p1.x, _p1.y);
                
                for(dx = 1 - step; dx <= step; dx++)
                {
                    _obj2 = rotate3dPoint(dx,dy,dz(dx,dy),r1,r2)
                    _p2 = get2dPoint(_obj2[0], _obj2[1], _obj2[2]);
                    g.lineTo(_p2.x, _p2.y);
                }
            }

        }

        public function dz(dx:Number, dy:Number):Number
        {
            var dist:Number = Math.sqrt(dx * dx + dy * dy);
            return Math.cos(-dist/2 + phase) * 10 * 3 / (dist + 3);
        }

        public function get2dPoint(dx:Number, dy:Number, dz:Number):Point
        {
            var _point:Point = new Point();
            _point.x = dx * dist / (dist + dz) * scale + stage.stageWidth/2;
            _point.y = dy * dist / (dist + dz) * scale + stage.stageHeight/2;
            return _point;
        }

        public function rotate3dPoint(x0:Number, y0:Number, z0:Number, r1:Number, r2:Number):Object
        {
            var _obj:Object = new Object();
            
            var x1:Number;
            var y1:Number;
            var y2:Number;
            var z1:Number;
            
            var c1:Number = Math.cos(r1);
            var s1:Number = Math.sin(r1);
            var c2:Number = Math.cos(r2);
            var s2:Number = Math.sin(r2);
            
            x1 = x0 * c1 - y0 * s1;
            y1 = y0 * c1 + x0 * s1;
            
            y2 = y1 * c2 - z0 * s2;
            z1 = z0 * c2 + y1 * s2;
            
            _obj[0] = x1;
            _obj[1] = y2;
            _obj[2] = z1;
            return _obj;
        }

        public function enterFrameHandler(event:Event):void
        {
            r1 += (stage.mouseX - stage.stageWidth/2) * 0.0001;
            //r1 += 0.01;
            r2 += (stage.mouseY - stage.stageHeight/2) * 0.0001;
            phase += Math.PI * 2 / 30 * freq;
            drawGraph();
        }
    }
}