/**
 * Copyright vlad.el.rojo ( http://wonderfl.net/user/vlad.el.rojo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/t7NB
 */

// Espiral Ciruclar Atòmica. Vladimir Israel Ramírez Díaz. VLD
package 
{
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.text.*;
    import flash.ui.*;
    import frocessing.color.ColorHSV;
    import net.hires.debug.Stats;
    
    [SWF(width=465,height=465,backgroundColor=0xFFFFFF,frameRate=60)]
    

    
    public class Main extends Sprite 
    {
        private const NUM:int = 10000;
        private const PI:Number = Math.PI;
        private const PI2:Number = Math.PI * 2;
        private const CX:int = 399;
        ;
        private const CY:int = 232;
        private const FIBO:Number = ((1 + Math.sqrt(5)) * .5);
        
        private var canvas:BitmapData;
        private var glow:BitmapData;
        private var mat:Matrix = new Matrix(.25, 0, 0, .25);
        private var particles:Vector.<Particle> = new Vector.<Particle>(NUM, true);
        private var n:Number = 0;
        private var i:int;
        private var hsv:ColorHSV = new ColorHSV();
        
        public function Main():void 
        {
            stage.quality = StageQuality.MEDIUM;
            canvas = new BitmapData(465, 465, false, 0x0);
            addChild(new Bitmap(canvas)) as Bitmap;
            
            glow = new BitmapData(465 / 4, 465 / 4, false, 0x0);
            var bmp:Bitmap = addChild(new Bitmap(glow, PixelSnapping.NEVER, true)) as Bitmap;
            bmp.scaleX = bmp.scaleY = 4;
            bmp.blendMode = BlendMode.ADD;
            
            for (var i:int = 0; i < NUM; i++) 
            {
                var p:Particle = new Particle();
                particles[i] = p;
            }
            addEventListener(Event.ENTER_FRAME, update);
            //addChild(new Stats());
        }
        
        private function update(e:Event):void 
        {
            n += .001;
            canvas.lock();
            canvas.fillRect(canvas.rect, 0x0);
            for (i = 0; i < NUM; i++) 
            {
                var p:Particle = particles[i] as Particle;
                var angle:Number = PI2 * FIBO * i + n;
                p.x = CX + Math.cos(angle) * i * .038;
                p.y = CY + Math.sin(angle) * i * .038;
                hsv.h = angle * 180 / PI2 * .5;
                canvas.setPixel(p.x, p.y, hsv.value);
            }
            glow.draw(canvas, mat);
            canvas.unlock();
            
        }
    }
}

import flash.display.Graphics;

class Particle
{
    public var x:Number, y:Number;
    public function Particle(){}
}