/**
 * Copyright 3f5 ( http://wonderfl.net/user/3f5 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/t6k7
 */

// forked from muta244's [最適化 Tips] 色々な整数化手段での処理速度の違い
package {

import flash.display.*;
import flash.events.*;
import flash.text.*;
import flash.utils.*;

public class Main extends Sprite
{
    static private const _NUM_TIMES:uint = 10000000;
    
    private function _init():void
    {
        _debug(
            "各テスト " + _NUM_TIMES + " 回処理させた計算結果 [単位 ： ミリ秒]\n" +
            "(誤差は多少生じます)\n"
        );
        
        var n:Number = Math.PI;
        var floor:Function = Math.floor;
        
        _measure("ループのみ", function ():void
        {
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                
            }
        });
        
        _measure("Math.floor(n) で整数化", function ():void
        {
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                Math.floor(n);
            }
        });
        
        _measure("ローカル変数の floor(n) で整数化", function ():void
        {
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                floor(n);
            }
        });
        
        _measure("n >> 0 で整数化", function ():void
        {
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                n >> 0;
            }
        });
        
        _measure("n | 0 で整数化", function ():void
        {
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                n | 0;
            }
        });
        
        _measure("~~n で整数化", function ():void
        {
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                ~~n;
            }
        });
        
        _measure("int(n) で整数化", function ():void
        {
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                int(n);
            }
        });

        _measure("自作関数で整数化", function ():void
        {
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                ~~((n >= ~~n) ? n : n - 1);
            }
        });
        
        _debug("\n結果については言及しませんので, 各自ご判断ください.");
    }
    
    private function myFloor(num:Number):int {
       return (num >= 0) ? ~~num : ~~(num - 1);
    }

    
    private var _field:TextField;
    private var _time:uint;
    
    public function Main():void
    {
        _setup();
        _init();
    }
    
    private function _measure(title:String, func:Function, ...params):void
    {
        _time = getTimer();
        func.apply(null, params);
        _time = getTimer() - _time;
        
        _debug("[ " + title + " ] --> " + _time + " ms");
    }
    
    private function _debug(log:String):void
    {
        _field.appendText(log + "\n");
    }
    
    private function _setup():void
    {
        _field = new TextField();
        _field.width = stage.stageWidth - 40;
        _field.height = stage.stageHeight - 60;
        _field.x = 20;
        _field.y = 60;
        _field.multiline = true;
        _field.wordWrap = true;
        
        var format:TextFormat = _field.defaultTextFormat;
        format.font = "_sans";
        _field.defaultTextFormat = format;
        
        addChild(_field);
        
        var button:Sprite = new Sprite();
        button.graphics.lineStyle(1, 0xBBBBBB);
        button.graphics.beginFill(0xEEEEEE);
        button.graphics.drawRoundRect(0, 0, 100, 20, 5, 5);
        button.graphics.endFill();
        
        addChild(button);
        
        button.x = 20;
        button.y = 20;
        button.mouseChildren = false;
        button.buttonMode = true;
        
        var field:TextField = new TextField();
        field.width = 100;
        field.height = 20;
        field.htmlText = "<p align='center'><font face='_sans'>再計算</span></p>";
        
        button.addChild(field);
        
        button.addEventListener(MouseEvent.CLICK, function ():void
        {
            _field.text = "";
            _init();
        });
    }
}

}
