/**
 * Copyright flocdelay ( http://wonderfl.net/user/flocdelay )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/t6fN
 */

// forked from nutsu's FractalSample
package  
{
    import frocessing.display.F5MovieClip2D;
    
    [SWF(width=465,height=465,backgroundColor=0xFFFFFF)]
    public class FractalSample extends F5MovieClip2D
    {
        private var shape_size:Number;
        private var r1:Number;
        private var r2:Number;
        private var r3:Number;
        private var c1:int;
        private var c2:int;
        
        public function FractalSample() 
        {
            //線と塗りの色指定
            colorMode( HSV, 100);
            c1 = 0;
            c2 = 6;
            noFill();
            
            //キャンバスを移動
            translate( 465/2, 465/2 + 30 );
            
            //シェイプの大きさ
            shape_size = 200;
            
            //三角形の座標パラメータ
            r1 = shape_size;
            r2 = r1/2;
            r3 = r2*Math.sqrt(3);
            
            //フラクタルの描画(再帰回数を指定)
            draw_shapes( 6 );
             }
        
        private function draw_shapes( n:int ):void
        {
            if ( n-- <= 0 ) return;
            
            var rn:int = 3;

            //キャンバスのサイズを半分に
            scale( 0.5 );
            for ( var i:int = 0; i < rn; i++ ) {
                
                pushMatrix();
                //Y方向に-r移動
                translate( 0, -shape_size );
                
                //正三角形の描画
                stroke( c1 + c2, 100, 100, 50 );
                triangle( 0, -r1, r3, r2, -r3, r2 );
                c1 = c1 + c2;
                
                //再帰的に描画
                draw_shapes( n );
                popMatrix();
                
                //360/rn 度回転
                rotate( 2*Math.PI/rn );
            }
        }
    }
}