/**
 * Copyright pigiuz ( http://wonderfl.net/user/pigiuz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/t6eA
 */

package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Rectangle;
    import flash.system.System;
    
    [SWF(rameRate="60")]
    public class FlashTest extends Sprite {
        
        public const kb:Number = 1024;
        public const mb:Number = 1024*kb;
        public const maxMem:Number = 1*mb;
        public const maxSize:Number = 4096;
        public const minSize:Number = 1;
        
        private var _count:uint;
        private var _frameBuffer:BitmapData;
        private var _orientation:Boolean;
        
        public function FlashTest() {
            _frameBuffer = new BitmapData(stage.stageWidth,stage.stageHeight,true,0);
            addChild(new Bitmap(_frameBuffer));
            
            _count = minSize;
            _orientation = true;
            
            addEventListener(Event.ENTER_FRAME,loop);
        }
        
        public function loop(e:Event):void
        {
            
            if(_orientation){
                _frameBuffer.scroll(-1,0); 
                _frameBuffer.fillRect(new Rectangle(_frameBuffer.width-1,0,1,_frameBuffer.height),0);
            }
            var prevMem:Number = System.totalMemoryNumber;
            var nextMem:Number;
            var bd:BitmapData;
            if(_orientation)
                bd = new BitmapData(_count,1,true,0);
            else
                bd = new BitmapData(1,_count,true,0);
            
            nextMem = System.totalMemoryNumber;
            
            var deltaMem:Number = nextMem-prevMem;
            var perc:Number = deltaMem/maxMem;
            
            trace(prevMem,nextMem,deltaMem,((perc*10000)>>0)/100);
            _frameBuffer.setPixel32(_frameBuffer.width-1,_frameBuffer.height-1-perc*_frameBuffer.height,_orientation?0xFF0000FF:0xFFFF0000);
            
            _count++;
            _count %= maxSize;
            if(_count<minSize){
                _count = minSize;
                _frameBuffer.scroll(-1,0); 
                _frameBuffer.fillRect(new Rectangle(_frameBuffer.width-1,0,1,_frameBuffer.height),0xFF00FF00);
            }
            _orientation = !_orientation;
        }
    }
}