/**
 * Copyright demouth ( http://wonderfl.net/user/demouth )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/t6QL
 */

// forked from demouth's mosha mosha
// forked from demouth's クリスマスリース的な何か
package 
{
    import flash.filters.BlurFilter;
    import flash.display.*;
    import flash.events.Event;
    import flash.geom.*;
    import flash.utils.getTimer;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.media.SoundLoaderContext;
    import flash.media.SoundMixer;
    import flash.net.URLRequest;
    import flash.utils.ByteArray;
    import frocessing.color.ColorHSV;
    
    [SWF(width="465", height="465", backgroundColor="0xFFFFFF", frameRate="60")]
    public class FlashTest extends Sprite
    {
        
        public var numPc:int = 400;
        public var pc:Vector.<Particle> = new Vector.<Particle>();
        public var bitmap:Bitmap = new Bitmap(new BitmapData(465, 465 , true , 0xFFFFFFFF));
        public var shape:Shape = new Shape();
        
        private var snd:Sound;
        private var FFTswitch:Boolean = true;
        private var vol:Number;
        private var bytes:ByteArray;
        
        public function FlashTest () 
        {
            super();
            
            if (this.stage) this.init()
            else this.addEventListener(Event.ADDED_TO_STAGE , init);
        }
        
        private function init(event:Event = null):void
        {
            
            this.stage.scaleMode = StageScaleMode.NO_SCALE;
            this.stage.align = StageAlign.TOP_LEFT;
            
            bytes = new ByteArray();
            play("http://level0.kayac.com/images/murai/Digi_GAlessio_-_08_-_ekiti_son_feat_valeska_-_april_deegee_rmx.mp3");
            
            
            this.addChild(this.bitmap);
            this.addChild(this.shape);
            
            this.addEventListener(Event.ENTER_FRAME , enterFrameHandler);
            
        }

        private function play(sndUrl:String):void {
            snd = new Sound();
            var context:SoundLoaderContext = new SoundLoaderContext(10, true);
            var req:URLRequest = new URLRequest(sndUrl);
            snd.load(req, context);
            var sndChannel:SoundChannel = new SoundChannel();
            sndChannel = snd.play(0, 0);
        }
        
        private function enterFrameHandler(e:Event):void 
        {
            
            this.deletePc();
            
            bytes.clear();
            SoundMixer.computeSpectrum(bytes, FFTswitch, 0);
            vol = bytes.readFloat();
            if(vol > 1)this.createPc()
            else this.pc.push(this.getPc());
            
            this.move();
            this.rendering(this.shape.graphics);
            this.bitmap.bitmapData.applyFilter( this.bitmap.bitmapData,this.bitmap.bitmapData.rect,new Point(),new BlurFilter(20 , 20));
            this.draw(this.getMatrix(0));
            this.draw(this.getMatrix(Math.PI));
            this.draw(this.getMatrix(Math.PI / 2));
            this.draw(this.getMatrix(Math.PI / 2 + Math.PI));
            
        }
        
        private function draw(matrix:Matrix):void
        {
            this.bitmap.bitmapData.draw(this.shape , matrix);
        }
        
        private function getMatrix(rotate:Number):Matrix
        {
            var mat:Matrix = new Matrix();
            mat.translate(-232, -232);
            mat.rotate(rotate);
            mat.translate(232, 232);
            return mat;
        }
        
        private function rendering(g:Graphics):void
        {
            var g:Graphics = g;
            g.clear();
            
            var t:Number = Math.abs( Math.sin(getTimer() / 1000) ) ;
            var c:ColorHSV = new ColorHSV( getTimer()*0.01 , 0.9, t );
            
            var l:int = this.pc.length - 1;
            var i:int = 0;
            for (i = 0; i < l; i++) 
            {
                var p:Particle = this.pc[i];
                var radius:Number = ( Math.abs(p.sx) + Math.abs(p.sy) ) * 0.5 ;
                
                g.beginFill(c.value , 1);
                g.drawCircle(p.x , p.y , radius + 1 );
                g.endFill();
            }
        }
        
        private function move():void
        {
            var l:int = this.pc.length - 1;
            var i:int = 0;
            for (i = 0; i < l; i++) 
            {
                var p:Particle = this.pc[i];
                var pw:Number = Math.sqrt( p.sx * p.sx + p.sy * p.sy ) ;
                p.sx += p.ax;
                p.sy += p.ay;
                p.ax = 0;
                p.ay = 0;
                p.x += p.sx + Math.sin(getTimer()*0.005)*(pw+1)*0.4;
                p.y += p.sy + Math.cos(getTimer()*0.005)*(pw+1)*0.4;
                p.sx *= 0.9;
                p.sy *= 0.9;
                
                if (
                    (Math.abs(p.sx) < 0.05)
                    &&
                    (Math.abs(p.sy) < 0.05)
                )
                {
                    p.end = true;
                }
            }
        }
        
        private function createPc():void
        {
            var l:int = this.numPc;
            var i:int = 0;
            for (i = this.pc.length; i < l; i++) this.pc.push(this.getPc());
        }
        
        private function getPc():Particle
        {
            var p:Particle = new Particle();
            
            var pow:Number = Math.random() * 10;
            var angle:Number = Math.PI * 2 * Math.random();
            var x:Number = Math.sin(angle) * pow;
            var y:Number = Math.cos(angle) * pow;
            
            p.x = Math.cos(getTimer()*0.0008)*200 + this.stage.stageWidth/2;
            p.y = Math.sin(getTimer()*0.0010)*200 + this.stage.stageHeight/2;
            p.ax = x;
            p.ay = y;
            p.sx = 0;
            p.sy = 0;
            
            p.end = false;
            return p;
        }

        
        private function deletePc():void
        {
            var l:int = this.pc.length - 1;
            var i:int = 0;
            for (i = l; i >= 0; i--) 
            {
                var p:Particle = this.pc[i];
                if (p.end)
                {
                    this.pc.splice(i, 1);
                    p = null;
                }
            }
        }
        
    }

}
class Particle
{
    
    public var x:Number = 0;
    public var y:Number = 0;
    public var ax:Number = 0;
    public var ay:Number = 0;
    public var sx:Number = 0;
    public var sy:Number = 0;
    
    public var end:Boolean = false;
    
}