/**
 * Copyright zahir ( http://wonderfl.net/user/zahir )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/t6I7
 */

/*
	AIRでフォトショとかのスウォッチを作ってみたいと思い
	勉強がてらに作ってみました。
	
	今回はセクション1のデータのみを使用
	セクション2のデータを使えば色の名前を使えます
	
 */
 /*
 aco フォーマット
 
 1//セクション1
 color num// 全体の色数
 
 
 0　//セパレータ　┐
 R(8bit)　　　　　│
 G(8bit)　　　　　├　色数分繰り返す
 B(8bit)　　　　　│
 0　//セパレータ　┘
 
 
 2　//セクション2
 color num //全体の色数
 
 
  0　//セパレータ　
 R(8bit)　　　　　
 G(8bit)　　　　　
 B(8bit)　　　　　
 0　//セパレータ　
 0　//セパレータ
 length //この数値自体を含むstringの長さ
 Color　Name Stringｓ //色の名前のストリング(16bit) length-1個分
 0　//セパレータ
 
 上のブロックを色数分繰り返す
 
  フィーリング的な感じでしか理解してないので正しくないかも知れません
 
 参考：http://www.duo-creative.com/chrisb/aco/

 * */
package{
	import __AS3__.vec.Vector;
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Graphics;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.TextEvent;
	import flash.geom.Matrix;
	import flash.net.FileFilter;
	import flash.net.FileReference;
	import flash.utils.ByteArray;
	
	[SWF(width=465, height = 465, backgroundColor = 0x666666)]

	public class Aco2PNG extends Sprite{
		private var file:FileReference;
		
		private var lBtn:Button;
		private var sBtn:Button;
		
		private var bd:BitmapData;
		private var bmp:Bitmap;
		
		private var size:int = 20;
		private var margin:int = 5;
		
		private var w:int = 465;
		private var h:int = 465;
		
		private var canvas:Sprite;
		
		public function Aco2PNG(){
			
			// canvas
			canvas = new Sprite();
			
			// bitmap
			bd = new BitmapData( w, h, true, 0);
			bmp = new Bitmap( bd );
			bmp.y = 30;
			addChild(bmp);
			
			// Load Button
			lBtn = new Button( 0x111111, 0xFF9900, 0xFF9900, "    Load    ");
			lBtn.x = 8;
			lBtn.y = 5;
			lBtn.addEventListener( TextEvent.LINK, onLoad );
			addChild(lBtn);
			
			// Save Button
			sBtn = new Button( 0x111111, 0xFF9900, 0xFF9900, "    Save    ");
			sBtn.x = lBtn.width + lBtn.x + 10;
			sBtn.y = 5;
			sBtn.addEventListener( TextEvent.LINK, onSave );
			addChild(sBtn);
			
		}
		
		// file Load
		private function onLoad( e:TextEvent ):void{
			file = new FileReference();
			file.addEventListener(Event.SELECT, onSelect );
			file.browse( [ new FileFilter("load aco file (*.aco, *.ACO)", "*.aco;*.ACO")] );
		}
		private function onSelect( e:Event ):void{
			file.removeEventListener(Event.SELECT, onSelect );
			file.addEventListener(Event.COMPLETE, onComp);
			file.load();
		}
		private function onComp( e:Event ):void{
			file.removeEventListener(Event.COMPLETE, onComp );
			var v:Vector.<uint> = parser(file.data);
			var _x:int =-( size);
			var _y:int = margin;
			while( canvas.numChildren ){ canvas.removeChildAt( 0 ) }
			for(var i:int = 0, len:int = v.length; i<len; i++){
				_x += (size + margin);
				if(_x >= w){
					_x = margin;
					_y += (size + margin);
				}
				
				var s:Shape = new Shape();
				var g:Graphics = s.graphics;
				g.beginFill( v[i] );
				g.drawRect( 0,0, size, size );
				g.endFill();
				s.x = _x;
				s.y = _y;
				canvas.addChild( s );
			}
			bd = new BitmapData( canvas.width + margin, canvas.height+ margin + 30, true, 0);
			var m:Matrix = new Matrix();
			bd.draw( canvas );
			bmp.bitmapData = bd;
			if( bmp.width > (w - margin)){
				bmp.width = (w - margin);
				bmp.scaleY = bmp.scaleX;
			}if( bmp.height > (h - margin)){
				bmp.height = (h - margin);
				bmp.scaleX = bmp.scaleY;
			}
		}
		import com.adobe.images.PNGEncoder;
		private function parser( data:ByteArray ):Vector.<uint>{
			var len:int = data.length;
			var vec:Vector.<uint> = new Vector.<uint>();
			
			data.position = 2;
			len = data.readShort() *10 + 4;
			while(data.position < len){
				data.readUnsignedShort();
				var r:int = (data.readUnsignedShort() >> 8);
				var g:int = (data.readUnsignedShort()>> 8);
				var b:int = (data.readUnsignedShort()>> 8);
				vec[vec.length] = (r<<16 | g<<8 | b);
				data.readUnsignedShort();
			}
			return vec;
		}
		
		private function onSave(e:TextEvent):void{
			file.addEventListener(Event.SELECT, s_onSelect);
            file.save(PNGEncoder.encode( bd ), "undef" + ".png");
		}
		private function s_onSelect(e:Event):void{
			file.removeEventListener(Event.SELECT, s_onSelect);
        }
	}
}
	import flash.text.TextField;
	
class Button extends TextField{
	public function Button( bg:uint, border:uint, color:uint , txt:String){
		this.border = this.background = true;
		this.backgroundColor = bg;
		this.borderColor = border;
		this.autoSize = "left";
		this.textColor = color;
		
		this.htmlText = "<a href=\"event:*\">" + txt + "</a>"
	}
}