/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/t66c
 */

package 

{

    import flash.display.Sprite;

    import flash.events.Event;

    

    /**

     * ...

     * @author umhr

     */

    public class WonderflMain extends Sprite 

    {

        

        public function WonderflMain():void 

        {

            if (stage) init();

            else addEventListener(Event.ADDED_TO_STAGE, init);

        }

        

        private function init(e:Event = null):void 

        {

            removeEventListener(Event.ADDED_TO_STAGE, init);

            // entry point

            

            

            stage.scaleMode = "noScale";

            stage.align = "TL";

            

            addChild(new Canvas());

        }

        

    }

    

}





    

    import flash.display.Sprite;

    import flash.events.Event;

    /**

     * ...

     * @author umhr

     */

    class Canvas extends Sprite 

    {

        

        public function Canvas() 

        {

            init();

        }

        private function init():void 

        {

            if (stage) onInit();

            else addEventListener(Event.ADDED_TO_STAGE, onInit);

        }

        

        

        //private var _uiCanvas:UICanvas;

        private function onInit(event:Event = null):void 

        {

            removeEventListener(Event.ADDED_TO_STAGE, onInit);

            // entry point

            

            addChild(CameraManager.getInstance());

            addChild(new UICanvas());

            

        }

    }

    



    

    import flash.display.Sprite;

    import flash.events.Event;

    import flash.media.Camera;

    import flash.media.Video;

    /**

     * ...

     * @author umhr

     */

    class CameraManager extends Sprite 

    {

        private static var _instance:CameraManager;

        public function CameraManager(block:Block){init();};

        public static function getInstance():CameraManager{

            if ( _instance == null ) {_instance = new CameraManager(new Block());};

            return _instance;

        }

        

        private var video:Video = new Video(320, 240);

        private var camera:Camera;

        private function init():void

        {

            if (stage) onInit();

            else addEventListener(Event.ADDED_TO_STAGE, onInit);

        }



        private function onInit(event:Event = null):void 

        {

            removeEventListener(Event.ADDED_TO_STAGE, onInit);

            // entry point

            

        }

        /**

         * 指定されたカメラをセットします。

         * @param    index

         */

        public function setCamera(index:int):void {

            

            camera = Camera.getCamera(index.toString());

            //カメラの存在を確認

            if (camera) {

                setMode(video.width, video.height);

                this.addChild(video);

            } else {

                trace(index, "のカメラが見つかりませんでした。");

            }

        }

        

        public function setMode(w:int, h:int):void {

            camera.setMode(w, h, 30);

            

            video.width = camera.width;

            video.height = camera.height;

            video.attachCamera(camera);

        }

        

        public function getFPS():String {

            return (camera)?"FPS: " + String(camera.currentFPS) + " / " + String(camera.fps):"0 / 0";

        }

        

        /**

         * カメラのリストを返します。

         */

        public function get names():Array/*String*/{

            return Camera.names;

        }

        

    }

    



class Block { };





    

    import com.bit101.components.Label;

    import com.bit101.components.RadioButton;

    import flash.display.Sprite;

    import flash.events.Event;

    /**

     * ...

     * @author umhr

     */

    class UICanvas extends Sprite 

    {

        private var _label:Label;

        public function UICanvas() 

        {

            init();

        }

        private function init():void 

        {

            if (stage) onInit();

            else addEventListener(Event.ADDED_TO_STAGE, onInit);

        }

        

        private function onInit(event:Event = null):void 

        {

            removeEventListener(Event.ADDED_TO_STAGE, onInit);

            // entry point

            

            addList();

            addSizeList();

            addFPSLabel();

        }

        

        private function addFPSLabel():void 

        {

            _label = new Label(this, 0, 0, "FPS:");

            addEventListener(Event.ENTER_FRAME, enterFrame);

        }

        

        //private function setFPS(fps:int):void {

            //_label.text = fps.toString();

        //}

        

        private function enterFrame(event:Event):void 

        {

            _label.text = CameraManager.getInstance().getFPS();

        }

        

        private function addSizeList():void 

        {

            var n:int = 6;

            for (var i:int = 0; i < n; i++) 

            {

                var radioButton:RadioButton = new RadioButton(this, 0, i * 20+20, String(320 * (i + 1) + "x" + 240 * (i + 1)), i == 0, onSize);

                radioButton.groupName = "size";

            }

        }

        

        

        

        private function onSize(event:Event):void 

        {

            var radio:RadioButton = event.target as RadioButton;

            var label:String = radio.label;

            

            var w:int = label.split("x")[0];

            var h:int = label.split("x")[1];

            

            CameraManager.getInstance().setMode(w, h);

        }

        

        /**

         * ラジオボタンでリストを作ります。

         */

        private function addList():void 

        {

            var names:Array/*String*/ = CameraManager.getInstance().names;

            

            var n:int = names.length;

            for (var i:int = 0; i < n; i++) 

            {

                var radioButton:RadioButton = new RadioButton(this, 80, i * 20+20, names[i], i == 0, onRadio);

                radioButton.name = i.toString();

                radioButton.groupName = "names"

            }

            

            if(n > 0){

                CameraManager.getInstance().setCamera(0);

            }

        }

        

        /**

         * ラジオボタンが押されると実行されます。

         * 対応するカメラをセットします。

         * @param    event

         */

        private function onRadio(event:Event):void {

            var radio:RadioButton = event.target as RadioButton;

            CameraManager.getInstance().setCamera(int(radio.name));

        }

    }

    

