/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/t59x
 */

// forked from mousepancyo's perlinNoiseで火星の雲（想像）
package  {
    import flash.events.Event;
    import flash.display.Sprite;
    
    [SWF(backgroundColor="#000000", frameRate="30")] 
    
    public class Main extends Sprite{
        
        private var _perlinNoiseEx:PerlinNoiseEx
        
        public function Main(){
            _perlinNoiseEx = new PerlinNoiseEx(stage.stageWidth, stage.stageHeight)
            addChild(_perlinNoiseEx)
            addEventListener(Event.ENTER_FRAME, _perlinNoiseEx.update)
        }
    }
}

//
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.BitmapDataChannel
import flash.events.Event;
import flash.display.Sprite;
import flash.geom.Point
import flash.geom.ColorTransform;

class PerlinNoiseEx extends Sprite{
    
    private var _mc:Sprite = new Sprite()
    private var _bmd:BitmapData
    private var _oct:int
    private var _seed:Number
    private var _channels:uint
    private var _offset:Array = new Array()
    private var _speed:Array = new Array()
    private var _bm:Bitmap
    private var _color:ColorTransform
    
    private var _w:int
    private var _h:int
    
    public function PerlinNoiseEx(w:int, h:int){
        _w = w
        _h = h
        _bmd = new BitmapData(_w, _h, false, 0x000000);
        _oct = 6
        _seed = Math.floor(Math.random() * 1000);
        _channels = BitmapDataChannel.RED | BitmapDataChannel.BLUE | BitmapDataChannel.GREEN;
        _bm = new Bitmap(_bmd);
        _color = new ColorTransform(1.8,1.7,0.7,1,0,0,0,0);
        //
        _bm.transform.colorTransform = _color;
        _bm.blendMode = "difference"
        addChild(_bm);
        //
        for(var i:int; i<_oct; i++){
            _offset[i] = new Point(Math.random()*_w, Math.random()*_h);
            _speed[i] = new Point(-3, Math.random()*2-1);
        }
    }
    
    public function update(e:Event):void{
        for(var i:int; i<_oct; i++){
            _offset[i].x += _speed[i].x;
            _offset[i].y += _speed[i].y;
        }
        _bmd.perlinNoise(_w, _h/2, _oct, _seed, true, true, _channels, true, _offset);
    }

}
