/**
 * Copyright ohisama ( http://wonderfl.net/user/ohisama )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/t45S
 */

// forked from mizunohiroshi's PCM test
package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.display.Loader;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    public class DSG extends Sprite 
    {
        public function DSG() 
        {
            super();
            init();
        }
        private var loader : Loader;
        private function init() : void 
        {
            var swf : WavFile = new WavFile();
            swf.soundI();
            loader = new Loader();
            loader.loadBytes(swf.swfFile);
            addChild(loader);
            var tf: TextField = new TextField();
            tf.text = "load ok";
            tf.autoSize = TextFieldAutoSize.LEFT;
            addChild(tf);
        }
    }
}
import flash.events.Event;
import flash.events.TimerEvent;
import flash.utils.Timer;
import flash.events.EventDispatcher;
import flash.events.SampleDataEvent;
import flash.media.Sound;
import flash.utils.ByteArray;
class Tone extends EventDispatcher
{
    public static const SAMPLING_RATE : Number = 44100.0;
    public static const BUFFER_SIZE : int = 8192;
    public static const FREQ : int = 220;
    public function Tone() 
    {
        pcm_ = new ByteArray();
        for (var i : int = 0; i < BUFFER_SIZE; ++i) 
        {
            var v : Number = 0.0;
            v += Math.sin( 1.0 * FREQ * 2 * Math.PI * i / SAMPLING_RATE) * 0.060;
            v += Math.sin( 2.0 * FREQ * 2 * Math.PI * i / SAMPLING_RATE) * 0.100;
            v += Math.sin(14.0 * FREQ * 2 * Math.PI * i / SAMPLING_RATE) * 0.005;
            v += Math.sin(15.0 * FREQ * 2 * Math.PI * i / SAMPLING_RATE) * 0.015;
            v += Math.sin(16.0 * FREQ * 2 * Math.PI * i / SAMPLING_RATE) * 0.005;
            v += Math.sin(17.0 * FREQ * 2 * Math.PI * i / SAMPLING_RATE) * 0.005;
            v += Math.sin(18.0 * FREQ * 2 * Math.PI * i / SAMPLING_RATE) * 0.005;
            v += Math.sin(19.0 * FREQ * 2 * Math.PI * i / SAMPLING_RATE) * 0.005;
            v += Math.sin(20.0 * FREQ * 2 * Math.PI * i / SAMPLING_RATE) * 0.015;
            v += Math.sin(21.0 * FREQ * 2 * Math.PI * i / SAMPLING_RATE) * 0.015;
            v += Math.sin(22.0 * FREQ * 2 * Math.PI * i / SAMPLING_RATE) * 0.015;
            v += Math.sin(23.0 * FREQ * 2 * Math.PI * i / SAMPLING_RATE) * 0.015;
            v += Math.sin(24.0 * FREQ * 2 * Math.PI * i / SAMPLING_RATE) * 0.030;
            v += Math.sin(25.0 * FREQ * 2 * Math.PI * i / SAMPLING_RATE) * 0.025;
            v += Math.sin(26.0 * FREQ * 2 * Math.PI * i / SAMPLING_RATE) * 0.020;
            v += Math.sin(27.0 * FREQ * 2 * Math.PI * i / SAMPLING_RATE) * 0.015;
            pcm_.writeFloat(v);
            pcm_.writeFloat(v);
       }
    }
    private var pcm_ : ByteArray;    
    private var sound_ : Sound;
    public function start() : void 
    {
        sound_ = new Sound();
        sound_.addEventListener(SampleDataEvent.SAMPLE_DATA, soundSampleDataHandler);
        sound_.play();
    }
    public function stop() : void 
    {
        sound_.removeEventListener(SampleDataEvent.SAMPLE_DATA, soundSampleDataHandler);
        dispatchEvent(new Event(Event.COMPLETE));
    }
    private function soundSampleDataHandler(event : SampleDataEvent) : void 
    {    
        event.data.writeBytes(pcm_);
    }
}
class WavFile 
{
    import flash.utils.*;
    public var formatID : int;
    public var channel : int;
    public var rate : uint;
    public var bps : uint;
    public var blockSize : int;
    public var sampling : int;
    public var fileSize : uint;
    public var swfFile : ByteArray;
    private const RIFF : uint = 0x46464952;
    private const WAVE : uint = 0x45564157;
    private const FMT : uint = 0x20746D66;
    private const DATA : uint = 0x61746164;
    private const FormatID_PCM : uint = 0x0001;
    private const DummyData : Array = 
    [
        0x46,0x57,0x53,0x06,0x00,0x00,0x00,0x00,
        0x80,0x00,0x00,0xC8,0x00,0x00,0x00,0xC8,
        0x00,0x00,0x0C,0x01,0x00,
        0x43,0x02,0xFF,0xFF,0xFF,
        0x13,0x08,0x02,0x00,0xC0,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x88,0x00,
        0x85,0x06,
        0x02,0x01,0x01,0x02,0x00,
        0x40,0x00
    ];
    private const SwfFileSizePosition : uint = 4;
    private var StartSoundTag : Array = 
    [
        0xC3,0x03,0x01,0x00,0x00
    ];        
    private var EndTag : Array = 
    [
        0x00,0x00
    ];
    private const DefineSoundTagNo : uint = 14;
    private const DefineSoundTagHeaderLength : uint = 7;
    private const SoundFormat_PCM_Little : uint = 3;
    public function soundI() : void 
    {
        const SAMPLING_RATE : int = 44100;
        const FREQ : int = 220;
        var pcm : ByteArray = new ByteArray();
        pcm.endian = Endian.LITTLE_ENDIAN;
        for (var i : int = 0; i < 2 * SAMPLING_RATE; ++i) 
        {
            var v : int = 0;
            v += 200 * Math.sin( 1.0 * FREQ * 2 * Math.PI * i / SAMPLING_RATE);
            v += 300 * Math.sin( 2.0 * FREQ * 2 * Math.PI * i / SAMPLING_RATE);
            v +=  15 * Math.sin(14.0 * FREQ * 2 * Math.PI * i / SAMPLING_RATE);
            v +=  45 * Math.sin(15.0 * FREQ * 2 * Math.PI * i / SAMPLING_RATE);
            v +=  15 * Math.sin(16.0 * FREQ * 2 * Math.PI * i / SAMPLING_RATE);
            v +=  15 * Math.sin(17.0 * FREQ * 2 * Math.PI * i / SAMPLING_RATE);
            v +=  15 * Math.sin(18.0 * FREQ * 2 * Math.PI * i / SAMPLING_RATE);
            v +=  15 * Math.sin(19.0 * FREQ * 2 * Math.PI * i / SAMPLING_RATE);
            v +=  45 * Math.sin(20.0 * FREQ * 2 * Math.PI * i / SAMPLING_RATE);
            v +=  45 * Math.sin(21.0 * FREQ * 2 * Math.PI * i / SAMPLING_RATE);
            v +=  45 * Math.sin(22.0 * FREQ * 2 * Math.PI * i / SAMPLING_RATE);
            v +=  45 * Math.sin(23.0 * FREQ * 2 * Math.PI * i / SAMPLING_RATE);
            v +=  90 * Math.sin(24.0 * FREQ * 2 * Math.PI * i / SAMPLING_RATE);
            v +=  75 * Math.sin(25.0 * FREQ * 2 * Math.PI * i / SAMPLING_RATE);
            v +=  60 * Math.sin(26.0 * FREQ * 2 * Math.PI * i / SAMPLING_RATE);
            v +=  45 * Math.sin(27.0 * FREQ * 2 * Math.PI * i / SAMPLING_RATE);
            v *= 4;
            pcm.writeShort(v);
      } 
      writeToSwfFile(pcm);
   }
   private function writeToSwfFile(data : ByteArray) : Boolean 
   {
        var i : int;
        var tmp : int;
        swfFile = new ByteArray();
        swfFile.endian = Endian.LITTLE_ENDIAN;
        for (i = 0; i < DummyData.length; i++)
        {
            swfFile.writeByte(DummyData[i]);
        }            
        if ((DefineSoundTagHeaderLength + data.length) < 0x3f)
        {
            swfFile.writeShort((DefineSoundTagNo << 6) | (DefineSoundTagHeaderLength + data.length));
        }
        else
        {
            swfFile.writeShort((DefineSoundTagNo << 6) | 0x3f);
            swfFile.writeUnsignedInt(DefineSoundTagHeaderLength + data.length);
        }
        swfFile.writeShort(1);
        tmp = SoundFormat_PCM_Little;
        tmp <<= 2;
        tmp |= 3;
        tmp <<= 1;
        tmp |= 1;
        tmp <<= 1;
        swfFile.writeByte(tmp);
        swfFile.writeUnsignedInt(int(data.length / blockSize));
        swfFile.writeBytes(data);
        for (i = 0; i < StartSoundTag.length; i++)
        {
            swfFile.writeByte(StartSoundTag[i]);
        }
        for (i = 0; i < EndTag.length; i++)
        {
            swfFile.writeByte(EndTag[i]);
        }            
        swfFile.position = SwfFileSizePosition;
        swfFile.writeUnsignedInt(swfFile.length);
        return true;
    }
}
