/**
 * Copyright nabe ( http://wonderfl.net/user/nabe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/t43k
 */

// forked from dada_sygnas's バランス取りゲーム……にしたかった
/*
 * ３点以上クリックしてから赤い点をクリックすると多角形が作成される。
 * 支点を丸めてみた。
 * 多角形の密度を小さくしてみた。
 */
/*
 * http://actionsnippet.com/?p=2489
 * を参考に作ってみました。
 * 
 * オブジェクトを作って何個載せられるかというゲームにしたかったんですが、
 * ちょっとしたサイズのものでもすぐにバランス崩して倒れてしまうので
 * ゲームとして成立してません。^^;
 * 
 * 重さに対する影響度とか指定できないんでしょうか。
 */

package {
	import flash.display.MovieClip;
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	import com.actionsnippet.qbox.*;
	
	[SWF(backgroundColor="#FFFFFF", frameRate=30)]
	
	public class Main extends MovieClip{
		
		public static const STAGE_Wpx:Number			= 465;
		public static const STAGE_Hpx:Number			= 465;
		public static const STAGE_W:Number				= convPix3D( STAGE_Wpx );
		public static const STAGE_H:Number				= convPix3D( STAGE_Hpx );
		public static const STAGE_CENTER_X:Number		= STAGE_W / 2;
		public static const BASE_SIZE:Number			= Main.convPix3D( 15 );
		public static const TRIANGLE_TOP:Number			= STAGE_H - BASE_SIZE - convPix3D(100);
		public static const TRIANGLE_W:Number			= convPix3D(300);
		
		public static const BASE_COLOR:Number			= 0xbb7744;
		public static const POLY_COLOR:Number			= 0xf1a512;
		
		public static const MODE_READY:String			= "modeReady";
		public static const MODE_CREATE:String			= "modeCreate";
		
		private var $sim:QuickBox2D;
		private var $mode:String;
		private var $points:Array;
		private var $pointSprits:Array;
		private var $bgSp:BGSprite;
		
		/*************************
		 * コンストラクタ
		 */
		public function Main() {
			// ステージのマウス反応
			$bgSp = new BGSprite( this );
			$bgSp.addEventListener( MouseEvent.MOUSE_DOWN, ___onMouseDown );
			
			// QuickBox2D
			$sim = new QuickBox2D( this );
			$sim.setDefault( { lineAlpha:0 } );
			
			$sim.createStageWalls({fillColor:BASE_COLOR});
			// 床を作る
			/*
			$sim.addBox( {
				x:STAGE_CENTER_X, y:STAGE_H - (BASE_SIZE / 2), 
				width:STAGE_W, height:BASE_SIZE,
				fillColor:BASE_COLOR, density:0  });
			*/
			
			// 天秤を作る
			createBalance();
			
			$sim.start();

			$points = [];
			$pointSprits = [];
			
		}
		
		/*************************
		 * 天秤を作る
		 */
		protected function createBalance():void {
			// 中心の△
/*			var triangle:QuickObject = $sim.addPoly( {
				x:STAGE_CENTER_X, y:TRIANGLE_TOP, density:0, fillColor:BASE_COLOR,
				verts:[[
					0, convPix3D(50),
					convPix3D(50),-convPix3D(10),
					convPix3D(100),convPix3D(70),
					-convPix3D(100),convPix3D(70),
					-convPix3D(50),-convPix3D(10)
				]]
			});
*/			
			// 中心の○
			var circle:QuickObject = $sim.addCircle( {
				x:STAGE_CENTER_X, y:TRIANGLE_TOP, radius:convPix3D(30), 
				fillColor:BASE_COLOR, fixedRotation:true, friction:1
			});

			// 天版
			var panel:QuickObject = $sim.addBox( {
				x:STAGE_CENTER_X, y:TRIANGLE_TOP - (BASE_SIZE / 2)-convPix3D(40),
				width:TRIANGLE_W, height:BASE_SIZE, fillColor:BASE_COLOR
			});

			// 接続
/*			$sim.addJoint( {
				type:"revolute", a:triangle.body, b:circle.body,
				collideConnected: false
			} );
*/
		}
		
		/*************************
		 * マウスダウン
		 * 新しいオブジェクトを生成
		 */
		protected function ___onMouseDown( e:MouseEvent ):void {
			$mode = MODE_CREATE;
			
			// ●を作る
			var id:int = $pointSprits.length;
			var sp:PointSprite = new PointSprite( this, id );
			$pointSprits.push( sp );
			
			if ( id == 0 ) {
				sp.addEventListener( MouseEvent.MOUSE_DOWN, ___onClosePoly );
			}
			
			// ポイントリストを登録
			$points.push( [convPix3D(this.mouseX), convPix3D(this.mouseY)] );
		}
		
		/*************************
		 * ポリゴンを閉じる
		 */
		protected function ___onClosePoly( e:MouseEvent ):void {
			var i:int;
			var avgX:Number = 0;
			var avgY:Number = 0;
			var polyPoints:Array = [];
			
			// 座標平均から配置座標を算出
			for ( i = 0; i < $points.length; i++ ) {
				avgX += $points[i][0];
				avgY += $points[i][1];
			}
			
			avgX /= $points.length / 2;
			avgY /= $points.length / 2;
			
			// ポリゴン座標再算出
			for ( i = 0; i < $points.length; i++ ) {
				polyPoints.push(
					Number( $points[i][0] - avgX ).toFixed(2),
					Number( $points[i][1] - avgY ).toFixed(2)
				);
			}
			
			// ポリゴン作成
			try {
				var poly:QuickObject = $sim.addPoly( {
					x:avgX, y:avgY, points:polyPoints, fillColor:POLY_COLOR, density:0.1
				});
			}catch (e:*) {
			}
			
			// 赤丸破棄。ポリゴン作成成功しても失敗しても
			for ( i = 0; i < $pointSprits.length; i++ ) {
				PointSprite( $pointSprits[i] ).destroy();
				$pointSprits[i] = null;
			}
			$pointSprits = [];
			$points = [];
			
			$mode = MODE_READY;
		}
		
		/*************************
		 * 単位換算
		 * QuickBox2Dでは 1px = 30m
		 */
		public static function convPix3D( num:Number ):Number {
			return num / 30;
		}
		
	}

}
import flash.display.*;

/******************************
 * クリックポイントスプライト
 */
class PointSprite extends Sprite {
	
	public static const COLOR:Number		= 0xcc0000;
	public var _id:int;
	
	protected var $stage:DisplayObjectContainer;
	
	/***************************
	 * コンストラクタ
	 */
	public function PointSprite( myStage:DisplayObjectContainer, id:int ) {
		$stage = myStage;
		
		$stage.addChild( this );
		
		this.x = this.parent.mouseX;
		this.y = this.parent.mouseY;
		this.mouseChildren = false;
		
		var color:Number;
		
		if( id==0 ){
			this.mouseEnabled = true;
			this.buttonMode = true;
			color = 0xcc0000;
		}else {
			this.mouseEnabled = false;
			color = 0x00cccc;
		}
		
		// 赤丸
		this.graphics.beginFill( color );
		this.graphics.drawCircle( 0, 0, 4 );
		this.graphics.endFill();
		
		// マウス反応のために大きめにとった透明丸
		this.graphics.beginFill( 0, 0 );
		this.graphics.drawCircle( 0, 0, 10 );
		this.graphics.endFill();
	}

	/***************************
	 * 破棄
	 */
	public function destroy():void {
		$stage.removeChild( this );
		$stage = null;
	}
}

/******************************
 * 背景。拡張するかもなので別クラスにしておく
 */
class BGSprite extends Sprite {
	
	private var $stage:DisplayObjectContainer;
	
	/******************************
	 * コンストラクタ
	 */
	public function BGSprite( myStage:DisplayObjectContainer ) {
		$stage = myStage;
		$stage.addChild( this );
		
		this.graphics.beginFill( 0xaaeeff );
		this.graphics.drawRect( 0, 0, Main.STAGE_Wpx, Main.STAGE_Hpx );
		this.graphics.endFill();
	}
}


