/**
 * Copyright h_sakurai ( http://wonderfl.net/user/h_sakurai )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/t3Kg
 */

package {
	import flash.display.*;
	import flash.events.*;
	import flash.net.*;
	import flash.text.*;

	 public class TextLoader1 extends Sprite {

		private var loader:URLLoader = new URLLoader();// URLローダー
		private var textField:TextField = new TextField(); // テキストフィールド

		public function TextLoader1() {
			textField.width = 465; // テキストフィールドの幅を465に
			textField.height = 465; // 高さを465に
			addChild(textField); // テキストフィールドを表示

			// ロード完了時にatomCompleteを呼び出すように登録する
			loader.addEventListener(Event.COMPLETE, atomComplete);

			// ロード開始
			loader.load(new URLRequest("http://project-nagi.com/test/BLOG-NAME/atom.xml"));

		}

		/**
		 * ロード完了時に呼び出される関数
		 */
		private function atomComplete(event:Event):void {
			default xml namespace = new Namespace("http://www.w3.org/2005/Atom"); // デフォルトのネームスペースを設定

			var xml:XML = new XML(loader.data); // 文字列データからxmlオブジェクトを作成
			var entries:Vector.<Entry> = new Vector.<Entry>; // エントリーの入った配列

			for each (var entry:* in xml.entry) { // xmlのentry要素を取り出してentryに入れてループ
				var content:XML = new XML(""+entry.content); // entry内のcontent要素を取り出してcontent xmlオブジェクト作成
				// 取り出した情報をentries配列に入れる
				entries.push(new Entry(
					entry.title, // タイトル
					entry.published, // 日時
					entry.link.@href, // リンクのURL 属性は@をつけて取り出す
					content.@href, // 画像のURL
					content.img.@width, // 画像の幅
					content.img.@height // 画像の高さ
				));
			}
			callback(entries);// 取り出したデータをコールバック関数に渡す
		}

		/**
		 * データを取得したところ
		 * @param entries 取り出したデータ配列
		 */
		private function callback(entries:Vector.<Entry>):void {

			// entries配列内のオブジェクトをentryに入れてループ
			for each (var entry:Entry in entries) {
				textField.appendText(entry.title+"\n"); // タイトルをテキストフィールドに追加して表示
				textField.appendText(entry.date+"\n"); // 日時
				textField.appendText(entry.href+"\n"); // URL
				textField.appendText(entry.imgurl+" "+entry.width+","+entry.height+"\n") // 画像のURLとサイズ
			}
		}

	}
}
/**
 * エントリー
 */
class Entry {
	public var title:String // タイトル
	public var date:String // 日付
	public var href:String // URL
	public var imgurl:String // 画像url
	public var width:String // 画像幅
	public var height:String // 画像高さ

	/**
	 * コンストラクタ
	 */
	public function Entry(title:String, date:String, href:String, imgurl:String, width:String, height:String) {
		this.title = title
		this.date = date
		this.href = href
		this.imgurl　= imgurl
		this.width = width
		this.height = height	
	}	
}
