/**
 * Copyright Senekis ( http://wonderfl.net/user/Senekis )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/t2tY
 */

package {   

/*
Copyright (C) 2011 Senekis ( http://www.senekis.net | http://www.kongregate.com/accounts/Senekis93 )

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the "Software"), to deal in
the Software without restriction, including without limitation the rights to
use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
of the Software, and to permit persons to whom the Software is furnished to do
so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

------------------------------------------------------------------------------
*/


    import flash.events.MouseEvent; 
    import flash.display.Shape;
    import flash.display.Sprite;
    [SWF(backgroundColor="#000000",width="350",height="350",frameRate="30")] 
    public class Main extends Sprite {
        public function Main() {
            var b:Shape=new Shape();
            b.graphics.beginFill(0);b.graphics.drawRect(0,0,stage.stageWidth,stage.stageHeight);
            addChild(b);            
            addChild(new Generator(350,350));
            stage.addEventListener(MouseEvent.CLICK,click);
        }
        
       private function click(e:MouseEvent):void{    
            removeChild(getChildAt(1));
            addChild(new Generator(350,350,null,(Math.random()*10)+3,Math.random()>0.5,(Math.random()*6)+0.3,(Math.random()*10000)+5000,(Math.random()*7.5)+0.5,Math.random()*.01,Math.random()*30,Math.random()>0.95,Math.random()>0.5,Math.random()>0.5,Math.random()>0.5));
        }
    }
}

import flash.events.Event;
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Graphics;
import flash.display.Sprite;
import flash.filters.BlurFilter;
import flash.geom.ColorTransform;
import flash.geom.Point;
import flash.geom.Rectangle;

   

class Generator extends Sprite{
        //              PRIVATE / PROTECTED ****************************************************************
                           //VARIABLES  
private var
bitmapdata:BitmapData,
canvas:Bitmap,
particles:Vector.<Point>,
point:Point=new Point(),
blur:BlurFilter,
color_transform:ColorTransform=new ColorTransform(),
speed:Number,
rectangle:Rectangle,
color:uint,
colors:Vector.<uint>=new <uint>[0xFFFFFFFF,0xFFFBFF08,0xFFFF00FF,0xFF09FF05,0xFFFF0000,0xFF00FBFF,
                           0xFFFF48100,0xFF9500FF,0xFF00FFFB],
target_r:uint,
target_g:uint,
target_b:uint,
a:uint=255<<24,
r:uint,
g:uint,
b:uint,
current:int=0,
_width:int,
half_width:int,
_height:int,
half_height:int,
increase:Number,
movement_modifier:Number,
movement_change:Boolean,
sinTable:Vector.<Number>,
cosTable:Vector.<Number>,
half_length:int,
y_modifier:Boolean,
x_modifier:Boolean,
distance:Number,
spawn_modifier:Boolean,
direction_modifier:Boolean;
                           //CONSTANTS 
                           
        //              PUBLIC / INTERNAL   ****************************************************************
                           //VARIABLES  

                           //CONSTANTS  
                           
        //                PUBLIC STATIC     ****************************************************************
                          //VARIABLES  
                          
                          //CONSTANTS 
                          
/*CONSTRUCTOR*/public function Generator(
WIDTH:int,
HEIGHT:int,
COLOR_LIST:Vector.<uint>=null,
BLUR:Number=3.0,
BLUR_QUALITY:Boolean=false,
FADING:Number=2.5,
PARTICLES:int=5000,
SPEED:Number=8.0,
DISTANCE:Number=0.1,
MOVEMENT_MODIFIER:Number=0.0,
SPAWN_MODIFIER:Boolean=false,
Y_MODIFIER:Boolean=false,
X_MODIFIER:Boolean=false,
DIRECTION_MODIFIER:Boolean=false):void{
    addEventListener(Event.ADDED_TO_STAGE,go);
    _width=WIDTH,
    half_width=_width*.5,
    _height=HEIGHT,
    half_height=_height*.5,
    movement_modifier=MOVEMENT_MODIFIER,
    speed=SPEED,
    y_modifier=Y_MODIFIER,
    x_modifier=X_MODIFIER,
    distance=DISTANCE,
    spawn_modifier=SPAWN_MODIFIER,
    direction_modifier=DIRECTION_MODIFIER,
    increase=-movement_modifier;
    rectangle=new Rectangle(0,0,_width,_height);
    if(COLOR_LIST)colors=COLOR_LIST;
    bitmapdata=new BitmapData(WIDTH,HEIGHT,true,0xFFFFFFFF);
    particles=new Vector.<Point>(PARTICLES);    
    blur=new BlurFilter(BLUR,BLUR,BLUR_QUALITY?2:1);    
    var random:int=(Math.random()*colors.length)>>0;
    color_transform.alphaOffset=-1000;
    color=color_transform.color=((a|(((colors[random]>>16)&255)<<16)|(((colors[random]>>8)&255)<<8)|colors[random]&255));
    target_r=r=(color>>16)&255,target_g=g=(color>>8)&255,target_b=b=color&255;
    bitmapdata.colorTransform(rectangle,color_transform);
    color_transform.alphaOffset=-FADING;
    canvas=new Bitmap(bitmapdata);    
    addChild(canvas);
    var i:int,tmp:Number,dd:Boolean;
    if(Y_MODIFIER){
        sinTable=new Vector.<Number>((PARTICLES+MOVEMENT_MODIFIER)*2);
        dd=Math.random()>0.5;
        half_length=sinTable.length*.5,i=-1;
        while(++i<half_length){
            tmp=(Math.sin(i));
            sinTable[i]=dd?-tmp:tmp;
            sinTable[i+half_length]=dd?tmp:-tmp;
        }
    }
    if(X_MODIFIER){
        cosTable=new Vector.<Number>((PARTICLES+MOVEMENT_MODIFIER)*2);
        dd=Math.random()>0.5;
        half_length=cosTable.length*.5,i=-1;
        while(++i<half_length){
            tmp=(Math.cos(i));
            cosTable[i]=dd?tmp:-tmp;
            cosTable[i+half_length]=dd?-tmp:tmp;
        }
    }
    i=-1;
    while(++i<PARTICLES)particles[i]=new Point(
    half_width+(X_MODIFIER?cosTable[int(i+increase+half_length)]:Math.cos(i+increase))*speed*i*DISTANCE,
    half_height+(Y_MODIFIER?sinTable[int(i+increase+half_length)]:Math.sin(i+increase))*speed*i*DISTANCE);
}
        /*---------------------------------------------------------------------------------------------*/ 
        //              PRIVATE / PROTECTED ****************************************************************
/*ADDED TO STAGE*/private function go(e:Event):void{
    removeEventListener(Event.ADDED_TO_STAGE,go);
    addEventListener(Event.REMOVED_FROM_STAGE,die);
    addEventListener(Event.ENTER_FRAME,f);
}

/*FRAME*/private function f(e:Event):void{
    bitmapdata.applyFilter(bitmapdata,rectangle,point,blur);
    bitmapdata.colorTransform(rectangle,color_transform);
    bitmapdata.lock();
    var i:int=particles.length,particle:Point;    
    while(--i>-1){
        particle=particles[i];
        particle.setTo(
        particle.x+(x_modifier?cosTable[int(i+increase+half_length)]:Math.cos(i+increase))*(direction_modifier?(i&1)==0?-speed:speed:speed),        
        particle.y+(y_modifier?sinTable[int(i+increase+half_length)]:Math.sin(i+increase))*(direction_modifier?(i&1)==0?-speed:speed:speed)
        );
        if(particle.x<_width)if(particle.x>0)if(particle.y<_height)if(particle.y>0){
            bitmapdata.setPixel32(particle.x,particle.y,color);
            continue;
        }
        particles[i]=spawn_modifier?new Point(half_width+(x_modifier?cosTable[int(i+increase+half_length)]:Math.cos(i+increase))*speed*i*distance,
        half_height+(y_modifier?sinTable[int(i+increase+half_length)]:Math.sin(i+increase))*speed*i*distance):new Point(half_width,half_height);
    }
    bitmapdata.unlock();
    var random:int,current_color:uint;
    if(r==target_r&&g==target_g&&b==target_b){
        do random=(Math.random()*colors.length)>>0;while(random==current);
        current=random;
        current_color=colors[current];
        target_r=(current_color>>16)&255,target_g=(current_color>>8)&255,target_b=current_color&255;
    }
    else{
        if(r<target_r)++r;else if(r>target_r)--r;
        if(g<target_g)++g;else if(g>target_g)--g;
        if(b<target_b)++b;else if(b>target_b)--b;
        color=color_transform.color=(a|(r<<16)|(g<<8)|b);
        if(movement_change){
            if(increase<movement_modifier)increase+=movement_modifier*.01;
            else movement_change=false;
        }
        else{
            if(increase>-movement_modifier)increase-=movement_modifier*.01;
            else movement_change=true;
        }
    }
}

/*REMOVED FROM STAGE*/private function die(e:Event):void{
    removeEventListener(Event.REMOVED_FROM_STAGE,die);
    removeEventListener(Event.ENTER_FRAME,f);
    bitmapdata.dispose();
    bitmapdata=null;
    removeChild(canvas);
    canvas=null;
    particles=null;
    color_transform=null;
    blur=null;
}

        //              PUBLIC / INTERNAL   ****************************************************************

                           
        //                PUBLIC STATIC     ****************************************************************


/*END OF CLASS   class*/}