/**
 * Copyright Makiyivka ( http://wonderfl.net/user/Makiyivka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/t2R6
 */

/*******************************************************************************
 * PushButton Engine
 * Copyright (C) 2009 PushButton Labs, LLC
 * For more information see http://www.pushbuttonengine.com
 * 
 * This file is licensed under the terms of the MIT license, which is included
 * in the License.html file at the root directory of this SDK.
 ******************************************************************************/
package
{
    import com.pblabs.engine.PBE;
    import com.pblabs.engine.entity.*;
    import com.pblabs.rendering2D.*;
    import com.pblabs.rendering2D.ui.*;
    
    import flash.display.Sprite;
    import flash.geom.Point;
    
    public class Lesson2Base extends Sprite
    {
        public function Lesson2Base()
        {
            PBE.startup(this);    // Start up PBE
            
            createScene();
            
            createHero();
        }
        
        private function createScene():void 
        {
            var sceneView:SceneView = new SceneView();
            sceneView.width = 460;
            sceneView.height = 460;
            
            PBE.initializeScene(sceneView);    //This is just a helper function that will set up a basic scene for us
        }
        
        private function createHero():void 
        {
            var hero:IEntity = allocateEntity();    //Allocate the entity for our hero
            
            var spatial:SimpleSpatialComponent = new SimpleSpatialComponent();    //Create our spatial component
            
            spatial.position = new Point(0, 0);    //Set our hero's spatial position
            spatial.size = new Point(50, 50);    //Set our hero's size
            spatial.spatialManager = PBE.spatialManager;
            
            hero.addComponent( spatial, "Spatial");    //Add our spatial component to the Hero entity
            
            var render:SimpleShapeRenderer = new SimpleShapeRenderer();    //Create a renderer to display our object
            render.fillColor = 0x0000FF;    //Make the hero blue
            render.isCircle = true;             
            render.lineSize = 2;
            render.radius = 25;
            render.lineColor = 0x000000;    //Make the hero outline black
            render.scene = PBE.scene;       //Set which scene this renderer belongs to
            
            //point the render component to this entity's Spatial component for position information
            render.positionProperty = new PropertyReference("@Spatial.position");
            //point the render component to this entity's Spatial component for rotation information
            render.rotationProperty = new PropertyReference("@Spatial.rotation");
            
            hero.addComponent(render, "Render");    //Add our render component to the Hero entity with the name 'Render'
            hero.initialize("Hero");                //Register the entity with PBE under the name 'Hero'
        }
    }
}
