/**
 * Copyright yd_niku ( http://wonderfl.net/user/yd_niku )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/t2EQ
 */

// forked from soundkitchen's パァン！
package
{
    import flash.display.BlendMode;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.TimerEvent;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import flash.filters.BitmapFilterQuality;
    import flash.filters.BlurFilter;
    import flash.geom.Point;
    import flash.geom.Matrix;
    import flash.utils.Timer;

    import com.flashdynamix.utils.SWFProfiler;
    import frocessing.color.ColorHSV;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.easing.*;
    import org.libspark.betweenas3.tweens.ITween;

    [SWF(width=465, height=465, frameRate=60, backgroundColor=0x000000)]
    public class Main extends Sprite
    {
        private static var P_ZERO:Point = new Point();
        private static var F_BLUR:BlurFilter = new BlurFilter(4, 4, BitmapFilterQuality.LOW);

        private var _txt:TextField;
        private var _hsv:ColorHSV;
        private var _film:BitmapData;
        private var _timer:Timer;
        private var _activeParticles:Vector.<Particle>;
        private var _inactiveParticles:Vector.<Particle>;
        
        private var _taiga:TaigaLoader;

        public function Main()
        {
            addEventListener(Event.ADDED_TO_STAGE, initialize);
        }

        private function initialize(evt:Event):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, initialize);

            SWFProfiler.init(this);
            
            _taiga = new TaigaLoader();
            _taiga.addEventListener( Event.COMPLETE, loadCompleteHandler );
            _taiga.load();
        }
        private function loadCompleteHandler(e:Event) :void {
            _taiga.removeEventListener( Event.COMPLETE, loadCompleteHandler );
            
            var i:uint,
                fmt:TextFormat,
                bm:Bitmap;

            _activeParticles = new Vector.<Particle>();
            _inactiveParticles = new Vector.<Particle>();
            for (i=0; i<10000; i++)
            {
                _inactiveParticles.push(new Particle());
            }

            _hsv = new ColorHSV(0, 1, 1, 1);

            fmt = new TextFormat();
            fmt.font = "Verdana";
            fmt.bold = true;
            fmt.size = 36;

            _txt = new TextField();
            _txt.defaultTextFormat = fmt;
            _txt.autoSize = TextFieldAutoSize.LEFT;
            _txt.text = "パァン！";

            _film = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0);
            bm = new Bitmap(_film);
            //bm.blendMode = BlendMode.ADD;
            addChild(bm);

            _timer = new Timer(0);
            _timer.addEventListener(TimerEvent.TIMER, timerHandler);
            _timer.start();

            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
        }

        private function enterFrameHandler(evt:Event):void
        {
            var i:uint,
                p:Particle;

            _hsv.h = ++_hsv.h % 360;

            _film.lock();
            _film.applyFilter(_film, _film.rect, P_ZERO, F_BLUR);
            for (i=0; i<_activeParticles.length; i++)
            {
                p = _activeParticles[i];
                p.x += p.vx;
                p.y += p.vy;
                p.life--;

                _film.setPixel32(p.x, p.y, p.color);

                if (!p.life)
                {
                    _activeParticles.splice(i, 1);
                    _inactiveParticles.push(p);
                    i--;
                }
            }
            _film.unlock();
        }

        private function timerHandler(evt:TimerEvent):void
        {
            _timer.delay = (50 + Math.random() * 950) >> 0;

            var sp:Sprite,
                bm:Bitmap,
                bmd:BitmapData,
                t:ITween;

            //_hsv.h = ++_hsv.h % 360;
            _txt.textColor = _hsv.value;

            bmd = new BitmapData( _taiga.data.width/2, _taiga.data.height/2, true, 0);
            bmd.draw( _taiga.data, new Matrix(0.5, 0, 0, 0.5) );

            bm = new Bitmap(bmd);
            bm.smoothing = true;
            bm.x -= bm.width >> 1;
            bm.y -= bm.height >> 1;

            sp = new Sprite();
            sp.addChild(bm);
            sp.x = (Math.random() * stage.stageWidth) >> 0;
            sp.y = (Math.random() * stage.stageHeight) >> 0;
            sp.scaleX = 0;
            sp.scaleY = 0;
            sp.rotation = (Math.random() * 360) >> 0;
            //sp.blendMode = BlendMode.ADD;

            addChild(sp);

            t = BetweenAS3.serial(
                BetweenAS3.to(sp, {
                    'scaleX': 1,
                    'scaleY': 1,
                    'rotation': 0
                }, 2, Expo.easeIn),
                BetweenAS3.removeFromParent(sp)
            );

            t.onComplete = tweenComplete;
            t.onCompleteParams = [sp, bm, bmd];
            t.play();
        }

        private function tweenComplete(sp:Sprite, bm:Bitmap, bmd:BitmapData):void
        {
            var i:uint, j:uint, c:uint,
                cx:Number, cy:Number,
                angle:Number, strength:Number,
                p:Particle;

            cx = sp.x + bm.x;
            cy = sp.y + bm.y;

            for (i=0; i<bmd.width; i++)
            {
                for (j=0; j<bmd.height; j++)
                {
                    c = bmd.getPixel32(i, j);

                    if (!c) continue;

                    p = _inactiveParticles.length ? _inactiveParticles.shift() : new Particle();

                    angle = Math.random() * Math.PI * 2;
                    strength = Math.random() * 20;

                    p.vx = Math.cos(angle) * strength;
                    p.vy = Math.sin(angle) * strength;
                    p.x = cx + i;
                    p.y = cy + j;
                    p.color = c;
                    p.life = 200;

                    _activeParticles.push(p);
                }
            }
            bmd.dispose();
        }
    }
}

class Particle
{
    public var vx:Number;
    public var vy:Number;
    public var x:Number;
    public var y:Number;
    public var color:uint;
    public var life:uint;
}
import flash.events.*;
import flash.display.*;
import flash.system.*;
import flash.net.*;
class TaigaLoader extends EventDispatcher {
    public var data:BitmapData;
    private var _loader:Loader;
    public function TaigaLoader(){
        _loader = new Loader();
        _loader.contentLoaderInfo.addEventListener( Event.COMPLETE, _loaderCompleteHandler );
    }
    private function _loaderCompleteHandler(e:Event):void {
        _loader.contentLoaderInfo.removeEventListener( Event.COMPLETE, _loaderCompleteHandler );
        data = Bitmap(_loader.content ).bitmapData;
        _loader = null;
        dispatchEvent( new Event( Event.COMPLETE ) );
    }
    private var _imgSrc:String = "http://assets.wonderfl.net/images/related_images/e/e9/e9b6/e9b64ead20dd3d674e79ea186b29f974341b480f";
            
    public function load():void {
        var url:URLRequest = new URLRequest( _imgSrc );
        _loader.load( url, new LoaderContext(true) );
    }
}
