/**
 * Copyright blueTeam ( http://wonderfl.net/user/blueTeam )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/t2BD
 */

// forked from ahchang's forked from: forked from: StarsShow
// forked from soundkitchen's forked from: StarsShow
// forked from ahchang's StarsShow
/**
 *  DisplayObject とかには addChild の他に addChildAt ってやつがあるよ。
 *  @see http://tirirenge.undo.jp/?p=1896
 *  FullScreen
 *  @see http://wonderfl.kayac.com/code/d37c1ee9af95c034376daef95073632dbca9ca27
 */
package {    
    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.display.Graphics;
    import flash.display.StageDisplayState;
    
    import flash.geom.Point;    
    import frocessing.color.ColorHSV;
        
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.FullScreenEvent;
    
    [SWF(width="465",height="465",frameRate="30",backgroundColor="0x000000")]
    
    public class StarsShow extends Sprite
    {
        private var sw:Number = stage.stageWidth;
        private var sh:Number = stage.stageHeight;
        private var cx:Number = sw/2;
        private var cy:Number = sh/2;
        private const CORNER:int = 5;
        private const RADIUS1:Number = 50;
        private const RADIUS2:Number = 20;
        private var hsv:ColorHSV;
        
        public function StarsShow()
        {
            stage.addEventListener(MouseEvent.CLICK, clickHandler);           
            drawStar();
        }
        
        private function drawStar():void
        {
            for (var i:int=0; i<25; i++)
            {
                var star:Sprite = new Sprite();
                //star.graphics.lineStyle(0, 0x000000);
                
                hsv = new ColorHSV(0, 1, 1, 1);
                hsv.h = -6*i;
                star.graphics.beginFill(hsv.value, 0.5);
                
                var angle:Number = 2 * Math.PI / CORNER;
                var p1:Point, p2:Point;
                star.graphics.moveTo(RADIUS1, 0);
                                
                for (var j:int=0; j<CORNER; j++)
                {
                    p1 = Point.polar(RADIUS2, angle * (j + 0.1));
                    p2 = Point.polar(RADIUS1, angle * (j + 1));
                    star.graphics.lineTo(p1.x, p1.y);
                    star.graphics.lineTo(p2.x, p2.y);
                }
                
                star.x = cx;
                star.y = cy;
                star.rotation = -90;
                star.scaleX = star.scaleY = 0.2 * i;
                //addChild(star);
                addChildAt(star, 0);
            }
        }
        
        private function clickHandler(event:MouseEvent):void {
            if (stage.displayState == StageDisplayState.NORMAL) {
                stage.displayState = StageDisplayState.FULL_SCREEN;
            }
        }        
    }
}



