/**
 * Copyright argon ( http://wonderfl.net/user/argon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/t1y5
 */

package 
{
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.TimerEvent;
    import flash.filters.BevelFilter;
    import flash.filters.BitmapFilterQuality;
    import flash.filters.BitmapFilterType;
    import flash.filters.DropShadowFilter;
    import flash.utils.Timer;
    
    /**
     * ...
     * @author argon
     */
     
    public class Main extends Sprite 
    {
        private var bg:CreateBG;
        private var ball:CreateBall;
        private var skyBall:CreateBall;
        private var timer:Timer;
        private var ppt:PhysicalPoint;
        private var ballShadow:DropShadowFilter;
        private var ballBevel:BevelFilter;
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.addEventListener(Event.RESIZE, onResizeHandler);
            
            bg=new CreateBG(0,0,stage.stageWidth,stage.stageHeight);
            addChild(bg);
            ball = new CreateBall(stage.stageWidth / 2, stage.stageHeight / 2, 50, 0xffffff, 0 );
            addChild(ball);
            skyBall = new CreateBall(0, 0, 100, 0xFFFF00, 50 );
            addChild(skyBall);
            
            ppt = new PhysicalPoint(stage.stageWidth / 2, stage.stageHeight / 2);
            ballShadow = new DropShadowFilter(0, 0, 0xffffff, .5, 20, 20, 1, BitmapFilterQuality.MEDIUM);
            ballBevel = new BevelFilter(20, 0, 0x000000, 0, 0x939300, .5, 15, 15, 1,
                                           BitmapFilterQuality.MEDIUM, BitmapFilterType.INNER);
            ball.filters = [ballShadow, ballBevel];
            
            timer = new Timer(33);
            timer.addEventListener(TimerEvent.TIMER, loop);
            timer.start();
        }
        
        private function onResizeHandler(e:Event):void
        {
            bg.x=bg.y=0;
            bg.width=stage.stageWidth;
            bg.height=stage.stageHeight;
        }

        
        private function loop(e:TimerEvent):void 
        {
            ppt.setAcceleration((mouseX - ppt.x) * 10, (mouseY - ppt.y) * 10 );
            skyBall.x = ppt.x;
            skyBall.y = ppt.y;
            var angle:Number = Math.atan2(ball.y - skyBall.y, ball.x - skyBall.x) / Math.PI * 180;
            var distance:Number = Math.sqrt(Math.pow(skyBall.x - ball.x, 2)
                                           +Math.pow(skyBall.y - ball.y, 2));
            ballShadow.angle = angle;
            ballShadow.distance = distance/3;
            ballBevel.angle = angle;
            ball.filters = [ballBevel, ballShadow];
        }
        
    }
    
}
import flash.display.MovieClip;
import flash.events.TimerEvent;
import flash.geom.Point;
import flash.utils.Timer;

class PhysicalPoint extends Point
{
    public var vx:Number; 
    public var vy:Number;
    private var ax:Number;
    private var ay:Number;
    private var b:Number;
    private var preTime:Number;
    private var timer:Timer;
    
    public function PhysicalPoint(xx:Number = 0, yy:Number = 0 )
    {
        x = xx; y = yy;
        vx = 0; vy = 0; ax = 0; ay = 0;
        b = .9;
        preTime = new Date().getTime();
        timer = new Timer(33);
        timer.addEventListener(TimerEvent.TIMER, loop);
        timer.start();
    }
    
    private function loop(e:TimerEvent):void
    {
        var nowTime:Number = new Date().getTime();
        var t:Number = (nowTime-preTime) / 1000;
        
        x += vx * t + .5 * ax * t * t;
        y += vy * t + .5 * ax * t * t;        
        vx += ax * t;
        vy += ay * t;        
        vx *= b;
        vy *= b;        
        ax = 0; ay = 0;        
        preTime = nowTime;
    }
    
    public function setAcceleration(aax:Number = 0, aay:Number = 0 ):void
    {
        ax += aax;
        ay += aay;
    }
}

import flash.display.Sprite;
import flash.filters.BitmapFilterQuality;
import flash.filters.BlurFilter;

class CreateBall extends Sprite
{
    private var xx:Number;
    private var yy:Number;
    private var r:Number;
    private var color:uint;
    private var blurNum:Number;
    
    public function CreateBall(_x:Number, _y:Number, _r:Number, _color:uint, _blurNum:Number )
    {
        xx = _x; 
        yy = _y; 
        r = _r; 
        color = _color;
        blurNum = _blurNum;
        
        addCreateBall();
    }
    
    private function addCreateBall():void 
    {
        var sp:Sprite = new Sprite();
        sp.graphics.clear();
        sp.graphics.beginFill(color);
        sp.graphics.drawCircle(xx, yy, r);
        sp.graphics.endFill();
        addChild(sp);
        var blur:BlurFilter = new BlurFilter(blurNum, blurNum, BitmapFilterQuality.MEDIUM);
        sp.filters = [blur];
    }
}

import flash.display.Sprite;

class CreateBG extends Sprite
{
    public function CreateBG(_x:Number,_y:Number,_w:Number,_h:Number):void
    {
        var sp:Sprite=new Sprite();
        sp.graphics.clear();
        sp.graphics.beginFill(0x000000);
        sp.graphics.drawRect(_x,_y,_w,_h);
        sp.graphics.endFill();
        addChild(sp);
    }

}
