/**
 * Copyright Akiyah ( http://wonderfl.net/user/Akiyah )
 * GNU General Public License, v3 ( http://www.gnu.org/licenses/quick-guide-gplv3.html )
 * Downloaded from: http://wonderfl.net/c/t1um
 */

package {
    import flash.display.*;
    import com.actionsnippet.qbox.*;
    import flash.geom.*;
    import flash.events.*;
    import flash.utils.*;
    import Box2D.Dynamics.*;
    import Box2D.Collision.Shapes.*;
    import Box2D.Collision.*;
    import Box2D.Common.Math.b2Vec2;

    import com.demonsters.debugger.MonsterDebugger;

    public class FlashTest extends MovieClip {
        private var sim:QuickBox2D;
        private var contacts:QuickContacts;
        private var circles:Array = [];
        private var cs:Array = [];
        private var other_data:Array;

        public function FlashTest() {
            sim = new QuickBox2D(this, {debug:false});
            sim.createStageWalls();

            var first:QuickObject = sim.addCircle({x:5, y:1, radius:1, fillColor: 0xff0000});
            cs = [[first, 2]];
            
            for (var i:int = 0; i < 10; i++){
                for (var j:int = 0; j < 10; j++){
                    circles.push(sim.addCircle({x:2 + i/2 + j*0.1, y:2 + i/2 + j/2, radius:0.2}));
                }
            }

            sim.start();
            sim.mouseDrag();

            var contacts:QuickContacts = sim.addContactListener();
            contacts.addEventListener(QuickContacts.ADD, function onAdd(evt:Event):void {
                for each (var circle:QuickObject in circles) {
                    for each (var data:Array in cs) {
                        var c:QuickObject = data[0];
                        var l:Number = data[1];
                        if (l > 0) {
                            if (contacts.isCurrentContact(c, circle) || contacts.isCurrentContact(circle, c)) {
                                other_data = [circle, l-1];
                                return;
                            }
                        }
                    }
                }
            });
            addEventListener(Event.ENTER_FRAME, onLoop);
        }

        private function onLoop(evt:Event):void {
            if (other_data != null) {
                var other:QuickObject = other_data[0];
                for each (var data:Array in cs) {
                    var c:QuickObject = data[0];
                    sim.addJoint({a:c.body, b:other.body, collideConnected:false});
                }
                cs.push(other_data);
                other_data = null;
            }
        }
    }
}