/**
 * Copyright Saqoosha ( http://wonderfl.net/user/Saqoosha )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/t1mE
 */

package {

    import com.bit101.components.HUISlider;
    import com.bit101.components.VBox;

    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.events.Event;
    
    
    /**
     * @author Saqoosha
     * @see http://radiumsoftware.tumblr.com/post/10719023826
     * @see http://www.johndcook.com/blog/2010/01/20/how-to-compute-the-soft-maximum/
     */
    [SWF(backgroundColor="0xffffff", frameRate="30", width="465", height="465")]
    public class SoftMaximum extends Sprite {
        
        
        private static const W:int = 233;
        
        
        private var _softness:HUISlider;
        private var _max:HUISlider;
        private var _min:HUISlider;
        
        
        public function SoftMaximum() {
            x = y = W;
            scaleY = -1;
            
            var vbox:VBox = new VBox(stage, 10, 10);
            _max = new HUISlider(vbox, 0, 0, 'MAX', _draw);
            _max.width = 300;
            _max.minimum = 0;
            _max.maximum = 300;
            _max.value = 100;
            _max.tick = 1;
            _max.labelPrecision = 0;
            _min = new HUISlider(vbox, 0, 0, 'MIN', _draw);
            _min.width = 300;
            _min.minimum = -300;
            _min.maximum = 0;
            _min.value = -100;
            _min.tick = 1;
            _min.labelPrecision = 0;
            _softness = new HUISlider(vbox, 0, 0, 'SOFTNESS', _draw);
            _softness.width = 300;
            _softness.minimum = 1;
            _softness.maximum = 100;
            _softness.value = 20;
            _softness.tick = 0.1;
            _softness.labelPrecision = 1;
            
            _draw();
        }
        
        
        private function _draw(e:Event = null):void {
            var g:Graphics = graphics,
                x:int,
                min:Number = _min.value,
                max:Number = _max.value,
                k:int = _softness.value;
                
            g.clear();
            g.lineStyle(0, 0x0, 0.3);
            g.moveTo(-W, 0);
            g.lineTo(W, 0);
            g.moveTo(0, -W);
            g.lineTo(0, W);
            
            g.lineStyle();
            for (x = -W; x <= W; x += 2) {
                g.beginFill(0x5758ff, 0.5);
                g.drawCircle(x, Math.max(min, Math.min(x, max)), 1);
                g.endFill();
                g.beginFill(0xff3d79, 0.5);
                g.drawCircle(x, softMax(min, softMin(x, max, k), k), 1);
                g.endFill();
            }
        }
        
        
        public function softMax(x:Number, y:Number, k:Number = 1):Number {
            x /= k;
            y /= k;
            var max:Number = Math.max(x, y);
            var min:Number = Math.min(x, y);
            return (max + Math.log(1.0 + Math.exp(min - max))) * k;
        }


        public function softMin(x:Number, y:Number, k:Number = 1):Number {
            x /= k;
            y /= k;
            var max:Number = Math.max(x, y);
            var min:Number = Math.min(x, y);
            return (max - Math.log(1.0 + Math.exp(max - min))) * k;
        }
    }
}
