/**
 * Copyright kenz ( http://wonderfl.net/user/kenz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/t1T0
 */

package
{
    import flash.display.BlendMode;
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Point;
    
    import frocessing.display.F5MovieClip2DBmp;
    
    [SWF( width="465", height="465", frameRate="60", backgroundColor="0" )]
    
    public class index extends F5MovieClip2DBmp
    {
        private const ZERO_POINT:Point = new Point();
        
        
        private var _t:Number;
        private var _eff1:F5MovieClip2DBmp;
        private var _eff2:F5MovieClip2DBmp;
        private var _mat:Matrix;
        private var _filter:BlurFilter;
        private var _cTra:ColorTransform;
        private var _x:int;
        private var _y:int;
        private var _range:int;
        private var _offset:Array;
        
        
        
        
        public function index()
        {
            super();
        }
        
        
        
        
        /**
         * setup
         *
         */
        public function setup():void
        {
            size( stage.stageWidth, stage.stageHeight );
            background( 0, 0, 0, 0 );
            
            noFill();
            colorMode( HSV, 2, 1, 1, 1 );
            
            _eff1 = new F5MovieClip2DBmp();
            _eff1.size( stage.stageWidth + 20, stage.stageHeight + 20 );
            _eff1.background( 0, 0, 0, 0 );
            _eff1.x = _eff1.y = -10;
            _eff1.blendMode = BlendMode.ADD;
            addChild( _eff1 );
            
            _eff2 = new F5MovieClip2DBmp();
            _eff2.size( stage.stageWidth + 20, stage.stageHeight + 20 );
            _eff2.visible = false;
            addChild( _eff2 );
            
            _mat = new Matrix();
            _mat.translate( 10, 10 );
            _filter = new BlurFilter( 16, 16 );
            _cTra = new ColorTransform( 1, 1, 1, .99 );
            
            _t = Math.random() * 4 | 0;
            _x = 0;
            _y = stage.stageHeight;
            _range = stage.stageWidth * 4;
            _offset = [ new Point(), new Point() ];
        }
        
        
        /**
         * draw
         * 
         */
        public function draw():void
        {
            _x = noise( .25, _t ) * _range - ( _range >> 1 ) | 0;
            
            stroke( _t, 1, 1, 1 );
            beginShape();
            line( _x, _y, _x + _y, _y - _y );
            endShape();
            
            _eff1.bitmapData.draw( bitmapData, _mat );
            _eff1.bitmapData.applyFilter( _eff1.bitmapData, _eff1.bitmapData.rect, ZERO_POINT, _filter );
            
            _eff2.bitmapData.perlinNoise( 100, 100, 2, 0, false, false, 0, true, _offset );
            _offset[0].x--;
            _offset[1].y++;
            
            _eff1.bitmapData.draw( _eff2, null, null, BlendMode.SUBTRACT );
            _eff1.bitmapData.scroll( 4, -4 );
            
            bitmapData.colorTransform( bitmapData.rect, _cTra );
            
            _t += .01;
        }
    }
}
