/**
 * Copyright okoi ( http://wonderfl.net/user/okoi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/t1DK
 */

//
//    擬似球面体
//
package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Rectangle;
    
    [SWF(width = "465", height = "465")]
    
    /**
     * ...
     * @author okoi
     */
    public class Main extends Sprite 
    {
        private var _canvas:BitmapData;
        
        private var _dots:/*Dot*/Array;
        
        private static const SPHERE_RADIUS:int = 200;
        private static const SPHERE_PATHNUM_Y:int = 20;
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            _canvas = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0);
            addChild( new Bitmap(_canvas) );
            
            InitSphere();
            
            addEventListener(Event.ENTER_FRAME, Update);
        }
        
        private function InitSphere():void 
        {
            _dots = new Array();
            
            for ( var py:int = 0; py < SPHERE_PATHNUM_Y; py++ )
            {
                var defy:Number = stage.stageHeight/2 - Math.cos( py / SPHERE_PATHNUM_Y * 180 * Math.PI / 180 ) * SPHERE_RADIUS;
                for ( var px:int = 0; px < 36; px++ )
                {
                    var radius:Number = SPHERE_RADIUS * Math.sin((py / SPHERE_PATHNUM_Y) * 180 * Math.PI / 180);
                    var angle:Number = 360 * (px / 36);
                    trace(angle);
                    var dot:Dot = new Dot(stage.stageWidth / 2, defy, radius, angle );
                    _dots[_dots.length] = dot;
                }
            }
        }
        
        private    function Update(e:Event):void 
        {
            var i:int;
            
            var dotnum:int = _dots.length;
            for ( i = 0; i < dotnum; i++ )
            {
                _dots[i].Update( 0.5 );
            }
            
            _canvas.lock();
            _canvas.fillRect( _canvas.rect, 0 );
            for ( i = 0; i < dotnum; i++ )
            {
                var size:Number = 8 + _dots[i].cos * 3;
                _canvas.fillRect( new Rectangle( _dots[i].x - size/2, _dots[i].y - size/2, size, size ), 0xFF000000 );
            }
            _canvas.unlock();
        }
    }
    
}

class Dot {
    
    private var _defx:Number;
    private var _defy:Number;
    
    private var _x:Number;
    private var _y:Number;
    private var _z:Number;
    public    function get x():Number { return    _x;    }
    public    function get y():Number { return    _y;    }
    public    function get z():Number { return    _z;    }
    
    private var _radius:Number;
    private var _angle:Number;
    
    private var _cos:Number;
    public    function get cos():Number { return    _cos;    }
    
    public function Dot (__defx:Number, __defy:Number,__radius:Number,__angle:Number) {
            
        _defx = __defx;
        _defy = __defy;
        _x = 0;
        _y = 0;
        _radius = __radius;
        _angle = __angle;
        
        UpdatePosition();
    }
    
    public function Update(rot:Number):void 
    {
        _angle = (_angle + rot) % 360;
        _cos = Math.cos( _angle * Math.PI / 180 );
        
        UpdatePosition();
    }
    
    private function UpdatePosition() : void 
    {
        _x = _defx + Math.sin( _angle * Math.PI / 180 ) * _radius;
        if ( _radius == 0 )
        {
            _y = _defy;
            _z = 0;
        }else
        {
            _y = _defy + Math.cos( _angle * Math.PI / 180 ) * 5;
            _z = Math.cos( _angle * Math.PI / 180 ) * _radius;    
        }
    }
}