/**
 * Copyright kenji_clown5 ( http://wonderfl.net/user/kenji_clown5 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/t17N
 */

// forked from kenji_clown5's flash on 2011-5-16
/*
* 多重ホーミングレーザーっぽいもの
* 弾道ブレ率を変えることでくねくねバージョンに
* 
* http://twitter.com/#!/kenji_clown5
--------------------------------------------------*/
package    {
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    
    import net.hires.debug.Stats;
    
    [SWF(width = "465", height = "465", frameRate = "60", backgroundColor = "0x000000")]    
    public class Main extends Sprite    {
        // DisplayObject
        public static var laserSP:Sprite = new Sprite();
        
        public function Main()    {
            addChild(laserSP);
            addChild(new Stats());
            
            stage.addEventListener(MouseEvent.MOUSE_MOVE, laserFire);
        }
        
        private function laserFire(e:MouseEvent):void    {
            var myLaser:Lasers = new Lasers();
            laserSP.addChild(myLaser);
        }
    }
}

/*
* レーザー生成class
--------------------------------------------------*/
import flash.display.*;
import flash.events.Event;
import flash.geom.Point;

class Lasers extends Sprite    {
    // DisplayObject
    private var bombSp:Sprite = new Sprite();  // 爆発エフェクトSprite
    
    // 調整変数
    private const firstLength:uint = 50;  // 最初の接線距離
    private const spd:Number = 0.3;  // 加速度
    private const bureRate:Number = 0.2;  // 弾道ブレ率
    
    private var startPoint:Point;  // 発射地点
    private var endPoint:Point;  // 着弾点
    private var laserPoint:Point;  // 曲線の始点終点
    private var controlPoint1:Point = new Point();  // コントロールポイント1
    private var controlPoint2:Point = new Point();  // コントロールポイント2
    private var dis:Number;  // 着弾点までの距離
    private var bure:Number;  // 弾道ブレ幅max
    private var rndColor:Number;  // 曲線の色
    
    public function Lasers()    {
        startPoint = new Point(Math.ceil(Math.random() * 465), 465);  // 発射地点
        laserPoint = startPoint;
        
        // コントロールポイント1
        controlPoint1.x = startPoint.x;
        controlPoint1.y = 465 - firstLength;
        
        rndColor = Math.ceil(Math.random() * 0xffffff);  // 曲線カラーをランダムに
        
        this.addEventListener(Event.ENTER_FRAME, dlawLine);
    }
    
    // 曲線描画
    private function dlawLine(e:Event):void    {
        endPoint = new Point(mouseX, mouseY);  // 着弾点
        dis = Point.distance(laserPoint, endPoint);  // 着弾点までの距離
        bure = dis * bureRate;  // 弾道ブレ幅max
        
        // 始点と終点の角度
        var kaku:Number = Math.atan2(endPoint.y - laserPoint.y, endPoint.x - laserPoint.x) + Math.PI / 2;
        // 弾道のブレ幅
        var dx:int = Math.floor((Math.random() * bure - bure / 2) * Math.cos(kaku));
        var dy:int = Math.floor((Math.random() * bure - bure / 2) * Math.sin(kaku));
        
        // コントロールポイント2
        controlPoint2.x = controlPoint1.x + (endPoint.x - controlPoint1.x) * spd + dx;
        controlPoint2.y = controlPoint1.y + (endPoint.y - controlPoint1.y) * spd + dy;
        
        var sp:Sprite = new Sprite();  // 曲線一本分のSprite
        sp.graphics.lineStyle(2, rndColor, 1);
        sp.graphics.moveTo(laserPoint.x , laserPoint.y);
        
        if (dis < 15)
        // 着弾
        {
            // 曲線描画
            sp.graphics.curveTo(controlPoint1.x, controlPoint1.y, endPoint.x, endPoint.y);
            this.removeEventListener(Event.ENTER_FRAME, dlawLine);
            setBomb();  // 爆発へ
        }
        // 着弾してない
        else {
            // 次の終点
            laserPoint.x = controlPoint1.x + (controlPoint2.x - controlPoint1.x) / 2;
            laserPoint.y = controlPoint1.y + (controlPoint2.y - controlPoint1.y) / 2;
            
            // 曲線描画
            sp.graphics.curveTo(controlPoint1.x, controlPoint1.y, laserPoint.x, laserPoint.y);
            
            // コントロールポイントの更新
            controlPoint1.x = controlPoint2.x;
            controlPoint1.y = controlPoint2.y;
        }
        
        addChild(sp);
        sp.addEventListener(Event.ENTER_FRAME, delLine);
    }
    
    // 端から消していく
    private function delLine(e:Event):void    {
        e.currentTarget.alpha -= 0.08;
        if (e.currentTarget.alpha < 0)    {
            e.currentTarget.alpha = 0;
            e.currentTarget.removeEventListener(Event.ENTER_FRAME, delLine);
            removeChild(DisplayObject(e.currentTarget));
        }
    }
    
    // 爆発
    private function setBomb():void    {
        bombSp.graphics.beginFill(rndColor, 1);
        bombSp.graphics.drawCircle(0, 0, 5);
        bombSp.x = endPoint.x;
        bombSp.y = endPoint.y;
        addChild(bombSp);
            
        bombSp.addEventListener(Event.ENTER_FRAME, effectBomb);
    }
    
    // 爆発エフェクト
    private function effectBomb(e:Event):void    {
        bombSp.scaleX += (4 - bombSp.scaleX) * 0.1;
        bombSp.scaleY += (4 - bombSp.scaleY) * 0.1;
        bombSp.alpha -= 0.04;
        if (bombSp.alpha < 0)    {
            bombSp.alpha = 0;
            bombSp.removeEventListener(Event.ENTER_FRAME, effectBomb);
            removeChild(bombSp);
        }
    }
}