/**
 * Copyright moni ( http://wonderfl.net/user/moni )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/t0yf
 */

// forked from break's flash on 2010-11-16
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.net.URLLoader;
    import flash.net.URLRequest;
    
    /*
     * テンプレ
     * JAM Session5 のフィードをパースして全ての画像を読み込むだけ
     */
    
    [SWF(width="500", height="465")]
    public class Main extends Sprite {
        
        /** */
        private static const XML_PATH:String = "http://assets.wonderfl.net/static/assets/session5/cbcnet_feed.xml";
        private var articles:Vector.<Article>;
        
        private var loadingCounter:int;
        
        public function Main():void {
            this.addEventListener(Event.ADDED, init);
        }
        
        private function init(e:Event = null):void {
            this.removeEventListener(Event.ADDED, init);
            
            /* init */
            this.articles = new Vector.<Article>();
            this.loadingCounter = -1;
            
            var loader:URLLoader = new URLLoader();
            loader.addEventListener(Event.COMPLETE, loaded);
            loader.load(new URLRequest(XML_PATH));
            
            function loaded(e:Event):void {
                e.target.removeEventListener(e.type, arguments.callee);
                parse(new XML(loader.data));
            }
        }
        
        private function parse(data:XML):void {
            for each (var item:XML in data.descendants(Syntax.ITEM)) {
                this.articles.push(new Article(item));
            }
            
            this.loading();
        }
        
        private function loading(...rest):void {
            if (++loadingCounter > articles.length - 1) loadComplete();
            else articles[loadingCounter].load(this.loading);
        }
        
        private function loadComplete():void {
            for (var i:int = 0; i < articles.length; i++) {
                var img:Bitmap = trimming(articles[i].img,
                    new Rectangle(
                        articles[i].img.width / 2,
                        articles[i].img.height / 2,
                        stage.stageWidth / (articles.length),
                        stage.stageHeight
                    )
                );
                img.x = i * (img.width);
                this.addChild(img);
            }
        }
        
        private function trimming(source:Bitmap, rect:Rectangle):Bitmap {
            var value:BitmapData = new BitmapData(rect.width, rect.height);
            value.copyPixels(source.bitmapData, rect, new Point());
            
            return new Bitmap(value);
        }
    }
}

import flash.display.Bitmap;
import flash.display.Loader;
import flash.events.Event;
import flash.net.URLRequest;
import flash.system.LoaderContext;


interface IArticle {
    function load(handle:Function):void;
}

class Article implements IArticle {
    private var title:String;
    private var link:String;
    private var guid:String;
    private var pubDate:Date;
    private var category:String;
    private var tags:/*String*/Array
    private var description:String;
    private var image:String;
    
    private var _img:Bitmap;
    public function get img():Bitmap { return _img; }
    
    public function Article(node:XML) {
        this.title    = (Syntax.TITLE in node) ? node.elements(Syntax.TITLE) : "";
        this.link     = (Syntax.LINK in node) ? node.elements(Syntax.LINK) : "";
        this.guid     = (Syntax.GUID in node) ? node.elements(Syntax.GUID) : "";
        this.image     = (Syntax.IMAGE in node) ? node.elements(Syntax.IMAGE) : "";
        this.category = (Syntax.CAT in node) ? node.elements(Syntax.CAT) : "";
        this.description =    (Syntax.DESCTIPTION in node) ? node.elements(Syntax.DESCTIPTION) : "";
        
        this.pubDate = (Syntax.PUB_DATE in node) ? new Date(node.elements(Syntax.PUB_DATE)) : null;
        this.tags = (Syntax.TAG in node) ? node.elements(Syntax.TAG).toString().split(",") : [];
    }
    
    private var loader:Loader;
    
    public function load(handle:Function):void {
        loader = new Loader();
        loader.contentLoaderInfo.addEventListener(Event.COMPLETE, loaded);
        loader.load(new URLRequest(this.image), new LoaderContext(true));
        
        function loaded(e:Event):void {
            e.target.removeEventListener(e.type, arguments.callee);
            _img = Bitmap(loader.content);
            
            handle.apply();
        }
    }
    
}

/* enum */
class Syntax {
    
    public static const ITEM:String = "item";
    
    /* elements */
    public static const TITLE:String = "title";
    public static const LINK:String = "link";
    public static const GUID:String = "guid";
    public static const PUB_DATE:String = "pubDate";
    public static const CAT:String = "category";
    public static const TAG:String = "tag";
    public static const DESCTIPTION:String = "description";
    public static const IMAGE:String = "image";
}
