/**
 * Copyright chabudai ( http://wonderfl.net/user/chabudai )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/t0hE
 */

package {
	import flash.display.Sprite;
	import flash.events.Event;
	import org.papervision3d.cameras.Camera3D;
	import org.papervision3d.materials.ColorMaterial;
	import org.papervision3d.render.BasicRenderEngine;
	import org.papervision3d.scenes.Scene3D;
	import org.papervision3d.view.Viewport3D;
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.objects.primitives.Plane;
	
	[SWF(backgroundColor="#EEEEEE", frameRate=30)]
	
	public class Main extends Sprite {
		private var camera:Camera3D;
		private var scene:Scene3D;
		private var viewport:Viewport3D;
		private var renderer:BasicRenderEngine;
		private var _plane1:Plane;
		private var _plane2:Plane;
		private var _container:DisplayObject3D;
		private var _num:Number = 0;
		private var _a:Number = 0.05;
		
		public function Main() {
			scene = new Scene3D();
			viewport = new Viewport3D(465, 465, true, true);
			renderer = new BasicRenderEngine();
			camera = new Camera3D();
			addChild(viewport);
			init();
		}
		
		private function init():void {
			var material:ColorMaterial = new ColorMaterial(0x000000);
			material.oneSide = false;
			
			//普通のPlane
			_plane1 = new Plane(material, 300, 300);
			_plane1.x = -300;
			_plane1.useOwnContainer = true;
			scene.addChild(_plane1);
			
			//入れ子にしたPlane
			_container = new DisplayObject3D();
			_plane2 = new Plane(material, 300, 300);
			_plane2.x = 300;
			_plane2.useOwnContainer = true;
			scene.addChild(_container);
			_container.addChild(_plane2);
			
			//↓この一行をコメントアウトするとalphaが指定できるようになる
			_container.useOwnContainer = true;
			
			addEventListener(Event.ENTER_FRAME, renderHandler);
		}
		
		private function renderHandler(e:Event):void {
			_plane1.rotationY += 2;
			_plane2.rotationY += 2;
			
			//透明度を変える
			_plane1.alpha = _num;
			_plane2.alpha = _num;
			//_containerはalpha効く
			//_container.alpha = _num
			
			_num += _a;
			if (_num > 1) {
				_a = -0.05;
			}else if (_num < 0) {
				_a = 0.05;
			}
			renderer.renderScene(scene, camera, viewport);
		}
		
	}
}