/**
 * Copyright hankuro ( http://wonderfl.net/user/hankuro )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/szxU
 */

package 
{
import flash.display.Bitmap;
	import flash.display.* ;
	import flash.events.*;

	[SWF(width=340, height=260, backgroundColor=0xFFFFFF)]
	
	/**
	 *  
	 * drawTrianglesにて日本国旗をたなびかしてみました。
	 * 　　たなびかす座標計算が納得できていないので、x=0,x=10のy座標が求められず同じ値になっているので見た目がおかしい。
	 * 　　今後、座標計算の解析、及びスピードアップ化を図りたい。
	 *  ちなみに、vertices,indices,uvtData計算ロジックは「drawTrianglesとUVマッピング #3」さんから借用
	 *    http://www.scratchbrain.net/blog/ver2/entries/000900.html 
	 * 
	 */
	public class Main extends Sprite 
	{
		public var vertices:Vector.<Number>;
		public var indices:Vector.<int>;
		public var uvtData:Vector.<Number>;
		
		public var sh:Shape = new Shape();
		public var bm_data:BitmapData;
		
		private const DIV_w:int = 30;
		private const DIV_h:int = 20;
	
		public var i:Number,
				   j:Number,
				   stepW:Number, // 幅
				   stepH:Number; // 高さ
		
		public var m_x:Number = 0;
		public var m_y:Number = 0;
		
		public var num:Number = 0;
		
		public var y_set:Number;
		public var yy_set:Number;
			
		public function Main():void 
		{
			var japan:Shape = new Shape();
			japan.graphics.lineStyle(3, 0xDCDCDC);
			japan.graphics.beginFill(0xFFFFFF, 1);
			japan.graphics.drawRect(0, 0, 298, 198);
			japan.graphics.endFill();
			japan.graphics.beginFill(0xFF0000, 1);
			japan.graphics.drawCircle(150, 100, 60);
			japan.graphics.endFill();
			bm_data = new BitmapData(300, 200);
			bm_data.draw(japan);
			stepW = 300 / DIV_w, // 幅
			stepH = 200 / DIV_h;// 高さ
			sh.x = 20
			sh.y = 30;
			addChild(sh);
			addEventListener(Event.ENTER_FRAME, onLoop);
		}
		public function onLoop(evt:Event):void {
			var stepInd:Number = 0;
			num++;
			vertices = new Vector.<Number>();
			indices = new Vector.<int>();
			uvtData = new Vector.<Number>();
			sh.graphics.clear();
			for(i = 0; i<DIV_h; i++ ){
				// 横方向のループ
				for(j = 0; j<DIV_w; j++ ){
				// 頂点の座標データセット
				y_set =  Math.sin(j / Math.PI + num / DIV_w ) * DIV_h;
				if (j == 0) yy_set = y_set;
				vertices.push(
								j * stepW, i * stepH +  yy_set ,       					// 頂点 0（左上） 
								(j + 1) * stepW, i * stepH + y_set ,	        		// 頂点 1（右上）
								(j + 1) * stepW, (i + 1) * stepH + y_set ,		    	// 頂点 2（右下）
								j * stepW,	(i + 1) * stepH +  yy_set);					// 頂点 3（左下)
				// 描画の順序データセット
				yy_set =  Math.sin(j / Math.PI + num / DIV_w ) * 20;
				indices.push(stepInd,stepInd+1,stepInd+3,stepInd+1,stepInd+2,stepInd+3);
				stepInd += 4;
				// UVマッピングデータセット
				uvtData.push(
								j / DIV_w,	     										//頂点 0（左上）U
								i / DIV_h,	     										// V
								(j+1) / DIV_w,	 										//頂点 1（右上）U
								i / DIV_h,	     										// V
								(j+1) / DIV_w,	 										//頂点 2（右下）U
								(i+1) / DIV_h,	 										// V
								j/DIV_w,		 										//頂点 3（左下）U
								(i+1) / DIV_h);	 										// V
				}
			}
			sh.graphics.beginBitmapFill(bm_data);
			sh.graphics.drawTriangles(vertices,indices,uvtData);
			sh.graphics.endFill();
		}
	}
}
