/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sywa
 */

// forked from tepe's forked from: flash on 2013-3-26
// forked from tepe's flash on 2013-3-26
package{
    import flash.display.*;
    import flash.filters.GlowFilter;
    import flash.system.*;
    import flash.text.*;
    import flash.net.*;
    import flash.media.*;
    import flash.events.*;
    import flash.geom.Matrix;
    import org.libspark.betweenas3.BetweenAS3;
    import net.wonderfl.utils.FontLoader;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.easing.*;
    import org.libspark.betweenas3.tweens.ITween;
    
    public class Main extends Sprite{
        //システムカラー
        private const color1:uint = 0x223388;//青
        private const color2:uint = 0x44aaff;
        //動画リクエストサイズ
        private const WIDTH:int = 300;
        private const HEIGHT:int = 225;
        
        private var par:Number;//再生進捗率
        private var t1:Number = 0;//動画の終了時間
        private var sndUrl:URLRequest = new URLRequest("http://192.168.11.7/sound/a.mp3");
        private var snd:Sound = new Sound(sndUrl);
        
        private var players:Array;
        private var videoState:int = -1;//プレイヤー状態
        //youtube動画ID
        private var movie:Array = [ "kZAIwipsxo8","MGt25mv4-2Q","W58Il5l_D5s","6m2zV8Adhmk","", 
                                    "geUeWJfoLJE","2LUgH_X7sFM","ZhrrshPdwSg","ulNmPKGnlaA","bqdDN59Ytjc", 
                                    "G3C-VevI36s","hmf7Px7J-pM","HzOdzvzios8","1uX4ge0-4vQ","gtx-qq1Ix5A",
                                    "fPN3Tnn2AaY","KXT91di0VFk","o0N3BTqB_lo"];//,
                                    
                                    //"uuPV8pAkuR0","uGES_ZON9no","qMni8-7uOFA","bKRRMVmhiLM","Pww2DcqozN4",
                                    //"sXHoLsg7qDU","bD4BspAfX1Q" ];
        private var i:int = 0;
        private var seekWidth:Number = WIDTH;//シークバーの幅
        private var list:Array = new Array();//タイミングのリスト
        private var codeList:Array;
        //セーブデータ
        private var so:SharedObject;
        private var saveData:Object;
        
        private var player:Object;//youtubeプレイヤー
        
        private var seekBar:Sprite = new Sprite();//シークバー
        private var line:Sprite = new Sprite();//タイミングライン
        private var timeLine:Sprite = new Sprite();//タイムライン
        //デバッグテキスト
        private var txt:TextField = new TextField();
        private var txt2:TextField = new TextField();
        private const tl:Number = 200;//タイムラインが流れる速さを調整 
        private var lx:Number = 70;//タイミングラインの位置
        private var score:int =0;//得点
        private var combo:int=0;//コンボ数
        private var miss:int=0;//ミス回数　※入力できなかった文字数
        
        private var repeat:Boolean = false;
        private var shuffle:Boolean = true;
        
        private var timeIn:Number=2;//入力受付開始時間
        
        private var charCnt:int=0;//次のタイピング文字
        
        private var movieNum:int=0;//再生動画選択
                
        public static const FONT:String = "Bebas";
        public static const EMBED:Boolean = true;
        
        
        private var kb:KeyBoardBtn = new KeyBoardBtn();
        
        //コンストラクタ
        public function Main(){
            var fontLoader:FontLoader = new FontLoader();
            fontLoader.addEventListener(Event.COMPLETE, init);
            fontLoader.load(Main.FONT);
            movieNum = Math.floor(Math.random()*movie.length);
        }
        
        private function init(e:Event=null):void{
            stage.addChild(kb);
            kb.x = 5; kb.y = 330;
            kb.scaleX = 1.2;//kb.scaleY = 1.2;
            
            loadUserData();
            var _flashBody:Sprite = new Sprite();
            _flashBody.graphics.beginFill(0x000000);
            _flashBody.graphics.drawRect(-10, -10, 485, 485);
            _flashBody.graphics.endFill();
            addChild(_flashBody);
            _flashBody.addEventListener(MouseEvent.CLICK, onKey);
            
            //stage.addEventListener(MouseEvent.CLICK,onKey);
            //new ScoreIndicator(stage,0,0,"test");

            txt2.textColor = color2;
            txt.textColor = color2;
            txt.selectable = false;
            //txt2.selectable= false;
            txt.width = 300;
            txt2.height = 300;
            txt2.text = "";
///*return; 
            var loader:Loader;
            loader = new Loader();
            loader.name = i.toString();
            loader.contentLoaderInfo.addEventListener(Event.INIT, onLoaderInit);
            const req:String = "http://www.youtube.com/apiplayer?enablejsapi=1&version=3";
            loader.load(new URLRequest(req));//youtubeプレイヤー読み込み
//*/ 
            stage.addEventListener(Event.ENTER_FRAME,onFrame);
            
            //バックグラウンドカラー
            with(graphics){
                beginFill(0x000000); 
                drawRect(-400,0,1400,460);
                endFill();
            }
            
            //キーボード入力
            stage.addEventListener(KeyboardEvent.KEY_DOWN,onKey);
            stage.addEventListener(KeyboardEvent.KEY_UP,offKey);
            
            //stage.addChild(txt); 
            //stage.addChild(txt2);//ログ
            txt.y = 200;
            
            stage.addChild(timeLine);//タイムライン配置
            
        }
        
        //エンターフレーム
        private function onFrame(event:Event):void{
            txt.text = String.fromCharCode(charList[charCnt]);
            var seek:Number = player.getCurrentTime();//先頭からの経過時間
            txt.appendText("\n"+seek.toString());
            par = (seek / t1);//再生進捗率更新
            //txt.appendText("\n"+list[charCnt].toString());
            txt.appendText("\n\nscore:"+score.toString());
            txt.appendText("\nsave.score:"+saveData.score.toString());
            txt.appendText("\ncombo:"+combo.toString());
            txt.appendText("\nmiss:"+miss.toString());
            txt.appendText("\nexp:"+saveData.exp.toString());
            //txt.appendText("\n"+(list[charCnt]-player.getCurrentTime()).toString());
            draw1();
            timeLine.x = -seek*tl+lx-50;//タイムライン移動
            
            //有効文字を追加
            for(var i:int=0;i<20;i++){
                var n:int = charCnt+i;
                if(list[list.length-1]<seek)break;//最後の文字を過ぎていたらスルー
                if(list.length<=n)break;
                if(seek+timeIn<list[n])break;
                if(textList[n].textColor == color2){ 
                    setKey(charList[n],true);
                    continue;
                }
                if(textList[n].textColor != 0xffffff){ 
                    textList[n].textColor = color2;
                    setKey(charList[n],true);
                    break;
                }
                
            }
            if(list[charCnt] < seek){ 
                if(list[list.length-1]<seek && charCnt == 0){ 
                    if(1000 < t1-seek)return;
                    if(combo==list.length){
                        new ScoreIndicator(stage,150,150,"parfect!",0xffff00,0xaaaa00,50);
                        combo=0;
                    }
                    else if(99<combo){
                        combo=0;
                        new ScoreIndicator(stage,150,150,"great!",0xffff00,0xaaaa00,50);
                    }
                    else if(49<combo){
                        combo=0;
                        new ScoreIndicator(stage,150,150,"good job!",0xffff00,0xaaaa00,50);
                    }
                    


                    return;
                }
                if(textList[charCnt].textColor==color2){ 
                    textList[charCnt].textColor = 0x000000;
                    setKey(charList[charCnt],false);
                    combo=0;
                    miss++;
                }
                charCnt++;
                charCnt%=list.length;
                //textList[charCnt].textColor = color2;
                //textList[charCnt].alpha = 1;
                
                 
            }
            
        }
        //タイムラインを自動生成する
        private function createTimeline(ti:Number,min:Number=0.5,max:Number=3,stTime:Number=5,lastTime:Number=0.5):int{
            txt2.appendText("createTimeline:\n"+ti.toString()+"\n");
            var ti2:Number = stTime;
            var ti3:Number = 0;//前回の文字出現時間
            list = new Array();
            while(ti2<ti){
                //txt2.appendText(ti2.toString()+"\n");
                var add:Number = Math.random()*max;
                add *= 1000;
                add = Math.floor(add);
                add /= 1000;
                ti2 += add;
                if(ti3+min < ti2 && ti2<ti-lastTime){ 
                    list.push(ti2);
                    ti3=ti2;
                    //txt2.appendText("["+(list.length-1).toString()+"]"+list[list.length-1].toString()+"\n");
                    //txt2.scrollV = txt2.maxScrollV;
                }

            }
            list.sort(Array.NUMERIC);  
            return list.length;

        }

        
        //シークバー描画
        private function draw1():void{
            
            with(seekBar.graphics){1
                clear();
                beginFill(color1,0.7);
                drawRect(0,0,seekWidth,10);
                endFill();
                
                beginFill(color2,0.5);
                drawRect(0,0,seekWidth*par,10);
                endFill();
                
            }
        }
        
        //データロード
        private function loadUserData():void{
            so = SharedObject.getLocal("userdata");
            if(so){
               var obj : Object = so.data;
               if(obj.hasOwnProperty("exp") == false) obj.exp = 0;
               if(obj.hasOwnProperty("score") == false) obj.score = 0;
               saveData = obj;
               score = obj.score;
               
               
            }
        }
        
        
        private var charList:Array;//タイピングコードの配列
        private var textList:Array;//表示文字の配列
        private function setKeyCode():void{
            var len:int = list.length;
            charList = new Array();
            textList = new Array();
            var i:int;
            for(i=0;i<len;i++) charList.push(rndChar());            
            for(i=0;i<len;i++) createStr(String.fromCharCode(charList[i]), list[i]);
        }
        
        //表示文字生成
        private function createStr(str:String,timestamp:Number,fontSize:int=50):void{
                var c:TextField = new TextField();//表示文字
                var c2:TextField = new TextField();//グローフィルター用
                var base:Sprite = new Sprite();//ベース
                
                //テキスト設定
                var tf:TextFormat = new TextFormat();//テキストフォーマット
                tf.size = fontSize;//サイズ
                tf.bold = true;//太字
                c.defaultTextFormat = c2.defaultTextFormat = tf;//フォーマット適用
                c.text = c2.text = str;
                c.textColor = 0x000000; //フォントカラー
                c2.selectable = c.selectable= false;//文字選択無効
                
                //グローフィルター設定
                var glow:GlowFilter = new GlowFilter(color1, 0.7, 13, 13, 5, 5, false, true);
                c2.filters = [glow];
                
                base.addChild(c); 
                base.addChild(c2);
                base.x = timestamp*tl;//タイムラインの位置
                base.y = Math.random()*HEIGHT;
                textList.push(c);
                timeLine.addChild(base);//タイムラインに配置
                
        } 

        
        //private var 
        //キーボード入力
        private function onKey(e:KeyboardEvent):void{
            if(Capabilities.hasIME)IME.enabled = false;//IME無効
            if(e.keyCode==244)stage.addChild(txt2);
            if(e.keyCode==32){//space
                //new ScoreIndicator(stage,WIDTH/2,150,"test",0xffff00,0xaaaa00,30); 
                onPause();
            }

            //表示されている文字のどれかに適合すればOK。一番手前のものから調べる
            for(var j:int=0;j<20;j++){
                var n2:int = charCnt+j;
                if(timeIn < list[n2]-player.getCurrentTime())break;
                var a:Boolean = checkKey(charList[n2],e.keyCode,e.charCode,e.shiftKey);
                if(a == true && textList[n2].textColor != 0xffffff){
                    textList[n2].textColor = 0xffffff;
                    textList[n2].alpha = 0.9;
                    //charCnt++;
                    //charCnt%=list.length;
                    setKey(charList[n2],false);
                    combo++;
                    saveData.exp++;
                    score+=combo*10;
                    saveData.score = score;
                    var pt:int = combo;
                    const c1:uint = 0xffffff; const c2:uint = 0xaaaaff;
                    new ScoreIndicator(stage,60,290,pt.toString(),c1,c2,30);
                    new ScoreIndicator(stage,100,290,"hit",c1,c2,30);
                    new ScoreIndicator(stage,400,290,"    "+score.toString(),0xaaaff,0x0000ff,20);
                    
                    if(combo==10){
                        new ScoreIndicator(stage,WIDTH/2,150,"10  combo",0xffff00,0xaaaa00,30);
                        saveData.exp += 10;
                    }
                    else if(combo==20){
                        new ScoreIndicator(stage,WIDTH/2,150,"20  combo",0xffff00,0xaaaa00,30);
                        saveData.exp += 20;
                    }
                    else if(combo==30){
                        new ScoreIndicator(stage,WIDTH/2,150,"30  combo",0xffff00,0xaaaa00,30);
                        saveData.exp += 30;
                    }
                    else if(combo==40){
                        new ScoreIndicator(stage,WIDTH/2,150,"40  combo",0xffff00,0xaaaa00,30);
                        saveData.exp += 40;
                    }
                    else if(combo==50){
                        new ScoreIndicator(stage,WIDTH/2,150,"50  combo",0xffff00,0xaaaa00,40);
                        saveData.exp += 500;
                    }
                    else if(combo%100 == 0){
                        new ScoreIndicator(stage,WIDTH/2,150,combo.toString()+"  combo",0xffff00,0xaaaa00,40);
                        saveData.exp += combo*10;
                    }
                    
                    
                    if(combo==list.length){
                        new ScoreIndicator(stage,150,150,"full combo",0xffff00,0xaaaa00,50);
                        saveData.exp += combo*50;
                        combo=0;
                    }
                    
                    

                    return;
                }

            }
            combo=0;
        }
        
        //キーリリース
        private function offKey(e:KeyboardEvent):void{
            kb.text = "";
            //textList[charCnt].textColor = color2;
            //textList[charCnt].alpha = 1;
        } 
        
        //ローダー初期化
        private function onLoaderInit(event:Event):void{
            const scale:Number =1.4;
            const w:Number = WIDTH*scale;
            const h:Number = HEIGHT*scale;
            seekWidth = w;
            var loader:Loader = event.currentTarget.loader;
            loader.content.addEventListener("onReady", onPlayerReady);
            loader.content.addEventListener("onStateChange",onChangeState);
            
            loader.scaleX = scale;
            loader.scaleY = scale;
            loader.x = (stage.stageWidth - w)/2;
            //loader.y = (stage.stageHeight - h)/2;
            
            addChild(loader);
            stage.addEventListener(MouseEvent.MOUSE_DOWN,onPause);
            
            
        }
        
        //リトライ
        private function retry():void{
            player.seekTo(0);//先頭に移動
            charCnt=0;
            miss=0;
            combo=0;
            for(var i:int=0;i<list.length;i++){
                textList[i].textColor = 0x000000;
            }
        }

        //動画準備
        private function reloadMovie():void{
            //saveData.score = score;
                if(repeat == true)retry();//リトライ
                if(shuffle == true){
                    movieNum = Math.floor(Math.random()*movie.length);//動画をランダムで選択
                    player.clearVideo();
                    player.cueVideoById(movie[movieNum]);//動画ID
                    txt2.appendText(movie[movieNum]); 
                    player.playVideo();//再生
                    t1 = 0;
                    while(timeLine.numChildren > 0){  
                        timeLine.removeChildAt(0);
                    }
                    retry();
                }
        }

        
        //ステータス変化
        private function onChangeState(e:Event):void{
            
            var date:Date = new Date();
            videoState = player.getPlayerState()
            
            var str:String = new String();
            str += date.getHours().toString() +":";
            str += date.getMinutes().toString()+":";
            str += date.getSeconds().toString()+" ";
            txt2.appendText(str); 
            txt2.appendText("change:"+videoState.toString()+"\n");
            
            
            txt2.scrollV = txt2.maxScrollV;
            if(videoState == -1){//削除動画？
                //txt2.appendText("削除動画?\n"+movie[movieNum]+"\n");
                
                
            }
            if(videoState == 0){//終了
                reloadMovie();                
            }
            else if(videoState == 1){
                if(t1 == 0){
                    t1 = player.getDuration();
                    createTimeline(t1,0.9,2.5);
                    //createTimeline(t1,0.1,1.5);
                    setKeyCode();
                }
                t1 = player.getDuration(); 

            }
            else if(videoState == 3){
                txt2.appendText("loading.....\n");
            }

            else if(videoState == 5){//頭出し済み  
                init2();
                timeOut = new Date();
            } 
        }
        
        private var timeOut:Date;
        private function onTimeCnt(e:Event):void{
            var now:Date = new Date();
            if(timeOut.time + 5000 < now.time){
                txt2.appendText("timeOut\n");
                txt2.appendText(movie[movieNum]);
                reloadMovie();
                stage.removeEventListener(Event.ENTER_FRAME,onTimeCnt);
                
            }
            if(videoState == 1)stage.removeEventListener(Event.ENTER_FRAME,onTimeCnt); 

        }

        private function init2():void{
            timeOut = new Date();
            stage.addEventListener(Event.ENTER_FRAME,onTimeCnt);
            const scale:Number =1.4;
            const w:Number = WIDTH*scale;
            const h:Number = HEIGHT*scale;
            seekWidth = w;
            //txt2.appendText("init2\n");
            //load();
            
            seekBar.x=(stage.stageWidth - w)/2;
            seekBar.y=h-20;
            var seekGlow:Shape = new Shape();
            seekBar.addChild(seekGlow);
            seekGlow.graphics.beginFill(0x000000);
            seekGlow.graphics.drawRect(0,0,seekWidth,10);
            seekGlow.graphics.endFill();
            var glow:GlowFilter = new GlowFilter(color1, 0.4, 4, 8, 2, 4, false, true);
            seekGlow.filters =  [glow]
            //stage.addChild(seekBar);
                
            kb.getKey("32").setLight(true);
            kb.getKey("32").setColor(0x004400);
            kb.getKey("32").text = "PAUSE";
            //txt.y = (stage.stageHeight - h)/2+h-80;
            
                
        }
        
        
        
        //一時停止
        private function onPause(e:MouseEvent=null):void{
            txt2.appendText("onPause\n");
            videoState = player.getPlayerState();
            if(videoState == 1){ 
                player.pauseVideo();
                new ScoreIndicator(stage,WIDTH/2,180,"pause",0xffff00,0xaaaa00,30);
                kb.getKey("32").setColor(0x00ff00);
                kb.getKey("32").setLight(true);
                kb.getKey("32").text = "START";
            }
            else if(videoState == 2){ 
                player.playVideo(); 
                new ScoreIndicator(stage,WIDTH/2,180,"start",0xffff00,0xaaaa00,30);
                //kb.getKey("32").setLight(false);
                kb.getKey("32").setColor(0x004400);
                kb.getKey("32").text = "PAUSE";
            }
        }

        
        
        //プレイヤー設定
        private function onPlayerReady(event:Event):void{
            player = event.currentTarget;
            player.setSize(WIDTH, HEIGHT);//サイズ
            player.cueVideoById(movie[movieNum]);//動画ID
            //player.cueVideoById(movie[7]);//動画ID
            player.playVideo();//再生
            //players.push(player);//配列に追加
            //t1 = player.getDuration();
            txt2.appendText("onPlayerReady:\n"+"t1:"+t1.toString()+"\n");
            txt2.scrollV = txt2.maxScrollV;
        }
        
        
        
//-------------------------------------------------------------------------------------        
        //文字変更
        private function rndChar(level:int=1):int{
            var code:int;
            //文字設定
            var rnd:int =Math.random()*5;
            /*if(4<level){//全文字出題
                code = Math.random()*(126-33)+33;
                
            }
            else*/ if(3<level && Math.random()<0.2){//記号
                rnd = Math.floor(Math.random()*4);
                if(rnd == 0) code =     Math.floor(Math.random()*15) +33;//記号1
                else if(rnd == 1)code = Math.floor(Math.random()*7 ) +58;//記号2
                else if(rnd == 2)code = Math.floor(Math.random()*6 ) +91;//記号3
                else code =             Math.floor(Math.random()*4 )+123;//記号4
            }///*            
            else if(2<level && Math.random()<0.5){//数字
                code = Math.random()*10+48;
            }            
            else if(1<level && Math.random()<0.3){//大文字
                code = Math.random()*26+65;
            }            
            else{
                code = Math.random()*26+97;//小文字
            }//*/
            return code;
            
        }


        private function selectKey(name:String,select:Boolean=true,color:uint=0xaaaaff):void{
            //keys.push(name);
            kb.getKey(name).setColor(color);
            kb.getKey(name).setLight(select);
            
        }
        

        //入力ガイド
        private function setKey(CODE:int,onLight:Boolean):void{
            
            //resetKey();
            var code:int;
            
            //小文字
            if(97<=CODE && CODE<=122){
                selectKey(String(CODE-32),onLight);// a-z
                return;
            }
            //大文字
            else if(65<=CODE && CODE<=90){
                selectKey("16",onLight); selectKey("shift",onLight);
                selectKey(String(CODE),onLight);// A-Z
                return;

            }
            //数字
            else if(47<CODE && CODE<58){
                selectKey(String(CODE),onLight);// 0-9
                return;
            }
            //記号
            else{
                if(33<=CODE && CODE<=41){// ! " # $ % & ' ( )
                    selectKey(String(CODE+16),onLight);
                }
                else if(42<=CODE && CODE<=47){// * + , - . / 
                    selectKey(String(CODE+144),onLight);
                }
                else if(58<=CODE && CODE<=64){// : ; < = > ? @
                    selectKey(String(CODE+128),onLight);
                }
                // [ \ ] ^ _ `
                else if(CODE==91)selectKey("219",onLight);
                else if(CODE==92){selectKey("220");selectKey("226",onLight);}
                else if(CODE==93)selectKey("221",onLight);
                else if(CODE==94)selectKey("222",onLight);
                else if(CODE==95)selectKey("226",onLight);
                else if(CODE==96)selectKey("192",onLight);
                // { | } ~
                else if(CODE==123)selectKey("219",onLight);
                else if(CODE==124)selectKey("220",onLight);
                else if(CODE==125)selectKey("221",onLight);
                else if(CODE==126)selectKey("222",onLight);

                //　shiftキー
                if(33<=CODE && CODE<=43){// ! " # $ % & ' ( ) * + 
                    selectKey("16",onLight); selectKey("shift",onLight);
                }
                else if(60<=CODE && CODE<=63){// < = > ?
                    selectKey("16",onLight); selectKey("shift",onLight);
                }
                else if(CODE==95 || CODE==96){// _ `
                    selectKey("16",onLight); selectKey("shift",onLight);
                }
                else if(123<=CODE && CODE<=126){// { | } ~
                    selectKey("16",onLight); selectKey("shift",onLight);
                }
                
                return;
            }

        }
        
        /*
        * CODE:正解コード　keyCode:入力キー charCode:入力文字コード shiftKey:シフトキー
        */
        private function checkKey(CODE:int,keyCode:int,charCode:int,shiftKey:Boolean):Boolean{
            var code:int = 0;//キーコード
            
            if(CODE == charCode){
                return true;
            }
            //記号１
            else if(33<=CODE && CODE<=47){
               
                if(CODE == 33 && shiftKey==true)code=49;// !
                else if(CODE == 34 && shiftKey==true)code=50;// "
                else if(CODE == 35 && shiftKey==true)code=51;// #
                else if(CODE == 36 && shiftKey==true)code=52;// $
                else if(CODE == 37 && shiftKey==true)code=53;// %
                else if(CODE == 38 && shiftKey==true)code=54;// &
                else if(CODE == 39 && shiftKey==true)code=55;// '
                else if(CODE == 40 && shiftKey==true)code=56;// (
                else if(CODE == 41 && shiftKey==true)code=57;// )
                else if(CODE == 42 && shiftKey==true)code=186;// *
                else if(CODE == 43 && shiftKey==true)code=187;// +
                else if(CODE == 44 && shiftKey==false)code=188;// ,
                else if(CODE == 45 && shiftKey==false)code=189;// -
                else if(CODE == 46 && shiftKey==false)code=190;// .
                else if(CODE == 47 && shiftKey==false)code=191;// /
                if(code == keyCode)return true;
                return false;
            }
            //記号２
           else if(57<CODE && CODE<65){
               
                if(CODE == 58 && shiftKey==false)code=186;// :
                else if(CODE == 59 && shiftKey==false)code=187;// ;
                else if(CODE == 60 && shiftKey==true)code=188;// <
                else if(CODE == 61 && shiftKey==true)code=189;// =
                else if(CODE == 62 && shiftKey==true)code=190;// >
                else if(CODE == 63 && shiftKey==true)code=191;// ?
                else if(CODE == 64 && shiftKey==false)code=192;// @
                
                if(code == keyCode) return true;
                return false; 
            }
            //記号３
            else if(91<=CODE && CODE<=96){
                if(CODE == 91 && shiftKey==false)code=219;// [
                else if(CODE == 92 && shiftKey==false)code=226;// \
                else if(CODE == 93 && shiftKey==false)code=221;// ]
                else if(CODE == 94 && shiftKey==false)code=222;// ^
                else if(CODE == 95 && shiftKey == true)code=226;// _
                else if(CODE == 96 && shiftKey == true)code=192;// `
                else code = 0;
                if(keyCode == code) return true; 
                else if(CODE==92 && shiftKey==false){
                    if(keyCode == 226 || keyCode == 220) return true;
                }
                return false; 
            }
            //記号４
            else if(122<CODE && CODE<127){
                if(CODE == 123 && shiftKey == true)code=219// {
                if(CODE == 124 && shiftKey == true)code=220// |
                if(CODE == 125 && shiftKey == true)code=221// }
                if(CODE == 126 && shiftKey == true)code=222// ~

                if(code == keyCode)return true;
                return false; 
            }
            
 
            return false;
        }
    }
}
// -----------------------------------------------------------------------------------------

// ScoreIndicator

// -----------------------------------------------------------------------------------------

//package {

    import flash.display.*;

    import flash.events.Event;

    import flash.text.TextField;

    import org.libspark.betweenas3.BetweenAS3;

    import org.libspark.betweenas3.easing.*;

    import org.libspark.betweenas3.tweens.ITween;

    

    //public

    class ScoreIndicator extends Sprite {

        private var _chars:Vector.<TextField>;

        private var _charIndex:int;

        private var _numCompleted:int;

        //private var color1:uint = 0x0000ff;

        private var color1:uint = 0xffffff;

        //private var color2:uint = 0x00007f;

        private var color2:uint = 0xaaaaff;

        private var _size:Number;

        

        public function ScoreIndicator(parent:DisplayObjectContainer, centerX:int, bottomY:int, text:String,

                            c1:uint=0xffffff,c2:uint=0xaaaaff,size:Number=50) {

            parent.addChild(this);

            this.mouseEnabled = false;

            x = centerX;

            y = bottomY;

            _size = size;

            

            _chars = new Vector.<TextField>();

            _charIndex = 0;

            _numCompleted = 0;

            

            splitText(text);//文字列を文字に分割

            alignChars();

            playTween();

            

            addEventListener(Event.ENTER_FRAME, checkEveryTweenCompleted);

        }

        

        //文字列分割

        private function splitText(text:String):void {

            //this.scaleX = 2;

            //this.scaleY = 2;

            // 文字のスタイルを設定する

            var builder:TextBuilder = new TextBuilder();

            builder.autoCorrect(false).autoSize().bold();

            

            //カラー設定

            //var dmg : Number = Number(text);

            //var c : uint = 256 * (1 - dmg / 10000);

            //builder.font(Main.FONT, Main.EMBED).fontColor(color1 | c<<8 | c).fontSize(50);

            builder.font(Main.FONT, Main.EMBED).fontColor(color1).fontSize(_size);

//            builder.textBorder(true, 0x404040, 2, 4);

            //var d : uint = c / 2;

            //builder.textBorder(true, color2 | d<<8 | d, 10, 20);

            builder.textBorder(true, color2, 10, (_size/6));

           

            for (var i:int = 0; i < text.length; i++) {

                _chars.push(builder.build(text.charAt(i)));

            }

        }

        

        private function alignChars():void {

            var i:int, charsWidth:Number = 0;

            

            for (i = 0; i < _chars.length; i++) {

                charsWidth += _chars[i].textWidth;

            }

            

            if(_chars[0]){

                _chars[0].x = -int(charsWidth / 2);

                _chars[0].y = -_chars[0].textHeight;

            }

            

            for (i = 1; i < _chars.length; i++) {

                _chars[i].x = _chars[i - 1].x + _chars[i - 1].textWidth;

                _chars[i].y = -_chars[i].textHeight;

            }

        }

        

        //モーショントゥイーン

        private function playTween(event:Event = null):void {

            if (event) { removeEventListener(Event.ENTER_FRAME, playTween); }

            

            var char:TextField = _chars[_charIndex++];

            addChild(char);

            

            // 各文字に適用するトゥーイン

            var tween:ITween = BetweenAS3.bezierTo(char, { y: char.y }, { $y: -(char.textHeight * 2) }, 0.3, Sine.easeInOut);

            tween.onComplete = tweenCompleteHandler;

            tween.play();

            

            if (_charIndex < _chars.length) {

                addEventListener(Event.ENTER_FRAME, playTween);

            }

        }

        

        //

        private function tweenCompleteHandler():void {

            _numCompleted++;

        }

        

        private function checkEveryTweenCompleted(event:Event):void {

            if (_numCompleted == _chars.length) {

                removeEventListener(Event.ENTER_FRAME, checkEveryTweenCompleted);

                BetweenAS3.serial(

                    BetweenAS3.to(this, { alpha: 0 }, 2.3, Quint.easeInOut),

                    BetweenAS3.removeFromParent(this)

                ).play();

            }

        }

    }

//}


// -----------------------------------------------------------------------------------------

// TextBuilder
/// -----------------------------------------------------------------------------------------
//package {
    import flash.filters.GlowFilter;
    import flash.text.*;
    
    //public
    class TextBuilder {
        public static const ALIGN_LEFT:String = "left";
        public static const ALIGN_RIGHT:String = "right";
        public static const ALIGN_CENTER:String = "center";
        
        private var _posX:Number;
        private var _posY:Number;
        
        private var _width:Number;
        private var _height:Number;
        
        private var _background:Boolean;
        private var _backgroundColor:uint;
        
        private var _border:Boolean;
        private var _borderColor:uint;
        
        private var _fontName:String;
        private var _embedFonts:Boolean;
        private var _advancedAntiAlias:Boolean;
        
        private var _fontSize:int;
        private var _fontColor:uint;
        private var _bold:Boolean;
        
        private var _textBorder:Boolean;
        private var _textBorderColor:uint;
        private var _textBorderBlur:Number;
        private var _textBorderStrength:Number;
        
        private var _align:String;
        private var _autoSizeEnabled:Boolean;
        private var _autoCorrectPositionY:Boolean;
        private var _wordWrap:Boolean;
        
        public function TextBuilder() {
            clear();
        }
        
        public function clear():TextBuilder {
            _posX = 0;
            _posY = 0;
            _width = 100;
            _height = 100;
            _background = false;
            _backgroundColor = 0xffffff;
            _border = false;
            _borderColor = 0x000000;
            _fontName = "Arial";
            _embedFonts = false;
            _advancedAntiAlias = false;
            _fontSize = 12;
            _fontColor = 0x000000;
            _bold = false;
            _textBorder = false;
            _textBorderColor = 0xffff00;
            _textBorderBlur = 4;
            _textBorderStrength = 2;
            _align = TextBuilder.ALIGN_LEFT;
            _autoSizeEnabled = false;
            _autoCorrectPositionY = true;
            _wordWrap = false;
            return this;
        }
        
        public function position(x:Number, y:Number):TextBuilder {
            _posX = x;
            _posY = y;
            return this;
        }
        
        public function size(width:Number, height:Number):TextBuilder {
            _width = width;
            _height = height;
            return this;
        }
        
        public function background(enabled:Boolean, color:uint = 0xffffff):TextBuilder {
            _background = enabled;
            _backgroundColor = color;
            return this;
        }
        
        public function border(enabled:Boolean, color:uint = 0x000000):TextBuilder {
            _border = enabled;
            _borderColor = color;
            return this;
        }
        
        public function font(name:String, embed:Boolean = false, advancedAntiAlias:Boolean = false):TextBuilder {
            _fontName = name;
            _embedFonts = embed;
            _advancedAntiAlias = advancedAntiAlias;
            return this;
        }
        
        public function fontSize(size:int):TextBuilder {
            _fontSize = size;
            return this;
        }
        
        public function fontColor(color:uint):TextBuilder {
            _fontColor = color;
            return this;
        }
        
        public function bold(enabled:Boolean = true):TextBuilder {
            _bold = enabled;
            return this;
        }
        
        public function textBorder(enabled:Boolean, color:uint = 0xffff00, blur:Number = 4, strength:Number = 2):TextBuilder {
            _textBorder = enabled;
            _textBorderColor = color;
            _textBorderBlur = blur;
            _textBorderStrength = strength;
            return this;
        }
        
        public function align(value:String = TextBuilder.ALIGN_LEFT):TextBuilder {
            _align = value;
            return this;
        }
        
        public function autoSize(enabled:Boolean = true):TextBuilder {
            _autoSizeEnabled = enabled;
            return this;
        }
        
        public function autoCorrect(positionY:Boolean = true):TextBuilder {
            _autoCorrectPositionY = positionY;
            return this;
        }
        
        public function wordWrap(enabled:Boolean = true):TextBuilder {
            _wordWrap = enabled;
            return this;
        }
        
        public function build(text:String):TextField {
            var textField:TextField = new TextField();
            
            textField.x = _posX;
            textField.y = _posY;
            textField.width = _width;
            textField.height = _height;
            
            var format:TextFormat = new TextFormat(_fontName, _fontSize, _fontColor, _bold);
            if (_autoSizeEnabled) {
                switch(_align) {
                    case TextBuilder.ALIGN_LEFT: { textField.autoSize = TextFieldAutoSize.LEFT; break; }
                    case TextBuilder.ALIGN_RIGHT: { textField.autoSize = TextFieldAutoSize.RIGHT; break; }
                    case TextBuilder.ALIGN_CENTER: { textField.autoSize = TextFieldAutoSize.CENTER; break; }
                }
            }else {
                switch(_align) {
                    case TextBuilder.ALIGN_LEFT: { format.align = TextFormatAlign.LEFT; break; }
                    case TextBuilder.ALIGN_RIGHT: { format.align = TextFormatAlign.RIGHT; break; }
                    case TextBuilder.ALIGN_CENTER: { format.align = TextFormatAlign.CENTER; break; }
                }
            }
            
            textField.embedFonts = _embedFonts;
            textField.antiAliasType = (_advancedAntiAlias ? AntiAliasType.ADVANCED : AntiAliasType.NORMAL);
            textField.defaultTextFormat = format;
            textField.text = text;
           
            if (textField.background = _background) { textField.backgroundColor = _backgroundColor; }
            if (textField.border = _border) { textField.borderColor = _borderColor; }
            if (_textBorder) { textField.filters = [new GlowFilter(_textBorderColor, 1, _textBorderBlur, _textBorderBlur, _textBorderStrength)]; }
            if (!(textField.wordWrap = _wordWrap) && _autoCorrectPositionY) { textField.y += Math.max(0, Math.ceil((_height - (textField.textHeight + 4)) / 2)); }
            textField.mouseEnabled = textField.selectable = false;
            
            return textField;
        }
        
        public function clone():TextBuilder {
            var clone:TextBuilder = new TextBuilder();
            clone._posX = _posX;
            clone._posY = _posY;
            clone._width = _width;
            clone._height = _height;
            clone._background = _background;
            clone._backgroundColor = _backgroundColor;
            clone._border = _border;
            clone._borderColor = _borderColor;
            clone._fontName = _fontName;
            clone._embedFonts = _embedFonts;
            clone._advancedAntiAlias = _advancedAntiAlias;
            clone._fontSize = _fontSize;
            clone._fontColor = _fontColor;
            clone._bold = _bold;
            clone._textBorder = _textBorder;
            clone._textBorderColor = _textBorderColor;
            clone._textBorderBlur = _textBorderBlur;
            clone._textBorderStrength = _textBorderStrength;
            clone._align = _align;
            clone._autoSizeEnabled = _autoSizeEnabled;
            clone._autoCorrectPositionY = _autoCorrectPositionY;
            clone._wordWrap = _wordWrap;
            return clone;
        }
    }
//}





/////////////////////////////////////////////////////////

//    キーボード表示

/////////////////////////////////////////////////////////

import flash.system.*;

import flash.events.*;
import flash.filters.GlowFilter;
import flash.ui.*;

class KeyBoardBtn extends Sprite{

    private var btn:Btn;

    

    private var _caps:Boolean = false;

    private var _alt:Boolean = false;

    private var _ctrl:Boolean = false;

    private var _shift:Boolean = false;

    

    private var keyList:Array = new Array();

    private var keyLength:int;//キーの数

    private var _color1:uint = 0x0000ff;

    private var _color2:uint = 0x000000;//キーボードベースカラー

    

    public var _charset1:String = " 1234567890-^￥qwertyuiop@[asdfghjkl;:]zxcvbnm,./\\";

    public var _charset2:String = " !\"#$%&'() =~|QWERTYUIOP`{ASDFGHJKL+*}ZXCVBNM<>?_"; 

    private var _text:String = new String();

    

    

    public function KeyBoardBtn():void{

        addEventListener(Event.ADDED_TO_STAGE, init);

    }

    

    

    private function init(e:Event=null):void{        

        //var keyName:String;

        var i:int;

        //グローフィルター設定
/*
        var glow:GlowFilter = new GlowFilter(0x0055ff, 0.7, 5, 5, 2, 5, false, true);
        var base:Sprite = new Sprite();
        base.filters = [glow];
        with(base){
            graphics.beginFill(_color2);
            graphics.drawRoundRect(-5,-5,384,130,5);
            graphics.endFill();
        }
        addChild(base);
*/


        // BackSpace

        btn = new Btn();

        btn.name = "8";

        btn.x = 355;        btn.y = 0;

        btn.text = "Bs"; 

        

        addChild(btn);

        keyList.push(btn);

        btn.addEventListener(MouseEvent.MOUSE_DOWN,function():void{

            _text = _text.substr(0,_text.length-1);

        });

       

        // Tab

        btn = new Btn(30);

        btn.name = "9";

        btn.x = 0;        btn.y = 25;

        btn.text = "Tab"; 

        addChild(btn);

        keyList.push(btn);

        btn.addEventListener(MouseEvent.MOUSE_DOWN,function():void{

            _text += "\t";

        });

        

        // Enter

        btn = new Btn(30,45);

        btn.name = "13";

        btn.x = 345;        btn.y = 25;

        btn.text = "Enter"; 

        addChild(btn);

        keyList.push(btn);

        btn.addEventListener(MouseEvent.MOUSE_DOWN,function():void{

            _text += "\r";

        });

 

        // Caps Lock

        btn = new Btn(40);

        btn.name = "240";

        btn.x = 0;        btn.y = 50;

        btn.text = "Caps"; 

        addChild(btn);

        keyList.push(btn);

        

        // Shift (左)    

        btn = new Btn(54);

        btn.name = "16";

        btn.x = 0;        btn.y = 75;

        btn.text = "Shift"; 

        addChild(btn);

        keyList.push(btn);

        btn.addEventListener(MouseEvent.MOUSE_DOWN,function():void{

            if(_shift==false){

                shift = true;

                getKey("16").setLight(true);

            }

            else{ 

                shift = false;

                getKey("shift").setLight(false);

                getKey("16").setLight(false);

            }

            

        });

        

        // Shift (右)

        btn = new Btn(40);

        btn.name = "shift";

        btn.x = 335;        btn.y = 75; 

        btn.text = "Shift"; 

        addChild(btn);

        keyList.push(btn);

        btn.addEventListener(MouseEvent.MOUSE_DOWN,function():void{

            if(_shift==false){

                shift = true;

                getKey("shift").setLight(true);

            }

            else{ 

                shift = false;

                getKey("shift").setLight(false);

                getKey("16").setLight(false);

            }

        });

      

        // Ctrl (左)

        btn = new Btn(30);

        btn.name = "17";

        btn.x =0;        btn.y = 100;

        btn.text = "Ctrl";

        addChild(btn);

        keyList.push(btn);

        btn.addEventListener(MouseEvent.MOUSE_DOWN,function():void{

            if(_ctrl==false){

                _ctrl = true;

                getKey("17").setLight(true);

            }

            else{ 

                _ctrl = false;

                getKey("ctrl").setLight(false);

                getKey("17").setLight(false);

            }

        });

        

        // Ctrl (右)

        btn = new Btn(30);

        btn.name = "ctrl";

        btn.x =345;        btn.y =100;

        btn.text = "Ctrl";

        addChild(btn);

        keyList.push(btn);

        btn.addEventListener(MouseEvent.MOUSE_DOWN,function():void{

            if(_ctrl==false){

                _ctrl = true;

                getKey("ctrl").setLight(true);

            }

            else{ 

                _ctrl = false;

                getKey("ctrl").setLight(false);

                getKey("17").setLight(false);

            }

        });

 

        // space

        btn = new Btn(90);

        btn.name = "32";

        btn.x =135;        btn.y =100;

        addChild(btn);

        keyList.push(btn);

        btn.addEventListener(MouseEvent.MOUSE_DOWN,function():void{

            _text += " ";

        });

        

        // Alt

        btn = new Btn(30);

        btn.name = "18";

        btn.x =65;        btn.y =100;

        btn.text = "Alt";

        addChild(btn);

        keyList.push(btn);

        

        // Alt2

        btn = new Btn();

        btn.name = "alt";

        btn.x =275;        btn.y =100;

        btn.text = "Alt";

        addChild(btn);    

        keyList.push(btn);  

        

        // 半角/全角

        btn = new Btn();

        btn.name = "244";

        btn.x = 0;        btn.y = 0; 

        addChild(btn);

        keyList.push(btn);



        



        

        var key:Array = new Array();

        key.push("49"); key.push("50"); key.push("51"); key.push("52"); key.push("53");

        key.push("54"); key.push("55"); key.push("56"); key.push("57"); key.push("48");

        key.push("189"); key.push("222"); key.push("220");   

        

        

        for(i=0;i<13;i++){

            btn = new Btn();

            btn.name = key[i];

            btn.x = i*25+25;            btn.y = 0;

            addChild(btn);

            keyList.push(btn);

            btn.addEventListener(MouseEvent.MOUSE_DOWN,onKeyDown);

        }

        

        key = new Array();

        key.push("81"); key.push("87"); key.push("69"); key.push("82"); key.push("84");

        key.push("89"); key.push("85"); key.push("73"); key.push("79"); key.push("80");

        key.push("192"); key.push("219");

        

            

        for(i=0;i<12;i++){

            btn = new Btn();

            btn.name = key[i];

            btn.x = i*25+35;            btn.y = 25;

            addChild(btn);

            keyList.push(btn);

            btn.addEventListener(MouseEvent.MOUSE_DOWN,onKeyDown);

        }

        

        key = new Array();

        key.push("65"); key.push("83"); key.push("68"); key.push("70"); key.push("71");

        key.push("72"); key.push("74"); key.push("75"); key.push("76"); key.push("187");

        key.push("186"); key.push("221");    

            

        for(i=0;i<12;i++){

            btn = new Btn();

            btn.name = key[i];

            btn.x = i*25+45;            btn.y = 50;

            addChild(btn);

            keyList.push(btn);

            btn.addEventListener(MouseEvent.MOUSE_DOWN,onKeyDown);

        }

        

        key = new Array();

        key.push("90"); key.push("88"); key.push("67"); key.push("86"); key.push("66");

        key.push("78"); key.push("77"); key.push("188"); key.push("190"); key.push("191");

        key.push("226");

            

        for(i=0;i<11;i++){

            btn = new Btn();

            btn.name = key[i];

            btn.x = i*25+60;            btn.y = 75;

            addChild(btn);

            keyList.push(btn);

            btn.addEventListener(MouseEvent.MOUSE_DOWN,onKeyDown); 

        }

        

        shift = false;

        

        keyLength = keyList.length;

        stage.addEventListener(KeyboardEvent.KEY_DOWN,onKey);

        stage.addEventListener(KeyboardEvent.KEY_UP,offKey);

        stage.stageFocusRect = false;

        color = 0x0000ff;



    }

    



    

    private function onKey(e:KeyboardEvent):void{

        var name:String = e.keyCode.toString();            

        if(0 < e.keyLocation){

            if(e.shiftKey==true)shift=true;

            //if(e.ctrlKey==true)ctrl=true;

        }



        

        if(1 < e.keyLocation){

            if(e.keyCode==16)getKey("shift")._down();

            if(e.keyCode==17)getKey("ctrl")._down();

            if(e.keyCode==18)getKey("alt")._down();

        }

        else{

            getKey(name)._down();

            if(33<=e.charCode && e.charCode<=126 && getKey(name).text!=" ")_text += getKey(name).text;

            //スペース

            if(e.keyCode == 32)_text += " ";

            //バックスペース

            if(e.keyCode == 8 && 0<_text.length)_text = _text.substring(0,_text.length-1);

            //エンター

            if(e.keyCode == 13)_text += "\n";

            //半角/全角

            if(e.keyCode == 244)_text += getKey(name).text;

            //タブ

            if(e.keyCode == 9)_text += "\t";

        }

    }

    

    public function set color(col:uint):void{

        _color1 = col;

        for(var i:int=0;i<keyLength;i++){

            var key:Object = getKey2(i);

            key.setColor(_color1);

            

        }



    }



    

    public function offKey(e:KeyboardEvent):void{

            var name:String = e.keyCode.toString();

            getKey(name)._up();

            if(name == "16")getKey("shift")._up();

            if(name == "17")getKey("ctrl")._up();

            if(name == "18")getKey("alt")._up();

            //if(name == "13")kb.getBtn("enter")._up();

            if(e.shiftKey==false)shift=false;

        }



    

    private function set shift(b:Boolean):void{

        

            var char:String;

            _shift = b;

            if(_shift==true)char = _charset2;

            else char = _charset1;



            for(var i:int=11;i<=59;i++){

                var key:Object = getKey2(i);

                key.text = char.charAt(i-11); 

            }

    }

    

    public function get length():int{

        return keyLength;

    }



    public function getKey2(keyNum:int):Object{

        return keyList[keyNum];

    }





    

    public function getKey(name:String):Object{

        //return this.btn.getChildByName(name); 

        return this.getChildByName(name);

    }





    

    private function onKeyDown(e:MouseEvent):void{

            _text += e.currentTarget.text;

    }

    

    public function get text():String{

        return _text;

    }

    public function set text(str:String):void{

        _text = str;

    }

    

    

    private var selectKeys:Array = new Array();

    public function selectKey(n:int,color:uint=0x00ff00):void{

        var key:Object = this.getChildAt(n);

        key.setColor(color);

        key.setLight(true);

        selectKeys.push(key);

    }

    public function resetKey():void{

        for(var i:int=0;i<selectKeys.length;i++){

            var key:Object = selectKeys[i];

            key.setLight(false);

        }

        while(0<selectKeys.length)selectKeys.pop();

    }







        

    



    

}







//////////////////////////////////////////////////

// Btnクラス

//////////////////////////////////////////////////





import flash.display.*;
import flash.text.*;
import flash.filters.GlowFilter;
import flash.events.MouseEvent;



class Btn extends Sprite {

    public var id:uint;

    private var shade:Shape;

    private var bottom:Shape;

    private var light:Shape;

    private var base:Shape;

    private var txt:TextField;

    private var label:String = "";

    private var _width:uint = 60;

    private var _height:uint = 20;

    private static var corner:uint = 3;

    private var type:uint = 1;

    private static var bColor:uint = 0x000000;

    private static var sColor:uint = 0xccccff;

    private static var upColor:uint = 0x333333;

    private static var overColor:uint = 0xccccff;

    private static var offColor:uint = 0xdddddd;

    private var gColor:uint = 0x00ff00;

    private var glow:GlowFilter;

    private var shadeGlow:GlowFilter;

    private var _clicked:Boolean = false;

    private var _enabled:Boolean = true;

    public var lightOn:Boolean = false;

    private var onSelected:Boolean = false;

    

    private var isEnterKey:Boolean = false;



    public function Btn(width:Number=20,height:Number=20) {

        _width = width;

        _height = height;

        draw();

    }



    private function draw():void {



        glow = new GlowFilter(gColor, 0.6, 5, 5, 2, 3, false, true);

        shadeGlow = new GlowFilter(sColor, 0.3, 4, 4, 2, 3, false, true);

        shade = new Shape();

        bottom = new Shape();

        light = new Shape();

        base = new Shape();

        txt = new TextField();

        

        addChild(shade);

        addChild(bottom);

        addChild(light);

        addChild(base);

        addChild(txt);



        createBase(shade, _width, _height, corner, sColor);

        shade.filters = [shadeGlow];

        createBase(bottom, _width, _height, corner, sColor, 0.3);

        createBase(light, _width, _height, corner, gColor);

        light.filters = [glow];

        

        createBase(base, _width, _height, corner, bColor);



        //txt.x = -_width*0.5;

        txt.y = _height*0.5;

        txt.width = _width;

        txt.height = _height - 1;

        txt.type = TextFieldType.DYNAMIC;

        txt.selectable = false;

        //txt.embedFonts = true;

        //txt.antiAliasType = AntiAliasType.ADVANCED;

        var tf:TextFormat = new TextFormat();

        //tf.font = fontType;

        //tf.size = 12;

        tf.align = TextFormatAlign.CENTER;

        txt.defaultTextFormat = tf;

        txt.text = label;

        enabled = true;

        mouseChildren = false;

    }

    

    public function setColor(c:uint):void{

        gColor = c;

        glow = new GlowFilter(gColor, 0.7, 8, 8, 2, 3, false, true);

        light.filters = [glow];

    }





    

    public function get text():String{

        return txt.text;

    }

    public function set text(str:String):void{

        txt.text = str;

    }

    

    public function setLight(s:Boolean):void{

        lightOn = s;

        light.visible = s;

        if(s)txt.textColor = overColor;

        else txt.textColor = upColor;

    }

    

    public function get select():Boolean{

        return lightOn;

    }



    //イベント

    private function rollOver(evt:MouseEvent):void {

        _over();

    }

    private function rollOut(evt:MouseEvent):void {

        _up();

    }

    private function press(evt:MouseEvent):void {

        _down();

    }

    private function release(evt:MouseEvent):void {

        _up();

    }

    private function click(evt:MouseEvent):void {

    }

    

    public function _up():void {

        txt.y = 0;

        

        if(this.lightOn ==false)txt.textColor = upColor;//テキストカラー

        base.y = -1;

        if(this.lightOn ==false)light.visible = false;//ライト

        light.y = -1;

    }

    private function _over():void {

        txt.y = 0;

        txt.textColor = overColor;

        base.y = -1;

        light.visible = true;

        light.y = -1;

    }

    public function _down():void {

        txt.y = 1;

        txt.textColor = overColor;

        base.y = 0;

        light.visible = true;

        light.y = 0;

    }

    private function _off():void {

        txt.y = 0;

        if(this.lightOn ==false)txt.textColor = offColor;

        base.y = 0;

        if(this.lightOn ==false)light.visible = false;

        light.y = 0;

    }

    public function get clicked():Boolean {

        return _clicked;

    }

    public function set clicked(param:Boolean):void {

        _clicked = param;

        enabled = !_clicked;

        if (_clicked) {

            _down();

        } else {

            _up();

        }

    }

    

    public function get enabled():Boolean {

        return _enabled;

    }

    

    public function set enabled(param:Boolean):void {

        _enabled = param;

        buttonMode = _enabled;

        mouseEnabled = _enabled;

        useHandCursor = _enabled;

        if (_enabled) {

            _up();

            addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);

            addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);

            addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true);

            addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);

            addEventListener(MouseEvent.CLICK, click, false, 0, true);

        } else {

            _off();

            removeEventListener(MouseEvent.MOUSE_OVER, rollOver);

            removeEventListener(MouseEvent.MOUSE_OUT, rollOut);

            removeEventListener(MouseEvent.MOUSE_DOWN, press);

            removeEventListener(MouseEvent.MOUSE_UP, release);

            removeEventListener(MouseEvent.CLICK, click);

        }

    }

    

    private function createBase(target:Shape, w:uint, h:uint, c:uint, color:uint, alpha:Number = 1):void {

        target.graphics.beginFill(color, alpha);

        target.graphics.drawRoundRect(0,0, w, h, c*2);

        target.graphics.endFill();

    }



}


